/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.channel.http;

import java.nio.charset.Charset;
import java.util.Map;
import org.noear.nami.Channel;
import org.noear.nami.ChannelBase;
import org.noear.nami.Context;
import org.noear.nami.Encoder;
import org.noear.nami.NamiException;
import org.noear.nami.NamiManager;
import org.noear.nami.Result;
import org.noear.solon.net.http.HttpResponse;
import org.noear.solon.net.http.HttpUtils;

public class HttpChannel
extends ChannelBase
implements Channel {
    public static final HttpChannel instance = new HttpChannel();

    public Result call(Context ctx) throws Throwable {
        this.pretreatment(ctx);
        boolean is_get = "GET".equals(ctx.action);
        String url = ctx.url;
        if (is_get && ctx.args.size() > 0 || ctx.body != null && ctx.args.size() > 0) {
            StringBuilder sb = new StringBuilder(ctx.url);
            sb.append(ctx.url.contains("?") ? "&" : "?");
            for (Map.Entry kv : ctx.args.entrySet()) {
                if (kv.getValue() == null) continue;
                sb.append((String)kv.getKey()).append('=').append(HttpUtils.urlEncode((String)kv.getValue().toString())).append('&');
            }
            url = sb.substring(0, sb.length() - 1);
        }
        if (ctx.config.getDecoder() == null) {
            throw new IllegalArgumentException("There is no suitable decoder");
        }
        ctx.config.getDecoder().pretreatment(ctx);
        HttpUtils http = HttpUtils.http((String)url).headers(ctx.headers).timeout(ctx.config.getTimeout());
        HttpResponse response = null;
        Encoder encoder = ctx.config.getEncoder();
        if (is_get) {
            response = http.exec("GET");
        } else if (ctx.args.size() == 0 && ctx.body == null) {
            response = http.exec("GET");
        } else {
            String ct0;
            if (encoder == null && (ct0 = ctx.headers.getOrDefault("Content-Type", "")).length() > 0) {
                encoder = NamiManager.getEncoder((String)ct0);
            }
            if (encoder != null && encoder.bodyRequired() && ctx.body == null) {
                throw new NamiException("The encoder requires parameters with '@NamiBody'");
            }
            if (ctx.body != null || encoder != null) {
                if (encoder == null) {
                    encoder = ctx.config.getEncoderOrDefault();
                }
                if (encoder == null) {
                    throw new IllegalArgumentException("There is no suitable decoder");
                }
                byte[] bytes = encoder.encode(ctx.bodyOrArgs());
                if (bytes != null) {
                    response = http.body(bytes, encoder.enctype()).exec(ctx.action);
                }
            } else {
                response = http.data(ctx.args).exec(ctx.action);
            }
        }
        if (response == null) {
            return null;
        }
        Result result = new Result(response.code(), response.bodyAsBytes());
        for (String name : response.headerNames()) {
            for (String v : response.headers(name)) {
                result.headerAdd(name, v);
            }
        }
        Charset contentEncoding = response.contentEncoding();
        if (contentEncoding != null) {
            result.charsetSet(contentEncoding);
        }
        return result;
    }
}

