/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.channel.http;

import java.nio.charset.Charset;
import java.util.Map;
import org.noear.nami.Channel;
import org.noear.nami.ChannelBase;
import org.noear.nami.Context;
import org.noear.nami.Encoder;
import org.noear.nami.NamiManager;
import org.noear.nami.Result;
import org.noear.solon.net.http.HttpResponse;
import org.noear.solon.net.http.HttpUtils;

public class HttpChannel
extends ChannelBase
implements Channel {
    public static final HttpChannel instance = new HttpChannel();

    public Result call(Context ctx) throws Throwable {
        byte[] bytes;
        this.pretreatment(ctx);
        boolean is_get = "GET".equals(ctx.action);
        String url = ctx.url;
        if (is_get && ctx.args.size() > 0 || ctx.bodyInited && ctx.args.size() > 0) {
            StringBuilder sb = new StringBuilder(ctx.url);
            sb.append(ctx.url.contains("?") ? "&" : "?");
            for (Map.Entry kv : ctx.args.entrySet()) {
                if (kv.getValue() == null) continue;
                sb.append((String)kv.getKey()).append("=").append(HttpUtils.urlEncode((String)kv.getValue().toString())).append("&");
            }
            url = sb.substring(0, sb.length() - 1);
        }
        if (ctx.config.getDecoder() == null) {
            throw new IllegalArgumentException("There is no suitable decoder");
        }
        ctx.config.getDecoder().pretreatment(ctx);
        HttpUtils http = HttpUtils.http((String)url).headers(ctx.headers).timeout(ctx.config.getTimeout());
        HttpResponse response = null;
        Encoder encoder = ctx.config.getEncoder();
        if (is_get) {
            response = http.exec("GET");
        } else if (ctx.args.size() == 0 && ctx.body == null) {
            response = http.exec(ctx.action);
        } else if (encoder == null) {
            String ct0 = ctx.headers.getOrDefault("Content-Type", "");
            if (ct0.length() == 0) {
                response = http.data(ctx.args).exec(ctx.action);
            } else {
                encoder = NamiManager.getEncoder((String)ct0);
            }
        } else {
            encoder = ctx.config.getEncoder();
        }
        if (response == null && encoder != null && (bytes = encoder.encode(ctx.body)) != null) {
            response = http.bodyRaw(bytes, encoder.enctype()).exec(ctx.action);
        }
        if (response == null) {
            return null;
        }
        Result result = new Result(response.code(), response.bodyAsBytes());
        for (String name : response.headerNames()) {
            for (String v : response.headers(name)) {
                result.headerAdd(name, v);
            }
        }
        Charset contentEncoding = response.contentEncoding();
        if (contentEncoding != null) {
            result.charsetSet(contentEncoding);
        }
        return result;
    }
}

