/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.luffy.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.noear.luffy.model.AFileModel;
import org.noear.solon.Solon;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.extend.luffy.impl.JtFunctionLoader;
import org.noear.solon.extend.luffy.impl.JtMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JtFunctionLoaderFile
implements JtFunctionLoader {
    static final Logger log = LoggerFactory.getLogger(JtFunctionLoaderFile.class);
    private File _baseDir;

    public JtFunctionLoaderFile() {
        this("./luffy/");
    }

    public JtFunctionLoaderFile(String baseDir) {
        this._baseDir = new File(baseDir);
        if (!this._baseDir.exists()) {
            this._baseDir.mkdir();
        }
    }

    @Override
    public AFileModel fileGet(String path) throws Exception {
        AFileModel file = new AFileModel();
        file.content = this.fileContentGet(path);
        if (file.content != null) {
            File file1 = new File(path);
            String fileName = file1.getName();
            file.path = path;
            file.tag = "luffy";
            if (fileName.indexOf(46) > 0) {
                String suffix = fileName.substring(fileName.indexOf(46) + 1);
                file.edit_mode = JtMapping.getActuator(suffix);
            } else {
                file.edit_mode = JtMapping.getActuator("");
            }
        }
        return file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String fileContentGet(String path) {
        if (this._baseDir == null) {
            return null;
        }
        File file = new File(this._baseDir, path);
        if (!file.exists()) return null;
        try (FileInputStream ins = new FileInputStream(file);){
            String string = IoUtil.transferToString((InputStream)ins, (String)Solon.encoding());
            return string;
        }
        catch (IOException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

