/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.luffy.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.noear.luffy.model.AFileModel;
import org.noear.solon.Solon;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.extend.luffy.impl.JtFunctionLoader;
import org.noear.solon.extend.luffy.impl.JtMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JtFunctionLoaderDebug
implements JtFunctionLoader {
    static final Logger log = LoggerFactory.getLogger(JtFunctionLoaderDebug.class);
    private String _baseUri = "/luffy/";
    private File _baseDir;

    public JtFunctionLoaderDebug() {
        String rootdir = ResourceUtil.getResource((String)"/").toString().replace("target/classes/", "");
        if (rootdir.startsWith("file:")) {
            String dir_str = rootdir + "src/main/resources" + this._baseUri;
            this._baseDir = new File(URI.create(dir_str));
            if (!this._baseDir.exists()) {
                dir_str = rootdir + "src/main/webapp" + this._baseUri;
                this._baseDir = new File(URI.create(dir_str));
            }
        }
    }

    @Override
    public AFileModel fileGet(String path) throws Exception {
        AFileModel file = new AFileModel();
        file.content = this.fileContentGet(path);
        if (file.content != null) {
            File file1 = new File(path);
            String fileName = file1.getName();
            file.path = path;
            file.tag = "luffy";
            if (fileName.indexOf(46) > 0) {
                String suffix = fileName.substring(fileName.indexOf(46) + 1);
                file.edit_mode = JtMapping.getActuator(suffix);
            } else {
                file.edit_mode = JtMapping.getActuator("");
            }
        }
        return file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String fileContentGet(String path) {
        if (this._baseDir == null) {
            return null;
        }
        File file = new File(this._baseDir, path);
        if (!file.exists()) return null;
        if (!file.isFile()) return null;
        try (FileInputStream ins = new FileInputStream(file);){
            String string = IoUtil.transferToString((InputStream)ins, (String)Solon.encoding());
            return string;
        }
        catch (IOException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

