/*
 * Decompiled with CFR 0.152.
 */
package org.noear.eggg;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.noear.eggg.ClassEggg;
import org.noear.eggg.Eggg;
import org.noear.eggg.ExecutableEggg;
import org.noear.eggg.ParamEggg;
import org.noear.eggg.TypeEggg;

public class MethodEggg
implements ExecutableEggg {
    private final ClassEggg ownerEggg;
    private final Method method;
    private MethodHandle methodHandle;
    private final TypeEggg returnTypeEggg;
    private final Map<String, Type> declaredGenericInfo;
    private final Object digest;
    private final Map<String, ParamEggg> paramEgggsForAlias;
    private final List<ParamEggg> paramAry;
    private Annotation[] annotations;
    private Parameter[] parameters;

    public MethodEggg(Eggg eggg, ClassEggg ownerEggg, Method method) {
        Objects.requireNonNull(eggg, "eggg");
        Objects.requireNonNull(ownerEggg, "ownerEggg");
        Objects.requireNonNull(method, "method");
        this.ownerEggg = ownerEggg;
        this.method = method;
        try {
            if (this.isPublic()) {
                this.methodHandle = MethodHandles.lookup().unreflect(method);
            }
        }
        catch (Throwable e) {
            this.methodHandle = null;
        }
        this.declaredGenericInfo = eggg.findGenericInfo(ownerEggg.getTypeEggg(), method.getDeclaringClass());
        this.returnTypeEggg = method.getReturnType() != Void.TYPE ? eggg.getTypeEggg(eggg.reviewType(method.getGenericReturnType(), this.declaredGenericInfo)) : eggg.getTypeEggg(method.getGenericReturnType());
        this.digest = eggg.findDigest(ownerEggg, this, null);
        if (method.getParameterCount() == 0) {
            this.paramEgggsForAlias = Collections.emptyMap();
            this.paramAry = Collections.emptyList();
        } else {
            this.paramEgggsForAlias = new LinkedHashMap<String, ParamEggg>(method.getParameterCount());
            this.paramAry = new ArrayList<ParamEggg>(method.getParameterCount());
            for (Parameter p1 : method.getParameters()) {
                ParamEggg pe = eggg.newParamEggg(ownerEggg, this, p1);
                this.paramEgggsForAlias.put(pe.getAlias(), pe);
                this.paramAry.add(pe);
            }
        }
    }

    public ClassEggg getOwnerEggg() {
        return this.ownerEggg;
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public Map<String, Type> getDeclaredGenericInfo() {
        return this.declaredGenericInfo;
    }

    @Override
    public AnnotatedElement getElement() {
        return this.method;
    }

    @Override
    public <T> T getDigest() {
        return (T)this.digest;
    }

    public TypeEggg getReturnTypeEggg() {
        return this.returnTypeEggg;
    }

    public Class<?> getReturnType() {
        return this.returnTypeEggg.getType();
    }

    public Type getGenericReturnType() {
        return this.returnTypeEggg.getGenericType();
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.method.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.method.getModifiers());
    }

    public String getName() {
        return this.method.getName();
    }

    @Override
    public Annotation[] getAnnotations() {
        if (this.annotations == null) {
            this.annotations = this.method.getAnnotations();
        }
        return this.annotations;
    }

    public Parameter[] getParameters() {
        if (this.parameters == null) {
            this.parameters = this.method.getParameters();
        }
        return this.parameters;
    }

    public int getParamCount() {
        return this.method.getParameterCount();
    }

    public Collection<ParamEggg> getParamEgggAry() {
        return this.paramAry;
    }

    public ParamEggg getParamEgggAt(int index) {
        return this.paramAry.get(index);
    }

    public ParamEggg getParamEgggByAlias(String alias) {
        return this.paramEgggsForAlias.get(alias);
    }

    public boolean hasParamEgggByAlias(String alias) {
        return this.paramEgggsForAlias.containsKey(alias);
    }

    public <T> T invoke(Object target, Object ... args) throws Throwable {
        if (this.methodHandle == null) {
            if (!this.method.isAccessible()) {
                this.method.setAccessible(true);
            }
            return (T)this.method.invoke(target, args);
        }
        if (target == null && this.isStatic()) {
            return (T)this.methodHandle.invokeWithArguments(args);
        }
        return (T)this.methodHandle.bindTo(target).invokeWithArguments(args);
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public String toString() {
        return this.method.toString();
    }
}

