/*
 * Decompiled with CFR 0.152.
 */
package org.noear.eggg;

import java.io.File;
import java.lang.reflect.Modifier;

public class JavaUtil {
    public static final int JAVA_MAJOR_VERSION;
    public static final boolean IS_WINDOWS;
    private static Class<?> recordClass;

    public static boolean isRecordClass(Class<?> clazz) {
        if (JAVA_MAJOR_VERSION < 17 || clazz == null) {
            return false;
        }
        if (!Modifier.isFinal(clazz.getModifiers())) {
            return false;
        }
        try {
            if (recordClass == null) {
                recordClass = Class.forName("java.lang.Record");
            }
            return recordClass.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    static {
        int majorVersion;
        IS_WINDOWS = File.separatorChar == '\\';
        try {
            String vs = System.getProperty("java.specification.version");
            if (vs.startsWith("1.")) {
                vs = vs.substring(2);
            }
            majorVersion = Integer.parseInt(vs);
        }
        catch (Throwable ignored) {
            majorVersion = 8;
        }
        JAVA_MAJOR_VERSION = majorVersion;
    }
}

