/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tools.java.generator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.netbeans.modules.xml.tools.generator.ValidatingTextField;
import org.netbeans.modules.xml.tools.java.generator.ElementBindings;
import org.netbeans.modules.xml.tools.java.generator.GenerateSupportUtils;
import org.netbeans.modules.xml.tools.java.generator.ParsletBindings;
import org.netbeans.modules.xml.tools.java.generator.SAXGeneratorAbstractPanel;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class SAXGeneratorParsletPanel
extends SAXGeneratorAbstractPanel {
    private static final long serialVersionUID = 6038099487791703339L;
    private TableModel tableModel;
    private static final int ELEMENT_COLUMN = 0;
    private static final int METHOD_COLUMN = 1;
    private static final int TYPE_COLUMN = 2;
    private static final int COLUMNS = 3;
    private static final String NO_METHOD = "[none]";
    private final String[] COLUMN_NAMES = new String[]{NbBundle.getMessage(SAXGeneratorParsletPanel.class, (String)"SAXGeneratorParsletPanel.table.column1"), NbBundle.getMessage(SAXGeneratorParsletPanel.class, (String)"SAXGeneratorParsletPanel.table.column2"), NbBundle.getMessage(SAXGeneratorParsletPanel.class, (String)"SAXGeneratorParsletPanel.table.column3")};
    private final ValidatingTextField.Validator TYPE_VALIDATOR = new ValidatingTextField.Validator(){

        public boolean isValid(String value) {
            boolean ret = GenerateSupportUtils.isValidReturnType(value);
            SAXGeneratorParsletPanel.this.setValid(ret);
            return ret;
        }

        public String getReason() {
            return NbBundle.getMessage(SAXGeneratorParsletPanel.class, (String)"MSG_parslet_err_1");
        }
    };
    private final ValidatingTextField.Validator METHOD_VALIDATOR = new ValidatingTextField.Validator(){

        public boolean isValid(String value) {
            boolean ret = SAXGeneratorParsletPanel.NO_METHOD.equals(value) || Utilities.isJavaIdentifier((String)value);
            SAXGeneratorParsletPanel.this.setValid(ret);
            return ret;
        }

        public String getReason() {
            return NbBundle.getMessage(SAXGeneratorParsletPanel.class, (String)"MSG_parslet_err_2");
        }
    };
    private JTextArea descTextArea;
    private JTable table;
    private JScrollPane tableScrollPane;

    private void initComponents() {
        this.descTextArea = new JTextArea();
        this.tableScrollPane = new JScrollPane();
        this.table = new JTable();
        this.setName(NbBundle.getMessage(SAXGeneratorParsletPanel.class, (String)"SAXGeneratorParsletPanel.Form.name"));
        this.setPreferredSize(new Dimension(480, 350));
        this.setLayout(new GridBagLayout());
        this.descTextArea.setEditable(false);
        this.descTextArea.setFont(UIManager.getFont("Label.font"));
        this.descTextArea.setForeground(new Color(102, 102, 153));
        this.descTextArea.setLineWrap(true);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/xml/tools/java/generator/Bundle");
        this.descTextArea.setText(bundle.getString("DESC_saxw_convertors"));
        this.descTextArea.setWrapStyleWord(true);
        this.descTextArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.descTextArea.setEnabled(false);
        this.descTextArea.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.descTextArea, gridBagConstraints);
        this.table.setModel(this.tableModel);
        this.tableScrollPane.setViewportView(this.table);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.tableScrollPane, gridBagConstraints);
    }

    private void initModels() {
        this.tableModel = new ParsletsTableModel();
    }

    @Override
    protected void initView() {
        this.initModels();
        this.initComponents();
        this.table = new ParsletsTable();
        this.table.setModel(this.tableModel);
        this.tableScrollPane.setViewportView(this.table);
        int margin = 5;
        int height = this.table.getRowHeight();
        for (int c = 0; c < this.table.getColumnCount(); ++c) {
            TableCellRenderer r = this.table.getCellRenderer(0, c);
            Component comp = this.table.prepareRenderer(r, 0, c);
            int h = comp.getPreferredSize().height;
            height = Math.max(height, h);
        }
        this.table.setRowHeight(height + margin);
        this.initAccessibility();
    }

    @Override
    protected void updateView() {
    }

    @Override
    protected void updateModel() {
    }

    public void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SAXGeneratorParsletPanel.class, (String)"ACSD_SAXGeneratorParsletPanel"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SAXGeneratorParsletPanel.class, (String)"ACSD_ParsletsTable"));
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SAXGeneratorParsletPanel.class, (String)"ACSN_ParsletsTable"));
    }

    private class ParsletsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 3516749023312029787L;

        private ParsletsTableModel() {
        }

        @Override
        public String getColumnName(int col) {
            return SAXGeneratorParsletPanel.this.COLUMN_NAMES[col];
        }

        @Override
        public int getRowCount() {
            if (SAXGeneratorParsletPanel.this.model == null) {
                return 0;
            }
            return SAXGeneratorParsletPanel.this.model.getElementBindings().size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int row, int column) {
            ElementBindings.Entry entry = SAXGeneratorParsletPanel.this.model.getElementBindings().getEntry(row);
            if (entry == null) {
                return null;
            }
            ParsletBindings parslets = SAXGeneratorParsletPanel.this.model.getParsletBindings();
            String parslet = entry.getParslet();
            switch (column) {
                case 0: {
                    return entry.getElement();
                }
                case 2: {
                    if (parslet == null) {
                        return String.class.getName();
                    }
                    return parslets.getReturnType(parslet).toString();
                }
                case 1: {
                    if (parslet == null) {
                        return SAXGeneratorParsletPanel.NO_METHOD;
                    }
                    return parslet;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }
    }

    private class ParsletsTable
    extends JTable {
        private static final long serialVersionUID = 1076091649418718319L;

        public ParsletsTable() {
            this.getTableHeader().setReorderingAllowed(false);
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            switch (column) {
                case 1: {
                    Vector all = new Vector(SAXGeneratorParsletPanel.this.model.getParsletBindings().keySet());
                    JComboBox editor = new JComboBox(all);
                    editor.addItem(SAXGeneratorParsletPanel.NO_METHOD);
                    ValidatingTextField methodInput = new ValidatingTextField();
                    methodInput.setValidator(SAXGeneratorParsletPanel.this.METHOD_VALIDATOR);
                    editor.setEditor((ComboBoxEditor)methodInput);
                    editor.setEditable(true);
                    return new DefaultCellEditor(editor);
                }
                case 2: {
                    String[] vals = new String[]{"int", "boolean", "long", "java.util.Date", "java.net.URL", "java.lang.String", "java.lang.String[]"};
                    JComboBox<String> type_editor = new JComboBox<String>(vals);
                    ValidatingTextField typeInput = new ValidatingTextField();
                    typeInput.setValidator(SAXGeneratorParsletPanel.this.TYPE_VALIDATOR);
                    type_editor.setEditor((ComboBoxEditor)typeInput);
                    type_editor.setEditable(true);
                    return new DefaultCellEditor(type_editor);
                }
            }
            return super.getCellEditor(row, column);
        }
    }
}

