/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tools.java.generator;

import java.io.IOException;
import java.net.URL;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.xml.tools.java.generator.SAXBindingsHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class SAXBindingsParser
extends DefaultHandler {
    private StringBuffer buffer;
    private SAXBindingsHandler handler;
    private Stack context;

    public SAXBindingsParser(SAXBindingsHandler handler) {
        this.handler = handler;
        this.buffer = new StringBuffer(111);
        this.context = new Stack();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startElement(String ns, String ln, String name, Attributes attrs) throws SAXException {
        this.dispatch(true);
        this.context.push(new Object[]{name, new AttributesImpl(attrs)});
        if ("parslet".equals(name)) {
            this.handler.handle_parslet(attrs);
        } else if ("SAX-bindings".equals(name)) {
            this.handler.start_SAX_bindings(attrs);
        } else if ("attbind".equals(name)) {
            this.handler.handle_attbind(attrs);
        } else if ("bind".equals(name)) {
            this.handler.start_bind(attrs);
        }
    }

    @Override
    public void endElement(String ns, String ln, String name) throws SAXException {
        this.dispatch(false);
        this.context.pop();
        if ("SAX-bindings".equals(name)) {
            this.handler.end_SAX_bindings();
        } else if ("bind".equals(name)) {
            this.handler.end_bind();
        }
    }

    @Override
    public void characters(char[] chars, int start, int len) throws SAXException {
        this.buffer.append(chars, start, len);
    }

    @Override
    public void ignorableWhitespace(char[] chars, int start, int len) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    private void dispatch(boolean fireOnlyIfMixed) throws SAXException {
        if (fireOnlyIfMixed && this.buffer.length() == 0) {
            return;
        }
        Object[] ctx = (Object[])this.context.peek();
        String here = (String)ctx[0];
        Attributes attrs = (Attributes)ctx[1];
        this.buffer.delete(0, this.buffer.length());
    }

    public void parse(InputSource input) throws SAXException, ParserConfigurationException, IOException {
        SAXBindingsParser.parse(input, this);
    }

    public void parse(URL url) throws SAXException, ParserConfigurationException, IOException {
        SAXBindingsParser.parse(new InputSource(url.toExternalForm()), this);
    }

    public static void parse(InputSource input, SAXBindingsHandler handler) throws SAXException, ParserConfigurationException, IOException {
        SAXBindingsParser.parse(input, new SAXBindingsParser(handler));
    }

    public static void parse(URL url, SAXBindingsHandler handler) throws SAXException, ParserConfigurationException, IOException {
        SAXBindingsParser.parse(new InputSource(url.toExternalForm()), handler);
    }

    private static void parse(InputSource input, SAXBindingsParser recognizer) throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(false);
        XMLReader parser = factory.newSAXParser().getXMLReader();
        parser.setContentHandler(recognizer);
        parser.setErrorHandler(recognizer.getDefaultErrorHandler());
        parser.parse(input);
    }

    private ErrorHandler getDefaultErrorHandler() {
        return new ErrorHandler(){

            @Override
            public void error(SAXParseException ex) throws SAXException {
                if (SAXBindingsParser.this.context.isEmpty()) {
                    // empty if block
                }
                throw ex;
            }

            @Override
            public void fatalError(SAXParseException ex) throws SAXException {
                throw ex;
            }

            @Override
            public void warning(SAXParseException ex) throws SAXException {
            }
        };
    }
}

