/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.api.dom;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.function.BiPredicate;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullUnknown;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.text.api.dom.SyntaxElement;
import org.netbeans.modules.xml.text.dom.BaseSyntaxElement;
import org.netbeans.modules.xml.text.dom.CDATASection;
import org.netbeans.modules.xml.text.dom.Comment;
import org.netbeans.modules.xml.text.dom.DocumentType;
import org.netbeans.modules.xml.text.dom.EmptyTag;
import org.netbeans.modules.xml.text.dom.EndTag;
import org.netbeans.modules.xml.text.dom.ProcessingInstruction;
import org.netbeans.modules.xml.text.dom.StartTag;
import org.netbeans.modules.xml.text.dom.TextImpl;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class XMLSyntaxSupport {
    private final DocumentMonitor documentMonitor;
    private final BaseDocument document;
    private static final Map<BaseDocument, Reference<XMLSyntaxSupport>> supportMap = new WeakHashMap<BaseDocument, Reference<XMLSyntaxSupport>>();
    private ThreadLocal<TokenSequence> cachedSequence = new ThreadLocal();

    private XMLSyntaxSupport(BaseDocument doc) {
        this.document = doc;
        this.documentMonitor = this.createDocumentMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentMonitor createDocumentMonitor() {
        BaseDocument baseDocument = this.document;
        synchronized (baseDocument) {
            Object o = this.document.getProperty(DocumentMonitor.class);
            if (o != null) {
                return (DocumentMonitor)o;
            }
            DocumentMonitor m = new DocumentMonitor();
            this.document.addDocumentListener((DocumentListener)m);
            this.document.putProperty(DocumentMonitor.class, (Object)m);
            return m;
        }
    }

    @CheckForNull
    public static XMLSyntaxSupport createSyntaxSupport(Document d) {
        if (d == null) {
            throw new NullPointerException("Document may not be null");
        }
        if (!(d instanceof BaseDocument)) {
            return null;
        }
        BaseDocument doc = (BaseDocument)d;
        return new XMLSyntaxSupport(doc);
    }

    @CheckForNull
    public static XMLSyntaxSupport getSyntaxSupport(Document d) {
        if (d == null) {
            throw new NullPointerException("Document may not be null");
        }
        if (!(d instanceof BaseDocument)) {
            return null;
        }
        BaseDocument doc = (BaseDocument)d;
        XMLSyntaxSupport support = null;
        Reference<XMLSyntaxSupport> refSupport = supportMap.get(doc);
        if (refSupport != null) {
            support = refSupport.get();
        }
        if (support != null) {
            return support;
        }
        support = new XMLSyntaxSupport(doc);
        supportMap.put(doc, new WeakReference<XMLSyntaxSupport>(support));
        return support;
    }

    @NonNull
    public LineDocument getDocument() {
        return this.document;
    }

    @NullUnknown
    public <T> T runLocked(Callable<T> userCode) throws BadLocationException {
        try {
            this.document.readLock();
            T t = userCode.call();
            return t;
        }
        catch (RuntimeException | BadLocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            this.document.readUnlock();
        }
    }

    private TokenSequence getSequence() {
        TokenSequence cached = this.cachedSequence.get();
        if (cached != null) {
            return cached;
        }
        TokenHierarchy th = TokenHierarchy.get((Document)this.document);
        TokenSequence ts = th.tokenSequence();
        return ts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NullUnknown
    public <T> T runWithSequence(int offset, SequenceCallable<T> userCode) throws BadLocationException {
        T result;
        TokenSequence old = null;
        try {
            this.document.readLock();
            old = this.cachedSequence.get();
            this.cachedSequence.remove();
            TokenSequence ts = this.getSequence();
            if (ts == null) {
                throw new BadLocationException("No sequence for position", offset);
            }
            this.cachedSequence.set(ts);
            TokenSequence tokenSequence = ts;
            synchronized (tokenSequence) {
                ts.move(offset);
                ts.moveNext();
                result = userCode.call(ts);
            }
            this.cachedSequence.set(old);
            this.document.readUnlock();
        }
        catch (Throwable throwable) {
            this.cachedSequence.set(old);
            this.document.readUnlock();
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runWithSequence(Token<XMLTokenId> startFrom, SequenceCallable<T> userCode) throws BadLocationException {
        T result;
        TokenSequence old = null;
        try {
            this.document.readLock();
            old = this.cachedSequence.get();
            this.cachedSequence.remove();
            TokenHierarchy th = TokenHierarchy.get((Document)this.document);
            TokenSequence ts = th.tokenSequence();
            if (ts == null) {
                throw new BadLocationException("No sequence for position", startFrom.offset(null));
            }
            this.cachedSequence.set(ts);
            TokenSequence tokenSequence = ts;
            synchronized (tokenSequence) {
                ts.move(startFrom.offset(th));
                ts.moveNext();
                result = userCode.call(ts);
            }
            this.cachedSequence.set(old);
            this.document.readUnlock();
        }
        catch (Throwable throwable) {
            this.cachedSequence.set(old);
            this.document.readUnlock();
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token<XMLTokenId> getPreviousToken(int offset) throws BadLocationException {
        if (offset == 0) {
            return null;
        }
        if (offset < 0) {
            throw new BadLocationException("Offset " + offset + " cannot be less than 0.", offset);
        }
        this.document.readLock();
        try {
            TokenSequence ts;
            TokenSequence tokenSequence = ts = this.getSequence();
            synchronized (tokenSequence) {
                Token token = this.getToken(ts, offset, false, null);
                return token;
            }
        }
        finally {
            this.document.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token<XMLTokenId> getPreviousToken(int offset, int[] tokenBounds) throws BadLocationException {
        if (offset == 0) {
            return null;
        }
        if (offset < 0) {
            throw new BadLocationException("Offset " + offset + " cannot be less than 0.", offset);
        }
        this.document.readLock();
        try {
            TokenSequence ts;
            TokenSequence tokenSequence = ts = this.getSequence();
            synchronized (tokenSequence) {
                Token token = this.getToken(ts, offset, false, tokenBounds);
                return token;
            }
        }
        finally {
            this.document.readUnlock();
        }
    }

    public Token<XMLTokenId> getTokenAtPosition(int offset, int[] tokenBounds) throws BadLocationException {
        return this.getNextToken(offset + 1, tokenBounds);
    }

    public Token<XMLTokenId> getAttributeToken(int offset) {
        try {
            return this.runWithSequence(offset, (TokenSequence ts) -> {
                Token t;
                Token currentToken = ts.token();
                if (currentToken.id() != XMLTokenId.VALUE) {
                    return null;
                }
                Token equalsToken = null;
                while (ts.movePrevious()) {
                    t = ts.token();
                    if (t.id() == XMLTokenId.OPERATOR) {
                        equalsToken = t;
                        break;
                    }
                    if (t.id() == XMLTokenId.ARGUMENT) {
                        return t;
                    }
                    if (t.id() == XMLTokenId.WS) continue;
                    return null;
                }
                if (equalsToken == null) {
                    return null;
                }
                while (ts.movePrevious()) {
                    t = ts.token();
                    if (t.id() == XMLTokenId.ARGUMENT) {
                        return t;
                    }
                    if (t.id() == XMLTokenId.WS) continue;
                    return null;
                }
                return null;
            });
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token<XMLTokenId> getNextToken(int offset) throws BadLocationException {
        if (offset == 0) {
            offset = 1;
        }
        if (offset < 0) {
            throw new BadLocationException("Offset " + offset + " cannot be less than 0.", offset);
        }
        this.document.readLock();
        try {
            TokenSequence ts;
            TokenSequence tokenSequence = ts = this.getSequence();
            synchronized (tokenSequence) {
                Token token = this.getToken(ts, offset, true, null);
                return token;
            }
        }
        finally {
            this.document.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token getNextToken(int offset, int[] tokenBounds) throws BadLocationException {
        if (offset == 0) {
            return null;
        }
        if (offset < 0) {
            throw new BadLocationException("Offset " + offset + " cannot be less than 0.", offset);
        }
        this.document.readLock();
        try {
            TokenSequence ts;
            TokenSequence tokenSequence = ts = this.getSequence();
            synchronized (tokenSequence) {
                Token token = this.getToken(ts, offset, true, tokenBounds);
                return token;
            }
        }
        finally {
            this.document.readUnlock();
        }
    }

    private Token getToken(TokenSequence ts, int offset, boolean next, int[] startOffset) {
        int diff = ts.move(offset);
        boolean ok = next ? ts.moveNext() : (diff > 0 ? ts.moveNext() : ts.movePrevious());
        if (!ok) {
            return null;
        }
        if (startOffset != null) {
            startOffset[0] = ts.offset();
            if (startOffset.length > 1) {
                startOffset[1] = ts.offset() + ts.token().length();
            }
        }
        return ts.token();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SyntaxElement getElementChain(int offset) throws BadLocationException {
        Token token;
        TokenSequence ts;
        block17: {
            this.document.readLock();
            ts = this.getSequence();
            token = this.initialize(ts, offset);
            if (token == null) {
                SyntaxElement syntaxElement = null;
                return syntaxElement;
            }
            while (token.id() == XMLTokenId.CHARACTER) {
                if (!ts.movePrevious()) {
                    SyntaxElement syntaxElement = null;
                    return syntaxElement;
                }
                token = ts.token();
            }
            switch ((XMLTokenId)token.id()) {
                case PI_START: 
                case PI_END: 
                case PI_CONTENT: 
                case PI_TARGET: {
                    Token first = token;
                    while (token.id() != XMLTokenId.PI_START && ts.movePrevious()) {
                        token = ts.token();
                    }
                    SyntaxElement syntaxElement = this.createElement(ts, (Token<XMLTokenId>)token);
                    return syntaxElement;
                }
                case CHARACTER: {
                    break block17;
                }
                case TEXT: 
                case DECLARATION: 
                case CDATA_SECTION: 
                case BLOCK_COMMENT: 
                case TAG: 
                case ERROR: {
                    SyntaxElement syntaxElement = this.createElement(ts, (Token<XMLTokenId>)token);
                    return syntaxElement;
                }
                default: {
                    return null;
                }
            }
            finally {
                this.document.readUnlock();
            }
        }
        while ((token.id() == XMLTokenId.CHARACTER || token.id() == XMLTokenId.TEXT) && ts.movePrevious()) {
            token = ts.token();
        }
        SyntaxElement syntaxElement = this.createElement(ts, (Token<XMLTokenId>)token);
        return syntaxElement;
    }

    private Token<XMLTokenId> initialize(TokenSequence ts, int offset) {
        Token token;
        block4: {
            int diff = ts.move(offset);
            token = ts.token();
            if (diff > 0 ? !ts.moveNext() : !ts.movePrevious()) {
                return null;
            }
            token = ts.token();
            XMLTokenId id = (XMLTokenId)token.id();
            while (token.id() == XMLTokenId.CHARACTER) {
                if (!ts.movePrevious()) {
                    return token;
                }
                token = ts.token();
                id = (XMLTokenId)token.id();
            }
            String image = token.text().toString();
            if (id != XMLTokenId.WS && id != XMLTokenId.ARGUMENT && id != XMLTokenId.OPERATOR && id != XMLTokenId.VALUE && (id != XMLTokenId.TAG || !">".equals(image) && !"/>".equals(image))) break block4;
            while (ts.movePrevious() && (id = (XMLTokenId)(token = ts.token()).id()) != XMLTokenId.TAG && id != XMLTokenId.PI_START && id != XMLTokenId.DECLARATION) {
            }
        }
        return token;
    }

    private SyntaxElement createElement(TokenSequence ts, Token<XMLTokenId> token) throws BadLocationException {
        int start = ts.offset();
        int end = start + token.length();
        switch ((XMLTokenId)token.id()) {
            case PI_START: {
                String target = null;
                String content = null;
                Token t = token;
                while (t.id() != XMLTokenId.PI_END) {
                    if (t.id() == XMLTokenId.PI_TARGET) {
                        target = t.text().toString();
                    }
                    if (t.id() == XMLTokenId.PI_CONTENT) {
                        content = t.text().toString();
                    }
                    if (!ts.moveNext()) break;
                    t = ts.token();
                }
                end = ts.offset() + t.length();
                return new ProcessingInstruction(this, (Token<XMLTokenId>)token, start, end, target, content);
            }
            case DECLARATION: {
                Token t = token;
                do {
                    if (t.id() == XMLTokenId.DECLARATION) {
                        if (t.length() == 1 && t.text().charAt(0) == '>') {
                            end = ts.offset() + t.length();
                            break;
                        }
                    } else if (t.id() != XMLTokenId.VALUE) {
                        end = ts.offset();
                        break;
                    }
                    end = ts.offset() + t.length();
                    t = ts.token();
                } while (ts.moveNext());
                return new DocumentType(this, (Token<XMLTokenId>)token, start, end);
            }
            case CDATA_SECTION: {
                return new CDATASection(this, (Token<XMLTokenId>)token, start, end);
            }
            case BLOCK_COMMENT: {
                return new Comment(this, (Token<XMLTokenId>)token, start, end);
            }
            case CHARACTER: 
            case TEXT: {
                end = ts.offset() + token.length();
                Token tukac = token;
                while (tukac.id() == XMLTokenId.CHARACTER || tukac.id() == XMLTokenId.TEXT) {
                    end = ts.offset() + tukac.length();
                    if (!ts.moveNext()) break;
                    tukac = ts.token();
                }
                return new TextImpl(this, token, start, end);
            }
            case TAG: {
                Token t = token;
                while (ts.moveNext() && (t = ts.token()).id() != XMLTokenId.TAG) {
                }
                end = ts.offset() + t.length();
                if (t.text().toString().equals("/>")) {
                    return new EmptyTag(this, (Token<XMLTokenId>)token, start, end);
                }
                if (token.text().toString().startsWith("</")) {
                    return new EndTag(this, (Token<XMLTokenId>)token, start, end);
                }
                return new StartTag(this, (Token<XMLTokenId>)token, start, end);
            }
            case ERROR: {
                return new BaseSyntaxElement.Error(this, token, start, end);
            }
        }
        return null;
    }

    public final char lastTypedChar() {
        return this.documentMonitor.lastInsertedChar;
    }

    public boolean isNormalTag(SyntaxElement n) {
        return this.isStartTag(n) || this.isEndTag(n);
    }

    public boolean isStartTag(SyntaxElement n) {
        return n instanceof StartTag;
    }

    public boolean isEmptyTag(SyntaxElement n) {
        return n instanceof EmptyTag;
    }

    public boolean isEndTag(SyntaxElement n) {
        return n instanceof EndTag;
    }

    public int getNodeOffset(Node n) {
        if (!(n instanceof SyntaxElement)) {
            if (n instanceof Document) {
                return 0;
            }
            return -1;
        }
        return ((SyntaxElement)((Object)n)).getElementOffset();
    }

    public SyntaxElement getSyntaxElement(Node n) {
        if (n instanceof SyntaxElement) {
            return (SyntaxElement)((Object)n);
        }
        return null;
    }

    public static String getAttributeValue(Node n, String name) {
        NamedNodeMap a = n.getAttributes();
        if (a == null) {
            return null;
        }
        Node item = a.getNamedItem(name);
        if (item == null) {
            return null;
        }
        return item.getNodeValue();
    }

    public List<SyntaxElement> getPathFromRoot(SyntaxElement element) {
        ArrayDeque<SyntaxElement> stack = new ArrayDeque<SyntaxElement>();
        SyntaxElement elementRef = element;
        while (elementRef != null) {
            if (this.isEndTag(element) || this.isEmptyTag(elementRef) && stack.isEmpty() || this.isStartTag(elementRef) && stack.isEmpty()) {
                stack.push(elementRef);
                elementRef = elementRef.getPrevious();
                continue;
            }
            if (this.isStartTag(elementRef)) {
                if (this.isEndTag((SyntaxElement)stack.peek())) {
                    SyntaxElement end = (SyntaxElement)stack.peek();
                    if (end.getNode().getNodeName().equals(elementRef.getNode().getNodeName())) {
                        stack.pop();
                    }
                } else {
                    SyntaxElement e = (SyntaxElement)stack.peek();
                    stack.push(elementRef);
                }
            }
            elementRef = elementRef.getPrevious();
        }
        ArrayList<SyntaxElement> res = new ArrayList<SyntaxElement>(stack.size());
        while ((elementRef = (SyntaxElement)stack.poll()) != null) {
            res.add(elementRef);
        }
        return res;
    }

    public Token<XMLTokenId> skip(int offset, boolean forward, XMLTokenId ... skipTokens) throws BadLocationException {
        EnumSet<XMLTokenId> en = EnumSet.copyOf(Arrays.asList(skipTokens));
        return this.skip(offset, forward, (TokenSequence s, Token<XMLTokenId> t) -> en.contains(t.id()));
    }

    public Token<XMLTokenId> skip(int offset, boolean forward, BiPredicate<TokenSequence, Token<XMLTokenId>> pred) throws BadLocationException {
        Token tukac = this.runWithSequence(offset, (TokenSequence s) -> {
            s.move(offset);
            while (forward && s.moveNext() || !forward && s.movePrevious()) {
                if (pred.test(s, s.token())) continue;
                return s.token();
            }
            return null;
        });
        return tukac;
    }

    private static class DocumentMonitor
    implements DocumentListener {
        private char lastInsertedChar = (char)88;

        private DocumentMonitor() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            int start = e.getOffset();
            int len = e.getLength();
            try {
                String s = e.getDocument().getText(start + len - 1, 1);
                this.lastInsertedChar = s.charAt(0);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
        }
    }

    public static interface SequenceCallable<T> {
        public T call(@NonNull TokenSequence var1) throws BadLocationException;
    }
}

