/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.parser;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import org.netbeans.modules.xml.tax.parser.Util;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;

public final class ParserLoader
extends URLClassLoader {
    private static final String PARSER_PACKAGE = "org.apache.xerces";
    private static final String[] USER_PREFIXES = new String[]{"org.netbeans.tax.io.XNIBuilder", "org.netbeans.modules.xml.tools.action.XMLCompiler"};
    private static final String CODENAME_BASE = "org.netbeans.modules.xml.tax";
    private static final String XERCES_ARCHIVE = "modules/autoload/ext/xerces2.jar";
    private static final String MODULE_ARCHIVE = "modules/autoload/xml-tax.jar";
    private ClassLoader parentLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
    private static ParserLoader instance = null;

    private ParserLoader(URL[] locations) {
        super(locations);
    }

    public static synchronized ParserLoader getInstance() {
        block5: {
            if (instance != null) {
                return instance;
            }
            try {
                InstalledFileLocator installedFileLocator = InstalledFileLocator.getDefault();
                URL xer2url = installedFileLocator.locate(XERCES_ARCHIVE, CODENAME_BASE, false).toURL();
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("Isolated library URL=" + xer2url);
                }
                URL module = installedFileLocator.locate(MODULE_ARCHIVE, CODENAME_BASE, false).toURL();
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("Isolated module URL=" + module);
                }
                instance = new ParserLoader(new URL[]{xer2url, module});
            }
            catch (MalformedURLException ex) {
                if (!Util.THIS.isLoggable()) break block5;
                Util.THIS.debug(ex);
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (name.startsWith(PARSER_PACKAGE)) {
            clazz = super.findLoadedClass(name);
            if (clazz == null) {
                clazz = super.findClass(name);
            }
        } else {
            for (int i = 0; i < USER_PREFIXES.length; ++i) {
                if (!name.startsWith(USER_PREFIXES[i])) continue;
                ParserLoader parserLoader = this;
                synchronized (parserLoader) {
                    clazz = super.findLoadedClass(name);
                    if (clazz == null) {
                        clazz = super.findClass(name);
                    }
                    continue;
                }
            }
            if (clazz == null) {
                clazz = this.parentLoader.loadClass(name);
            }
        }
        return clazz;
    }

    @Override
    public URL getResource(String name) {
        URL in = super.getResource(name);
        if (in == null) {
            in = this.parentLoader.getResource(name);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Resource: " + name + " =>" + in);
        }
        return in;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        try {
            URL url = this.getResource(name);
            if (url == null) {
                return null;
            }
            return url.openStream();
        }
        catch (IOException ex) {
            return null;
        }
    }

    public Enumeration findResources(String name) throws IOException {
        Enumeration<URL> en1 = super.findResources(name);
        Enumeration<URL> en2 = this.parentLoader.getResources(name);
        return Enumerations.concat(en1, en2);
    }

    public static void main(String[] args) throws Exception {
        ParserLoader me = ParserLoader.getInstance();
        Class apache = me.loadClass("org.apache.xerces.util.QName");
        Class java = me.loadClass("java.lang.String");
        Class netbeans = me.loadClass("org.openide.util.Mutex");
        System.err.println("apache " + apache.getClassLoader());
        System.err.println("netbeans " + netbeans.getClassLoader());
        System.err.println("java " + java.getClassLoader());
    }
}

