/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.cookies;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.ref.WeakReference;
import javax.swing.text.Document;
import org.netbeans.modules.xml.DTDDataObject;
import org.netbeans.modules.xml.XMLDataObject;
import org.netbeans.modules.xml.XMLDataObjectLook;
import org.netbeans.modules.xml.cookies.CookieFactory;
import org.netbeans.modules.xml.cookies.CookieManagerCookie;
import org.netbeans.modules.xml.cookies.UpdateDocumentCookie;
import org.netbeans.modules.xml.sync.Representation;
import org.netbeans.modules.xml.tax.cookies.DTDTreeRepresentation;
import org.netbeans.modules.xml.tax.cookies.TreeDocumentCookie;
import org.netbeans.modules.xml.tax.cookies.TreeEditorCookie;
import org.netbeans.modules.xml.tax.cookies.Util;
import org.netbeans.modules.xml.tax.cookies.XMLTreeRepresentation;
import org.netbeans.modules.xml.tax.parser.DTDParsingSupport;
import org.netbeans.modules.xml.tax.parser.ParsingSupport;
import org.netbeans.modules.xml.tax.parser.XMLParsingSupport;
import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.TreeDocument;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeDocumentType;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.event.TreeEvent;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.Utilities;
import org.xml.sax.InputSource;

public class TreeEditorCookieImpl
implements TreeEditorCookie,
UpdateDocumentCookie {
    private Task prepareTask;
    private final Exception[] prepareException = new Exception[1];
    private XMLDataObjectLook xmlDO;
    private final PropertyChangeSupport pchs;
    private final CookieManagerCookie cookieMgr;
    private int status;
    private int oldStatus;
    private TreeReference tree;
    private Object treeLock = new TreeLock();
    private PropertyChangeListener treeListener = null;
    private TreeDocumentCookie treeDocumentCookie;
    private Representation rep;

    public TreeEditorCookieImpl(XMLDataObjectLook xmlDO) {
        this.xmlDO = xmlDO;
        this.cookieMgr = xmlDO.getCookieManager();
        this.oldStatus = this.status = 0;
        this.pchs = new PropertyChangeSupport(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TreeDocumentRoot openDocumentRoot() throws IOException, TreeException {
        TreeDocumentRoot root;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeEditorCookieImpl.openDocumentRoot()");
        }
        while (true) {
            this.prepareDocumentRoot().waitFinished();
            TreeEditorCookieImpl treeEditorCookieImpl = this;
            synchronized (treeEditorCookieImpl) {
                root = this.getDocumentRoot();
                if (root != null) break;
                if (this.prepareException[0] instanceof IOException) {
                    throw (IOException)this.prepareException[0];
                }
                if (this.prepareException[0] instanceof TreeException) {
                    throw (TreeException)((Object)this.prepareException[0]);
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("\tTree parsing retry due to (expected null): " + this.prepareException[0]);
                }
                this.prepareTask = null;
            }
        }
        {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("TreeEditorCookieImpl.openDocumentRoot() = " + root);
            }
            return root;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task prepareDocumentRoot() {
        TreeEditorCookieImpl treeEditorCookieImpl = this;
        synchronized (treeEditorCookieImpl) {
            if (this.prepareTask != null) {
                return this.prepareTask;
            }
            this.prepareTask = new Task(new Runnable(){

                @Override
                public void run() {
                    try {
                        InputSource src = TreeEditorCookieImpl.this.inputSource();
                        TreeEditorCookieImpl.this.parseTree(src, true);
                        ((TreeEditorCookieImpl)TreeEditorCookieImpl.this).prepareException[0] = null;
                    }
                    catch (IOException ex) {
                        ErrorManager em = ErrorManager.getDefault();
                        em.annotate((Throwable)ex, Util.THIS.getString("BK0001"));
                        ((TreeEditorCookieImpl)TreeEditorCookieImpl.this).prepareException[0] = ex;
                    }
                    catch (TreeException ex) {
                        ErrorManager em = ErrorManager.getDefault();
                        em.annotate((Throwable)ex, Util.THIS.getString("BK0001"));
                        ((TreeEditorCookieImpl)TreeEditorCookieImpl.this).prepareException[0] = ex;
                    }
                    TreeEditorCookieImpl.this.fireTreeAndStatus();
                }
            });
        }
        new Thread((Runnable)this.prepareTask, "Parsing tree...").start();
        return this.prepareTask;
    }

    @Override
    public TreeDocumentRoot getDocumentRoot() {
        if (this.tree == null) {
            return null;
        }
        TreeDocumentRoot root = this.tree.getDocumentRoot();
        if (root == null) {
            return null;
        }
        return root;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pchs.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pchs.removePropertyChangeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTree(TreeDocumentRoot doc) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeEditorCookieImpl::setTree: " + doc);
        }
        if (doc == this.getDocumentRoot() && doc != null) {
            return;
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\tdifferent doc delivered, merging");
        }
        TreeDocumentRoot oldTreeDoc = this.getDocumentRoot();
        try {
            if (doc == null) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("\tbefore REMOVE : " + this.getDocumentRoot());
                }
                this.removeTreeDocumentCookie();
                if (this.rep != null) {
                    // empty if block
                }
                if (this.getDocumentRoot() != null) {
                    ((TreeObject)this.getDocumentRoot()).removePropertyChangeListener(this.treeListener);
                    this.treeListener = null;
                }
                this.tree = null;
            } else if (this.tree == null) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("\tbefore ADD : " + this.getDocumentRoot());
                }
                this.tree = new TreeReference(doc);
                this.treeListener = new TreeListener();
                ((TreeObject)this.getDocumentRoot()).addPropertyChangeListener(this.treeListener);
                this.addTreeDocumentCookie();
            } else {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("\tbefore MERGE : " + this.getDocumentRoot());
                }
                TreeObject root = (TreeObject)this.getDocumentRoot();
                root.removePropertyChangeListener(this.treeListener);
                root.merge((TreeObject)doc);
                root.addPropertyChangeListener(this.treeListener);
            }
            if (this.rep == null) {
                this.rep = this.xmlDO instanceof XMLDataObject ? new XMLTreeRepresentation(this, this.xmlDO.getSyncInterface()) : new DTDTreeRepresentation(this, this.xmlDO.getSyncInterface());
                this.xmlDO.getSyncInterface().addRepresentation(this.rep);
            }
        }
        catch (CannotMergeException exc) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("MERGE FATAL ERROR:");
            }
            exc.printStackTrace();
        }
    }

    public void updateTree(Object input) {
        try {
            this.parseTree((InputSource)input, false);
        }
        catch (TreeException treeException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fireTreeAndStatus();
    }

    private void parseTree(InputSource input, boolean force) throws TreeException, IOException {
        block15: {
            if (input == null) {
                throw new IOException();
            }
            String annotation = null;
            if (this.status == 0 && this.getDocumentRoot() == null && !force) {
                return;
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("XMLTreeEditorCookieImpl::updateTree(force=" + force + ")");
            }
            try {
                ParsingSupport parser = null;
                if (this.xmlDO instanceof XMLDataObject) {
                    parser = new XMLParsingSupport();
                } else if (this.xmlDO instanceof DTDDataObject) {
                    parser = new DTDParsingSupport();
                } else if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("parseTree() Unexpected instance: " + this.xmlDO.getClass());
                }
                annotation = Util.THIS.getString("MSG_Unexpected_exception_in_parser_or_handler");
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("PARSING: " + input.getSystemId());
                }
                TreeDocumentRoot doc = parser.parse(input);
                annotation = Util.THIS.getString("MSG_Unexpected_exception_in_merge");
                this.setTreeAndStatus(doc, 1);
            }
            catch (Exception ex) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("XMLTreeEditorCookieImpl::updateTree", ex);
                }
                this.setTreeAndStatus(null, 3);
                Util.THIS.getErrorManager().annotate((Throwable)ex, annotation);
                Util.THIS.debug(ex);
                if (ex instanceof TreeException || ex instanceof IOException) {
                    if (ex instanceof IOException) {
                        throw (IOException)ex;
                    }
                    if (ex instanceof TreeException) {
                        throw (TreeException)((Object)ex);
                    }
                }
                if (!(ex instanceof RuntimeException)) break block15;
                throw new TreeException(ex);
            }
        }
    }

    private void addTreeDocumentCookie() {
        this.treeDocumentCookie = new TreeDocumentCookieImpl();
        this.cookieMgr.addCookie((Node.Cookie)this.treeDocumentCookie);
    }

    private void removeTreeDocumentCookie() {
        if (this.treeDocumentCookie != null) {
            this.cookieMgr.removeCookie((Node.Cookie)this.treeDocumentCookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTreeAndStatus(TreeDocumentRoot doc, int newStatus) {
        Object object = this.treeLock;
        synchronized (object) {
            this.setTree(doc);
            this.oldStatus = this.status;
            this.status = newStatus;
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Tree status transition: " + this.oldStatus + "=>" + newStatus);
            }
        }
    }

    private void fireTreeAndStatus() {
        final int fireStatus = this.status;
        final int fireOldStatus = this.oldStatus;
        final TreeDocumentRoot fireTree = this.getDocumentRoot();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Firing tree status transition: " + this.oldStatus + "=>" + this.status);
        }
        RequestProcessor.postRequest((Runnable)new Runnable(){

            @Override
            public void run() {
                TreeEditorCookieImpl.this.pchs.firePropertyChange("status", fireOldStatus, fireStatus);
                TreeEditorCookieImpl.this.pchs.firePropertyChange("documentRoot", null, fireTree);
            }
        });
    }

    public void updateDocumentRoot() {
        TreeDocumentCookie cookie = (TreeDocumentCookie)this.xmlDO.getCookie(TreeDocumentCookie.class);
        if (cookie != null && cookie.getDocumentRoot() != null) {
            Task task = new Task(new Runnable(){

                @Override
                public void run() {
                    try {
                        TreeEditorCookieImpl.this.parseTree(TreeEditorCookieImpl.this.inputSource(), true);
                    }
                    catch (TreeException ex) {
                        Util.THIS.debug(ex);
                    }
                    catch (IOException ex) {
                        Util.THIS.debug(ex);
                    }
                }
            });
            this.xmlDO.getSyncInterface().postRequest((Runnable)task);
            task.waitFinished();
            this.fireTreeAndStatus();
        }
    }

    private InputSource inputSource() {
        Representation primary = this.xmlDO.getSyncInterface().getPrimaryRepresentation();
        InputSource src = (InputSource)primary.getChange(InputSource.class);
        if (src == null && Util.THIS.isLoggable()) {
            Util.THIS.debug("Primary representation can not provide InputSource: " + primary);
        }
        return src;
    }

    private class TreeLock {
        private TreeLock() {
        }
    }

    public static class CookieFactoryImpl
    extends CookieFactory {
        private WeakReference<TreeEditorCookieImpl> editor;
        private final XMLDataObjectLook dobj;

        public CookieFactoryImpl(XMLDataObjectLook dobj) {
            this.dobj = dobj;
        }

        public Node.Cookie createCookie(Class klass) {
            if (klass.isAssignableFrom(TreeEditorCookie.class)) {
                return this.createEditor();
            }
            if (klass.isAssignableFrom(UpdateDocumentCookie.class)) {
                return this.createEditor();
            }
            return null;
        }

        private synchronized TreeEditorCookieImpl createEditor() {
            if (this.editor == null) {
                return this.prepareEditor();
            }
            TreeEditorCookieImpl cached = (TreeEditorCookieImpl)this.editor.get();
            if (cached == null) {
                return this.prepareEditor();
            }
            return cached;
        }

        private TreeEditorCookieImpl prepareEditor() {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Initializing TreeEditorCookieImpl ...");
            }
            TreeEditorCookieImpl cake = new TreeEditorCookieImpl(this.dobj);
            this.editor = new WeakReference<TreeEditorCookieImpl>(cake);
            return cake;
        }

        public Class[] supportedCookies() {
            return new Class[]{TreeEditorCookie.class, UpdateDocumentCookie.class};
        }
    }

    private class TreeReference
    extends WeakReference<TreeDocumentRoot>
    implements Runnable {
        TreeReference(TreeDocumentRoot root) {
            super(root, Utilities.activeReferenceQueue());
        }

        public TreeDocumentRoot getDocumentRoot() {
            return (TreeDocumentRoot)super.get();
        }

        public TreeEditorCookieImpl getEditor() {
            return TreeEditorCookieImpl.this;
        }

        public String toString() {
            return "TreeReference[" + this.getEditor().xmlDO.getName() + "]";
        }

        @Override
        public void run() {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("" + this + " reclaimed.");
            }
            this.getEditor().setTreeAndStatus(null, 0);
            this.getEditor().fireTreeAndStatus();
        }
    }

    private class TreeListener
    implements PropertyChangeListener {
        private PropertyChangeEvent last;

        private TreeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("!!! TreeEditorCookieImpl::TreeListener::propertyChange: propertyName = '" + e.getPropertyName() + "'");
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("!!!                  ::TreeListener::propertyChange: last = " + this.last);
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("!!!                  ::TreeListener::propertyChange: e    = " + e);
            }
            if (e != this.last) {
                this.last = e;
                TreeEditorCookieImpl.this.xmlDO.getSyncInterface().representationChanged(TreeDocument.class);
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("!!!                  ::TreeListener::propertyChange: *after* representationChanged (TreeDocument.class)");
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("!!!                  ::TreeListener::propertyChange: ( e instanceof TreeEvent ) => " + (e instanceof TreeEvent));
                }
                boolean updateFromText = false;
                if (e instanceof TreeEvent && ((TreeEvent)e).isBubbling()) {
                    TreeEvent treeEvent = (TreeEvent)e;
                    if (treeEvent.getOriginalSource() instanceof TreeDocumentType && ("publicId".equals(treeEvent.getOriginalPropertyName()) || "systemId".equals(treeEvent.getOriginalPropertyName()))) {
                        updateFromText = true;
                    }
                } else if ("childList".equals(e.getPropertyName()) && e.getNewValue() instanceof TreeDocumentType) {
                    updateFromText = true;
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("!!!                  ::TreeListener::propertyChange: updateFromText = " + updateFromText);
                }
                if (updateFromText) {
                    TreeEditorCookieImpl.this.xmlDO.getSyncInterface().representationChanged(Document.class);
                }
            }
        }
    }

    private class TreeDocumentCookieImpl
    implements TreeDocumentCookie {
        private TreeDocumentCookieImpl() {
        }

        @Override
        public TreeDocumentRoot getDocumentRoot() {
            try {
                return TreeEditorCookieImpl.this.openDocumentRoot();
            }
            catch (IOException ex) {
                return null;
            }
            catch (TreeException ex) {
                return null;
            }
        }
    }
}

