/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi;

import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AnyAttribute;
import org.netbeans.modules.xml.axi.AnyElement;
import org.netbeans.modules.xml.axi.Attribute;
import org.netbeans.modules.xml.axi.Compositor;
import org.netbeans.modules.xml.axi.ContentModel;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.SchemaReference;
import org.netbeans.modules.xml.axi.impl.AnyAttributeProxy;
import org.netbeans.modules.xml.axi.impl.AnyElementProxy;
import org.netbeans.modules.xml.axi.impl.AttributeImpl;
import org.netbeans.modules.xml.axi.impl.AttributeProxy;
import org.netbeans.modules.xml.axi.impl.AttributeRef;
import org.netbeans.modules.xml.axi.impl.CompositorProxy;
import org.netbeans.modules.xml.axi.impl.ElementImpl;
import org.netbeans.modules.xml.axi.impl.ElementProxy;
import org.netbeans.modules.xml.axi.impl.ElementRef;
import org.netbeans.modules.xml.axi.impl.SchemaReferenceProxy;
import org.netbeans.modules.xml.axi.visitor.DefaultVisitor;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;

public class AXIComponentFactory {
    private AXIModel model;
    private long elementCount;
    private long attributeCount;
    private long compositorCount;
    private long contentModelCount;
    private long proxyComponentCount;

    AXIComponentFactory(AXIModel model) {
        this.model = model;
    }

    public long getComponentCount() {
        return this.elementCount + this.attributeCount + this.compositorCount + this.contentModelCount + this.proxyComponentCount + 1L;
    }

    public AXIComponent copy(AXIComponent original) {
        AXICopier copier = new AXICopier(this.model);
        return copier.copy(original);
    }

    public Element createElement() {
        ++this.elementCount;
        return new ElementImpl(this.model);
    }

    public Element createElement(SchemaComponent component) {
        ++this.elementCount;
        return new ElementImpl(this.model, component);
    }

    public Element createElementReference(Element referent) {
        ++this.elementCount;
        return new ElementRef(this.model, referent);
    }

    public Element createElementReference(SchemaComponent component, Element referent) {
        ++this.elementCount;
        return new ElementRef(this.model, component, referent);
    }

    public Attribute createAttribute() {
        ++this.attributeCount;
        return new AttributeImpl(this.model);
    }

    public Attribute createAttribute(SchemaComponent component) {
        ++this.attributeCount;
        return new AttributeImpl(this.model, component);
    }

    public Attribute createAttributeReference(Attribute referent) {
        ++this.attributeCount;
        return new AttributeRef(this.model, referent);
    }

    public Attribute createAttributeReference(SchemaComponent component, Attribute referent) {
        ++this.attributeCount;
        return new AttributeRef(this.model, component, referent);
    }

    public Compositor createCompositor(Compositor.CompositorType type) {
        ++this.compositorCount;
        Compositor compositor = new Compositor(this.model, type);
        return compositor;
    }

    public Compositor createSequence() {
        ++this.compositorCount;
        return new Compositor(this.model, Compositor.CompositorType.SEQUENCE);
    }

    public Compositor createSequence(SchemaComponent component) {
        ++this.compositorCount;
        Compositor compositor = new Compositor(this.model, component);
        return compositor;
    }

    public Compositor createChoice() {
        ++this.compositorCount;
        return new Compositor(this.model, Compositor.CompositorType.CHOICE);
    }

    public Compositor createChoice(SchemaComponent component) {
        ++this.compositorCount;
        Compositor compositor = new Compositor(this.model, component);
        return compositor;
    }

    public Compositor createAll() {
        ++this.compositorCount;
        return new Compositor(this.model, Compositor.CompositorType.ALL);
    }

    public Compositor createAll(SchemaComponent component) {
        ++this.compositorCount;
        Compositor compositor = new Compositor(this.model, component);
        return compositor;
    }

    public SchemaReference createSchemaReference(SchemaComponent component) {
        return new SchemaReference(this.model, (SchemaModelReference)component);
    }

    public SchemaReference createInclude() {
        return new SchemaReference(this.model, true);
    }

    public SchemaReference createImport() {
        return new SchemaReference(this.model, false);
    }

    public AnyElement createAnyElement() {
        ++this.compositorCount;
        return new AnyElement(this.model);
    }

    public AnyElement createAnyElement(SchemaComponent component) {
        ++this.compositorCount;
        return new AnyElement(this.model, component);
    }

    public AnyAttribute createAnyAttribute() {
        ++this.compositorCount;
        return new AnyAttribute(this.model);
    }

    public AnyAttribute createAnyAttribute(SchemaComponent component) {
        ++this.compositorCount;
        return new AnyAttribute(this.model, component);
    }

    public ContentModel createComplexType() {
        ++this.contentModelCount;
        return new ContentModel(this.model, ContentModel.ContentModelType.COMPLEX_TYPE);
    }

    public ContentModel createGroup() {
        ++this.contentModelCount;
        return new ContentModel(this.model, ContentModel.ContentModelType.GROUP);
    }

    public ContentModel createAttributeGroup() {
        ++this.contentModelCount;
        return new ContentModel(this.model, ContentModel.ContentModelType.ATTRIBUTE_GROUP);
    }

    public ContentModel createContentModel(ContentModel.ContentModelType type) {
        ++this.contentModelCount;
        return new ContentModel(this.model, type);
    }

    public ContentModel createContentModel(SchemaComponent component) {
        ++this.contentModelCount;
        return new ContentModel(this.model, component);
    }

    public AXIComponent createProxy(AXIComponent original) {
        ++this.proxyComponentCount;
        return new ProxyComponentFactory().createProxy(original);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("elementCount: " + this.elementCount + "\n");
        buffer.append("attributeCount: " + this.attributeCount + "\n");
        buffer.append("compositorCount: " + this.compositorCount + "\n");
        buffer.append("contentModelCount: " + this.contentModelCount + "\n");
        buffer.append("proxyComponentCount: " + this.proxyComponentCount + "\n");
        return buffer.toString();
    }

    private class AXICopier
    extends DefaultVisitor {
        private AXIComponent copiedComponent;
        private AXIModel model;

        public AXICopier(AXIModel model) {
            this.model = model;
        }

        public AXIComponent copy(AXIComponent original) {
            if (original.getComponentType() == AXIComponent.ComponentType.PROXY) {
                AXIComponentFactory f = this.model.getComponentFactory();
                this.copiedComponent = f.createProxy(original.getSharedComponent());
                assert (this.copiedComponent != null);
                return this.copiedComponent;
            }
            original.accept(this);
            assert (this.copiedComponent != null);
            return this.copiedComponent;
        }

        @Override
        public void visit(Element element) {
            if (element instanceof ElementRef) {
                ElementRef ref = (ElementRef)element;
                this.copiedComponent = this.model.getComponentFactory().createElementReference(ref.getReferent());
                ((Element)this.copiedComponent).setMaxOccurs(element.getMaxOccurs());
                ((Element)this.copiedComponent).setMinOccurs(element.getMinOccurs());
                return;
            }
            this.copiedComponent = this.model.getComponentFactory().createElement();
            ((Element)this.copiedComponent).setAbstract(element.getAbstract());
            ((Element)this.copiedComponent).setBlock(element.getBlock());
            ((Element)this.copiedComponent).setDefault(element.getDefault());
            ((Element)this.copiedComponent).setFinal(element.getFinal());
            ((Element)this.copiedComponent).setForm(element.getForm());
            ((Element)this.copiedComponent).setFixed(element.getFixed());
            ((Element)this.copiedComponent).setMaxOccurs(element.getMaxOccurs());
            ((Element)this.copiedComponent).setMinOccurs(element.getMinOccurs());
            ((Element)this.copiedComponent).setName(element.getName());
            ((Element)this.copiedComponent).setNillable(element.getNillable());
        }

        @Override
        public void visit(AnyElement element) {
            this.copiedComponent = this.model.getComponentFactory().createAnyElement();
            ((AnyElement)this.copiedComponent).setProcessContents(element.getProcessContents());
            ((AnyElement)this.copiedComponent).setTargetNamespace(element.getTargetNamespace());
        }

        @Override
        public void visit(Attribute attribute) {
            if (attribute instanceof AttributeRef) {
                AttributeRef ref = (AttributeRef)attribute;
                this.copiedComponent = this.model.getComponentFactory().createAttributeReference(ref.getReferent());
                ((Attribute)this.copiedComponent).setFixed(attribute.getFixed());
                ((Attribute)this.copiedComponent).setDefault(attribute.getDefault());
                ((Attribute)this.copiedComponent).setUse(attribute.getUse());
                return;
            }
            this.copiedComponent = this.model.getComponentFactory().createAttribute();
            ((Attribute)this.copiedComponent).setDefault(attribute.getDefault());
            ((Attribute)this.copiedComponent).setFixed(attribute.getFixed());
            ((Attribute)this.copiedComponent).setForm(attribute.getForm());
            ((Attribute)this.copiedComponent).setUse(attribute.getUse());
            ((Attribute)this.copiedComponent).setName(attribute.getName());
        }

        @Override
        public void visit(AnyAttribute attribute) {
            this.copiedComponent = this.model.getComponentFactory().createAnyAttribute();
            ((AnyAttribute)this.copiedComponent).setProcessContents(attribute.getProcessContents());
            ((AnyAttribute)this.copiedComponent).setTargetNamespace(attribute.getTargetNamespace());
        }

        @Override
        public void visit(Compositor compositor) {
            this.copiedComponent = this.model.getComponentFactory().createCompositor(compositor.getType());
            ((Compositor)this.copiedComponent).setMaxOccurs(compositor.getMaxOccurs());
            ((Compositor)this.copiedComponent).setMinOccurs(compositor.getMinOccurs());
        }

        @Override
        public void visit(ContentModel contentModel) {
            this.copiedComponent = this.model.getComponentFactory().createContentModel(contentModel.getType());
        }

        @Override
        public void visit(SchemaReference ref) {
            this.copiedComponent = ref.isInclude() ? this.model.getComponentFactory().createInclude() : this.model.getComponentFactory().createImport();
            ((SchemaReference)this.copiedComponent).setSchemaLocation(ref.getSchemaLocation());
            ((SchemaReference)this.copiedComponent).setTargetNamespace(ref.getTargetNamespace());
        }
    }

    private class ProxyComponentFactory
    extends DefaultVisitor {
        private AXIComponent proxyComponent;

        ProxyComponentFactory() {
        }

        AXIComponent createProxy(AXIComponent original) {
            original.accept(this);
            return this.proxyComponent;
        }

        @Override
        public void visit(Element element) {
            this.proxyComponent = new ElementProxy(AXIComponentFactory.this.model, element);
        }

        @Override
        public void visit(AnyElement element) {
            this.proxyComponent = new AnyElementProxy(AXIComponentFactory.this.model, element);
        }

        @Override
        public void visit(Attribute attribute) {
            this.proxyComponent = new AttributeProxy(AXIComponentFactory.this.model, attribute);
        }

        @Override
        public void visit(AnyAttribute attribute) {
            this.proxyComponent = new AnyAttributeProxy(AXIComponentFactory.this.model, attribute);
        }

        @Override
        public void visit(Compositor compositor) {
            this.proxyComponent = new CompositorProxy(AXIComponentFactory.this.model, compositor);
        }

        @Override
        public void visit(SchemaReference ref) {
            this.proxyComponent = new SchemaReferenceProxy(AXIComponentFactory.this.model, ref);
        }
    }
}

