/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.content;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.welcome.content.ButtonBorder;
import org.netbeans.modules.welcome.content.Constants;
import org.netbeans.modules.welcome.content.Utils;
import org.openide.util.NbBundle;

public abstract class LinkButton
extends JButton
implements Constants,
MouseListener,
ActionListener,
FocusListener {
    private boolean underline = false;
    private final boolean showBorder;
    private Font rollOverFont;
    private Font regularFont;
    private final Color defaultForeground;
    private static final Border regularBorder = ButtonBorder.createRegular();
    private static final Border mouseoverBorder = ButtonBorder.createMouseOver();
    private String usageTrackingId;

    public LinkButton(String label, String usageTrackingId) {
        this(label, false, usageTrackingId);
    }

    public LinkButton(String label, boolean showBorder, String usageTrackingId) {
        this(label, Utils.getLinkColor(), showBorder, usageTrackingId);
    }

    public LinkButton(String label, Color foreground, String usageTrackingId) {
        this(label, foreground, false, usageTrackingId);
    }

    public LinkButton(String label, Color foreground, boolean showBorder, String usageTrackingId) {
        super(label);
        this.defaultForeground = foreground;
        this.showBorder = showBorder;
        if (!showBorder || !Utils.isDefaultButtons()) {
            this.setForeground(this.defaultForeground);
        }
        this.setFont(BUTTON_FONT);
        this.usageTrackingId = usageTrackingId;
        if (showBorder) {
            if (!Utils.isDefaultButtons()) {
                this.setBorder(BorderFactory.createEmptyBorder(6, 12, 6, 12));
                this.setMargin(new Insets(12, 12, 12, 12));
            }
        } else {
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.setMargin(new Insets(0, 0, 0, 0));
        }
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setHorizontalAlignment(2);
        this.addMouseListener(this);
        this.setFocusable(true);
        if (!showBorder || !Utils.isDefaultButtons()) {
            this.setBorderPainted(false);
            this.setFocusPainted(false);
            this.setRolloverEnabled(true);
            this.setContentAreaFilled(false);
        }
        this.addActionListener(this);
        this.addFocusListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.isEnabled()) {
            this.underline = true;
            this.repaint();
            this.onMouseEntered(e);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.isEnabled()) {
            this.underline = false;
            if (!this.showBorder) {
                this.setForeground(this.isVisited() ? Utils.getVisitedLinkColor() : this.defaultForeground);
            }
            this.repaint();
            this.onMouseExited(e);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = Utils.prepareGraphics(g);
        if (this.showBorder && !Utils.isDefaultButtons()) {
            Border b = this.underline ? mouseoverBorder : regularBorder;
            b.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
        }
        super.paintComponent(g2);
        if (this.showBorder && Utils.isDefaultButtons()) {
            return;
        }
        Dimension size = this.getSize();
        if (this.hasFocus() && this.isEnabled()) {
            g2.setStroke(LINK_IN_FOCUS_STROKE);
            g2.setColor(Utils.getFocusedLinkColor());
            g2.drawRect(0, 0, size.width - 1, size.height - 1);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        Rectangle rect = this.getBounds();
        rect.grow(0, FONT_SIZE);
        this.scrollRectToVisible(rect);
    }

    protected void onMouseExited(MouseEvent e) {
        if (null != this.regularFont) {
            super.setFont(this.regularFont);
        }
    }

    protected void onMouseEntered(MouseEvent e) {
        if (null != this.rollOverFont) {
            super.setFont(this.rollOverFont);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.underline && this.isEnabled() && !this.showBorder) {
            g.setColor(this.getForeground());
            Font f = this.getFont();
            FontMetrics fm = this.getFontMetrics(f);
            int iconWidth = 0;
            if (null != this.getIcon()) {
                iconWidth = this.getIcon().getIconWidth() + this.getIconTextGap();
            }
            int x1 = iconWidth;
            int y1 = fm.getHeight();
            int x2 = fm.stringWidth(this.getText()) + iconWidth;
            if (this.getText().length() > 0) {
                g.drawLine(x1, y1, x2, y1);
            }
        }
    }

    protected boolean isVisited() {
        return false;
    }

    public void setUsageTrackingId(String id) {
        this.usageTrackingId = id;
    }

    protected void logUsage() {
        LogRecord rec = new LogRecord(Level.INFO, "USG_START_PAGE_LINK");
        String id = this.usageTrackingId;
        if (null == id) {
            id = this.getText();
        }
        rec.setParameters(new Object[]{id});
        rec.setLoggerName(Constants.USAGE_LOGGER.getName());
        rec.setResourceBundle(NbBundle.getBundle((String)"org.netbeans.modules.welcome.resources.Bundle"));
        rec.setResourceBundleName("org.netbeans.modules.welcome.resources.Bundle");
        Constants.USAGE_LOGGER.log(rec);
        System.err.println("usage: " + id);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.regularFont = font;
        this.rollOverFont = this.showBorder ? font.deriveFont(1) : null;
    }
}

