/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.content;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.border.Border;
import org.openide.util.ImageUtilities;

public class ButtonBorder
implements Border {
    private final Image imgLeft;
    private final Image imgRight;
    private final Image imgCenter;
    private static Border regularBorder;
    private static Border mouseoverBorder;

    private ButtonBorder(boolean mouseOver) {
        if (mouseOver) {
            this.imgLeft = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/sel_btn_left.png");
            this.imgRight = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/sel_btn_right.png");
            this.imgCenter = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/sel_btn_center.png");
        } else {
            this.imgLeft = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/btn_left.png");
            this.imgRight = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/btn_right.png");
            this.imgCenter = ImageUtilities.loadImage((String)"org/netbeans/modules/welcome/resources/btn_center.png");
        }
    }

    public static Border createRegular() {
        if (null == regularBorder) {
            regularBorder = new ButtonBorder(false);
        }
        return regularBorder;
    }

    public static Border createMouseOver() {
        if (null == mouseoverBorder) {
            mouseoverBorder = new ButtonBorder(true);
        }
        return mouseoverBorder;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g.drawImage(this.imgLeft, x, y, this.imgLeft.getWidth(c), height, c);
        g.drawImage(this.imgRight, x + width - this.imgRight.getWidth(c), y, this.imgRight.getWidth(c), height, c);
        g.drawImage(this.imgCenter, x + this.imgLeft.getWidth(c), y, x + width - this.imgLeft.getWidth(c) - this.imgRight.getWidth(c), height, c);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(12, 12, 12, 12);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

