/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.websvc.saas.model.SaasMethod;
import org.netbeans.modules.websvc.saas.model.WadlSaas;
import org.netbeans.modules.websvc.saas.model.WadlSaasResource;
import org.netbeans.modules.websvc.saas.model.jaxb.Method;
import org.netbeans.modules.websvc.saas.model.wadl.Application;
import org.netbeans.modules.websvc.saas.model.wadl.Resource;
import org.netbeans.modules.websvc.saas.model.wadl.Resources;
import org.netbeans.modules.websvc.saas.model.wadl.Response;
import org.netbeans.modules.websvc.saas.util.SaasUtil;
import org.openide.util.Exceptions;

public class WadlSaasMethod
extends SaasMethod {
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final String PUT = "PUT";
    private static final String DELETE = "DELETE";
    private Resource[] path;
    private WadlSaasResource parent;
    private org.netbeans.modules.websvc.saas.model.wadl.Method wadlMethod;
    private String name;
    private String displayName;

    public WadlSaasMethod(WadlSaas wadlSaas, Method method) {
        super(wadlSaas, method);
    }

    public WadlSaasMethod(WadlSaasResource parent, org.netbeans.modules.websvc.saas.model.wadl.Method wadlMethod) {
        this(parent.getSaas(), (Method)null);
        this.parent = parent;
        this.wadlMethod = wadlMethod;
    }

    @Override
    public String getName() {
        if (this.getMethod() == null) {
            if (this.name == null) {
                this.name = this.wadlMethod.getId();
                if (this.name == null) {
                    this.name = this.wadlMethod.getName();
                    Set<Object> medias = null;
                    if (GET.equals(this.name)) {
                        medias = new HashSet();
                        for (Response response : this.wadlMethod.getResponse()) {
                            medias.addAll(SaasUtil.getMediaTypes(response.getRepresentation()));
                        }
                    } else if (PUT.equals(this.name) || POST.equals(this.name)) {
                        medias = SaasUtil.getMediaTypes(this.wadlMethod.getRequest().getRepresentation());
                    }
                    this.name = this.name.toLowerCase();
                    if (medias != null && medias.size() > 0) {
                        for (String string : medias) {
                            this.name = this.name + "_" + string;
                        }
                        this.name = this.name.replaceAll("\\W", "_").replaceAll("_+", "_").replaceAll("_$", "");
                    }
                }
            }
            return this.name;
        }
        return super.getName();
    }

    @Override
    public String getDisplayName() {
        if (this.getMethod() == null) {
            if (this.displayName == null) {
                this.displayName = this.wadlMethod.getId();
                if (this.displayName == null) {
                    this.displayName = this.wadlMethod.getName();
                    Set<Object> medias = null;
                    if (GET.equals(this.displayName)) {
                        medias = new HashSet();
                        for (Response response : this.wadlMethod.getResponse()) {
                            medias.addAll(SaasUtil.getMediaTypes(response.getRepresentation()));
                        }
                    } else if (PUT.equals(this.displayName) || POST.equals(this.displayName)) {
                        medias = SaasUtil.getMediaTypes(this.wadlMethod.getRequest().getRepresentation());
                    }
                    if (medias != null && medias.size() > 0) {
                        this.displayName = this.displayName + medias;
                    }
                }
            }
            return this.displayName;
        }
        return super.getDisplayName();
    }

    @Override
    public WadlSaas getSaas() {
        return (WadlSaas)super.getSaas();
    }

    public WadlSaasResource getParentResource() {
        return this.parent;
    }

    public Resource[] getResourcePath() {
        Application wadl = null;
        try {
            wadl = this.getSaas().getWadlModel();
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
            return new Resource[0];
        }
        if (this.path == null || this.path.length == 0) {
            ArrayList<Resource> result = new ArrayList<Resource>();
            if (super.getMethod() == null) {
                for (WadlSaasResource current = this.getParentResource(); current != null; current = current.getParent()) {
                    result.add(0, current.getResource());
                }
            } else {
                block3: for (Resources wadlResources : wadl.getResources()) {
                    for (Resource r : wadlResources.getResource()) {
                        this.findPathToMethod(r, result);
                        if (!r.getMethodOrResource().contains(this.getWadlMethod())) continue;
                        continue block3;
                    }
                }
            }
            this.path = result.toArray(new Resource[result.size()]);
        }
        return this.path;
    }

    private void findPathToMethod(Resource current, List<Resource> resultPath) {
        if (current.getMethodOrResource().contains(this.getWadlMethod())) {
            resultPath.add(current);
            return;
        }
        for (Object o : current.getMethodOrResource()) {
            if (!(o instanceof Resource)) continue;
            this.findPathToMethod((Resource)o, resultPath);
            if (resultPath.size() <= 0) continue;
            break;
        }
        resultPath.add(0, current);
    }

    public org.netbeans.modules.websvc.saas.model.wadl.Method getWadlMethod() {
        block6: {
            if (this.wadlMethod == null) {
                if (this.getHref() != null && this.getHref().length() > 0) {
                    try {
                        if (this.getHref().charAt(0) == '/') {
                            this.wadlMethod = SaasUtil.wadlMethodFromXPath(this.getSaas().getWadlModel(), this.getHref());
                            break block6;
                        }
                        this.wadlMethod = SaasUtil.wadlMethodFromIdRef(this.getSaas().getWadlModel(), this.getHref());
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                } else {
                    throw new IllegalArgumentException("Element method " + this.getName() + " should define attribute 'href'");
                }
            }
        }
        return this.wadlMethod;
    }

    public String toString() {
        return this.getDisplayName();
    }
}

