/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Set;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.rest.wizard.AbstractJaxRsFeatureIterator;
import org.netbeans.modules.websvc.rest.wizard.JaxRsFilterPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class JaxRsFilterIterator
extends AbstractJaxRsFeatureIterator {
    @Override
    protected WizardDescriptor.Panel<?> createPanel(WizardDescriptor wizard) {
        return new JaxRsFilterPanel(wizard);
    }

    @Override
    protected String getTitleKey() {
        return "TXT_CreateJaxRsFilter";
    }

    public Set<?> instantiate(ProgressHandle handle) throws IOException {
        handle.start();
        handle.progress(NbBundle.getMessage(JaxRsFilterIterator.class, (String)"TXT_GenerateFilterFile"));
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.getWizard());
        String name = Templates.getTargetName((WizardDescriptor)this.getWizard());
        FileObject filterClass = GenerationUtils.createClass((FileObject)targetFolder, (String)name, null);
        this.implementFilters(filterClass);
        handle.finish();
        return Collections.singleton(filterClass);
    }

    private void implementFilters(FileObject filterClass) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)filterClass);
        if (javaSource == null) {
            return;
        }
        final boolean client = Boolean.TRUE.equals(this.getWizard().getProperty("client.filter"));
        final boolean server = Boolean.TRUE.equals(this.getWizard().getProperty("server.filter"));
        final boolean request = Boolean.TRUE.equals(this.getWizard().getProperty("request.filter"));
        final boolean response = Boolean.TRUE.equals(this.getWizard().getProperty("response.filter"));
        final boolean addPreMatch = Boolean.TRUE.equals(this.getWizard().getProperty("prematching.filter"));
        final boolean addProvider = Boolean.TRUE.equals(this.getWizard().getProperty("provider.filter"));
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy copy) throws Exception {
                MethodTree method;
                ClassTree tree;
                copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ClassTree newTree = tree = JavaSourceHelper.getTopLevelClassTree((CompilationController)copy);
                TreeMaker treeMaker = copy.getTreeMaker();
                GenerationUtils genUtils = GenerationUtils.newInstance((WorkingCopy)copy);
                if (addPreMatch) {
                    AnnotationTree preMatching = genUtils.createAnnotation("javax.ws.rs.container.PreMatching");
                    newTree = genUtils.addAnnotation(newTree, preMatching);
                }
                if (addProvider) {
                    AnnotationTree provider = genUtils.createAnnotation("javax.ws.rs.ext.Provider");
                    newTree = genUtils.addAnnotation(newTree, provider);
                }
                LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
                if (client) {
                    if (request) {
                        params.put("requestContext", "javax.ws.rs.client.ClientRequestContext");
                        newTree = genUtils.addImplementsClause(newTree, "javax.ws.rs.client.ClientRequestFilter");
                        method = JaxRsFilterIterator.this.createMethod(genUtils, treeMaker, params);
                        newTree = treeMaker.addClassMember(newTree, (Tree)method);
                    }
                    if (response) {
                        params.put("requestContext", "javax.ws.rs.client.ClientRequestContext");
                        params.put("responseContext", "javax.ws.rs.client.ClientResponseContext");
                        newTree = genUtils.addImplementsClause(newTree, "javax.ws.rs.client.ClientResponseFilter");
                        method = JaxRsFilterIterator.this.createMethod(genUtils, treeMaker, params);
                        newTree = treeMaker.addClassMember(newTree, (Tree)method);
                    }
                }
                if (server) {
                    params.clear();
                    if (request) {
                        params.put("requestContext", "javax.ws.rs.container.ContainerRequestContext");
                        newTree = genUtils.addImplementsClause(newTree, "javax.ws.rs.container.ContainerRequestFilter");
                        method = JaxRsFilterIterator.this.createMethod(genUtils, treeMaker, params);
                        newTree = treeMaker.addClassMember(newTree, (Tree)method);
                    }
                    if (response) {
                        params.put("requestContext", "javax.ws.rs.container.ContainerRequestContext");
                        params.put("responseContext", "javax.ws.rs.container.ContainerResponseContext");
                        newTree = genUtils.addImplementsClause(newTree, "javax.ws.rs.container.ContainerResponseFilter");
                        method = JaxRsFilterIterator.this.createMethod(genUtils, treeMaker, params);
                        newTree = treeMaker.addClassMember(newTree, (Tree)method);
                    }
                }
                copy.rewrite((Tree)tree, (Tree)newTree);
            }
        }).commit();
    }

    private MethodTree createMethod(GenerationUtils genUtils, TreeMaker maker, LinkedHashMap<String, String> methodParams) {
        return JaxRsFilterIterator.createMethod(genUtils, maker, "filter", methodParams);
    }
}

