/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.client;

import java.awt.Component;
import java.io.IOException;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.api.support.SourceGroups;
import org.netbeans.modules.websvc.rest.client.ClientJavaSourceHelper;
import org.netbeans.modules.websvc.rest.client.FinishableProxyWizardPanel;
import org.netbeans.modules.websvc.rest.client.JerseyClientWizardPanel;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.RequestProcessor;

public final class JerseyClientWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private int index;
    private WizardDescriptor wizard;
    private WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor.Panel<WizardDescriptor> firstPanel;
    private transient JerseyClientWizardPanel bottomPanel;

    private WizardDescriptor.Panel[] getPanels() {
        return this.panels;
    }

    public Set<DataObject> instantiate() throws IOException {
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wizard);
        template.setAttribute("REST_RESOURCE_NAME", (Object)this.bottomPanel.getResourceName());
        DataObject dTemplate = DataObject.find((FileObject)template);
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)this.wizard);
        DataFolder df = DataFolder.findFolder((FileObject)dir);
        final DataObject dobj = dTemplate.createFromTemplate(df, Templates.getTargetName((WizardDescriptor)this.wizard));
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                ClientJavaSourceHelper.generateJerseyClient(JerseyClientWizardIterator.this.bottomPanel.getResourceNode(), dobj.getPrimaryFile(), null, JerseyClientWizardIterator.this.bottomPanel.getSecurity());
            }
        });
        return Collections.singleton(dobj);
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
        Project project = Templates.getProject((WizardDescriptor)wizard);
        SourceGroup[] sourceGroups = SourceGroups.getJavaSourceGroups((Project)project);
        this.bottomPanel = new JerseyClientWizardPanel();
        if (sourceGroups.length == 0) {
            SourceGroup[] genericSourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("generic");
            this.firstPanel = new FinishableProxyWizardPanel((WizardDescriptor.Panel<WizardDescriptor>)Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])genericSourceGroups, (WizardDescriptor.Panel)this.bottomPanel), sourceGroups, false);
        } else {
            this.firstPanel = new FinishableProxyWizardPanel((WizardDescriptor.Panel<WizardDescriptor>)JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])sourceGroups, (WizardDescriptor.Panel)this.bottomPanel, (boolean)true));
        }
        this.panels = new WizardDescriptor.Panel[]{this.firstPanel};
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
            jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        }
    }

    public void uninitialize(WizardDescriptor wizard) {
        this.panels = null;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.getPanels()[this.index];
    }

    public String name() {
        return this.index + 1 + ". from " + this.getPanels().length;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private String[] createSteps() {
        String[] beforeSteps = null;
        Object prop = this.wizard.getProperty("WizardPanel_contentData");
        if (prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        if (beforeSteps == null) {
            beforeSteps = new String[]{};
        }
        String[] res = new String[beforeSteps.length - 1 + this.panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < beforeSteps.length - 1 ? beforeSteps[i] : this.panels[i - beforeSteps.length + 1].getComponent().getName();
        }
        return res;
    }
}

