/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.api.jaxws.wsdlmodel;

import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;

public class WsdlModelerFactory {
    private static WsdlModelerFactory factory;
    WeakHashMap<URI, WeakReference<WsdlModeler>> modelers = new WeakHashMap(5);

    private WsdlModelerFactory() {
    }

    public static synchronized WsdlModelerFactory getDefault() {
        if (factory == null) {
            factory = new WsdlModelerFactory();
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WsdlModeler getWsdlModeler(URL wsdlUrl) {
        URI uri;
        try {
            uri = wsdlUrl.toURI();
        }
        catch (URISyntaxException e) {
            Logger.getLogger(WsdlModel.class.getName()).log(Level.WARNING, null, e);
            return null;
        }
        WsdlModeler modeler = null;
        WeakHashMap<URI, WeakReference<WsdlModeler>> weakHashMap = this.modelers;
        synchronized (weakHashMap) {
            modeler = this.getFromCache(uri);
            if (modeler != null) {
                return modeler;
            }
            modeler = new WsdlModeler(wsdlUrl);
            this.modelers.put(uri, new WeakReference<WsdlModeler>(modeler));
        }
        return modeler;
    }

    private WsdlModeler getFromCache(URI uri) {
        if (uri == null) {
            return null;
        }
        WeakReference<WsdlModeler> wr = this.modelers.get(uri);
        if (wr == null) {
            return null;
        }
        WsdlModeler modeler = (WsdlModeler)wr.get();
        if (modeler == null) {
            this.modelers.remove(uri);
        }
        return modeler;
    }

    int mapLength() {
        return this.modelers.size();
    }
}

