/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxws.catalog.impl;

import org.netbeans.modules.websvc.jaxws.catalog.Catalog;
import org.netbeans.modules.websvc.jaxws.catalog.CatalogComponent;
import org.netbeans.modules.websvc.jaxws.catalog.CatalogComponentFactory;
import org.netbeans.modules.websvc.jaxws.catalog.CatalogQNames;
import org.netbeans.modules.websvc.jaxws.catalog.CatalogVisitor;
import org.netbeans.modules.websvc.jaxws.catalog.NextCatalog;
import org.netbeans.modules.websvc.jaxws.catalog.System;
import org.netbeans.modules.websvc.jaxws.catalog.impl.CatalogImpl;
import org.netbeans.modules.websvc.jaxws.catalog.impl.CatalogModelImpl;
import org.netbeans.modules.websvc.jaxws.catalog.impl.NextCatalogImpl;
import org.netbeans.modules.websvc.jaxws.catalog.impl.SystemImpl;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CatalogComponentFactoryImpl
implements CatalogComponentFactory {
    private CatalogModelImpl model;

    public CatalogComponentFactoryImpl(CatalogModelImpl model) {
        this.model = model;
    }

    @Override
    public CatalogComponent create(Element element, CatalogComponent context) {
        if (context == null) {
            if (CatalogComponentFactoryImpl.areSameQName(CatalogQNames.CATALOG, element)) {
                return new CatalogImpl(this.model, element);
            }
            return null;
        }
        return new CreateVisitor().create(element, context);
    }

    @Override
    public NextCatalog createNextCatalog() {
        return new NextCatalogImpl(this.model);
    }

    @Override
    public System createSystem() {
        return new SystemImpl(this.model);
    }

    @Override
    public Catalog createCatalog() {
        return new CatalogImpl(this.model);
    }

    public static boolean areSameQName(CatalogQNames q, Element e) {
        return q.getQName().equals(AbstractDocumentComponent.getQName((Node)e));
    }

    public static class CreateVisitor
    extends CatalogVisitor.Default {
        Element element;
        CatalogComponent created;

        CatalogComponent create(Element element, CatalogComponent context) {
            this.element = element;
            context.accept(this);
            return this.created;
        }

        private boolean isElementQName(CatalogQNames q) {
            return CatalogComponentFactoryImpl.areSameQName(q, this.element);
        }

        @Override
        public void visit(Catalog context) {
            if (this.isElementQName(CatalogQNames.SYSTEM)) {
                this.created = new SystemImpl((CatalogModelImpl)context.getModel(), this.element);
            }
            if (this.isElementQName(CatalogQNames.NEXTCATALOG)) {
                this.created = new NextCatalogImpl((CatalogModelImpl)context.getModel(), this.element);
            }
        }

        @Override
        public void visit(System context) {
        }

        @Override
        public void visit(NextCatalog context) {
        }
    }
}

