/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webkit.tooling.networkmonitor;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.common.api.ServerURLMapping;
import org.netbeans.modules.web.common.spi.DependentFileQueryImplementation;
import org.netbeans.modules.web.webkit.debugging.api.network.Network;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public class DependentFileQueryImpl
implements DependentFileQueryImplementation {
    private static final RequestProcessor RP = new RequestProcessor(DependentFileQueryImpl.class);
    private static final DependencyInfo DEFAULT = new DependencyInfo();

    public DependentFileQueryImplementation.Dependency isDependent(FileObject master, FileObject dependent) {
        return DEFAULT.isDependent(master, dependent);
    }

    static void networkRequest(Project p, Network.Request request) {
        DependentFileQueryImpl.DEFAULT.networkRequestHandler(p, request);
    }

    private static class DependencyInfo {
        private final WeakHashMap<Project, Map<FileObject, List<FileObject>>> dependecies = new WeakHashMap();

        private DependencyInfo() {
        }

        public DependentFileQueryImplementation.Dependency isDependent(FileObject master, FileObject dependent) {
            Project p = FileOwnerQuery.getOwner((FileObject)master);
            if (p == null) {
                return DependentFileQueryImplementation.Dependency.UNKNOWN;
            }
            Map<FileObject, List<FileObject>> projDep = this.dependecies.get(p);
            if (projDep == null) {
                return DependentFileQueryImplementation.Dependency.UNKNOWN;
            }
            List<FileObject> deps = projDep.get(master);
            if (deps == null) {
                return DependentFileQueryImplementation.Dependency.UNKNOWN;
            }
            return deps.contains(dependent) ? DependentFileQueryImplementation.Dependency.YES : DependentFileQueryImplementation.Dependency.UNKNOWN;
        }

        public void networkRequest(final Project p, final Network.Request request) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    this.networkRequestHandler(p, request);
                }
            });
        }

        private void networkRequestHandler(Project p, Network.Request request) {
            Map<FileObject, List<FileObject>> map = this.dependecies.get(p);
            if (map == null) {
                map = new HashMap<FileObject, List<FileObject>>();
                this.dependecies.put(p, map);
            }
            String documentUrl = request.getDocumentUrl();
            String url = (String)request.getRequest().get((Object)"url");
            if (documentUrl == null || url == null) {
                return;
            }
            FileObject documentUrlFO = this.findProjectFile(p, documentUrl);
            if (documentUrlFO == null) {
                return;
            }
            if (documentUrl.equals(url)) {
                map.put(documentUrlFO, new ArrayList());
            } else {
                FileObject dep = this.findProjectFile(p, url);
                if (dep == null) {
                    return;
                }
                List<FileObject> deps = map.get(documentUrlFO);
                if (deps == null) {
                    deps = new ArrayList<FileObject>();
                    map.put(documentUrlFO, deps);
                }
                deps.add(dep);
            }
        }

        private FileObject findProjectFile(Project project, String urlStr) {
            try {
                URL url = new URL(urlStr);
                if (project != null) {
                    return ServerURLMapping.fromServer((Project)project, (URL)url);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            return null;
        }
    }
}

