/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webkit.debugging.api.dom;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.netbeans.modules.web.webkit.debugging.TransportHelper;
import org.netbeans.modules.web.webkit.debugging.api.WebKitDebugging;
import org.netbeans.modules.web.webkit.debugging.api.debugger.RemoteObject;
import org.netbeans.modules.web.webkit.debugging.api.dom.HighlightConfig;
import org.netbeans.modules.web.webkit.debugging.api.dom.Node;
import org.netbeans.modules.web.webkit.debugging.spi.Command;
import org.netbeans.modules.web.webkit.debugging.spi.Response;
import org.netbeans.modules.web.webkit.debugging.spi.ResponseCallback;

public class DOM {
    private final TransportHelper transport;
    private final WebKitDebugging webKit;
    private final ResponseCallback callback;
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private Node documentNode;
    private int documentCounter;
    private final Map<Integer, Node> nodes = new HashMap<Integer, Node>();
    private final Object DOCUMENT_LOCK = new Object();
    private String classForHover;

    public DOM(TransportHelper transport, WebKitDebugging webKit) {
        this.transport = transport;
        this.webKit = webKit;
        this.callback = new Callback();
        this.transport.addListener(this.callback);
    }

    public void enable() {
        this.transport.sendBlockingCommand(new Command("DOM.enable"));
    }

    public void disable() {
        this.transport.sendCommand(new Command("DOM.disable"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getDocument() {
        Object object = this.DOCUMENT_LOCK;
        synchronized (object) {
            int counter;
            Node document;
            DOM dOM = this;
            synchronized (dOM) {
                document = this.documentNode;
                counter = this.documentCounter;
            }
            if (document == null) {
                Response response = this.transport.sendBlockingCommand(new Command("DOM.getDocument"));
                DOM dOM2 = this;
                synchronized (dOM2) {
                    if (counter == this.documentCounter) {
                        JSONObject result;
                        if (response != null && (result = response.getResult()) != null) {
                            JSONObject node = (JSONObject)result.get((Object)"root");
                            this.documentNode = new Node(node);
                            this.updateNodesMap(this.documentNode);
                        }
                        return this.documentNode;
                    }
                }
                return this.getDocument();
            }
            return document;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateNodesMap(Node node) {
        this.removeClassForHover(node);
        this.nodes.put(node.getNodeId(), node);
        Node node2 = node;
        synchronized (node2) {
            Node document;
            List<Node> subNodes = node.getChildren();
            if (subNodes != null) {
                for (Node subNode : subNodes) {
                    this.updateNodesMap(subNode);
                }
            }
            if ((document = node.getContentDocument()) != null) {
                this.updateNodesMap(document);
            }
            for (Node shadowRoot : node.getShadowRoots()) {
                this.updateNodesMap(shadowRoot);
            }
        }
    }

    public void requestChildNodes(int nodeId) {
        JSONObject params = new JSONObject();
        params.put((Object)"nodeId", (Object)nodeId);
        if (this.transport.isVersionUnknownBeforeRequestChildNodes()) {
            this.transport.sendCommand(new Command("DOM.getChildNodes", params));
        } else {
            this.transport.sendCommand(new Command("DOM.requestChildNodes", params));
        }
    }

    public void highlightRect(Rectangle rect, Color fill, Color outline) {
        JSONObject params = new JSONObject();
        params.put((Object)"x", (Object)rect.x);
        params.put((Object)"y", (Object)rect.y);
        params.put((Object)"width", (Object)rect.width);
        params.put((Object)"height", (Object)rect.height);
        if (fill != null) {
            params.put((Object)"color", (Object)HighlightConfig.colorToRGBA(fill));
        }
        if (outline != null) {
            params.put((Object)"outlineColor", (Object)HighlightConfig.colorToRGBA(outline));
        }
        this.transport.sendCommand(new Command("DOM.highlightRect", params));
    }

    public void highlightNode(Node node, HighlightConfig highlight) {
        JSONObject params = new JSONObject();
        params.put((Object)"nodeId", (Object)node.getNodeId());
        params.put((Object)"highlightConfig", (Object)highlight.toJSONObject());
        this.transport.sendCommand(new Command("DOM.highlightNode", params));
    }

    public void hideHighlight() {
        this.transport.sendCommand(new Command("DOM.hideHighlight"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node querySelector(Node node, String selector) {
        JSONObject result;
        Node n = null;
        JSONObject params = new JSONObject();
        params.put((Object)"nodeId", (Object)node.getNodeId());
        params.put((Object)"selector", (Object)selector);
        Response response = this.transport.sendBlockingCommand(new Command("DOM.querySelector", params));
        if (response != null && (result = response.getResult()) != null) {
            int nodeId = ((Number)result.get((Object)"nodeId")).intValue();
            DOM dOM = this;
            synchronized (dOM) {
                n = this.nodes.get(nodeId);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Node> querySelectorAll(Node node, String selector) {
        JSONObject result;
        ArrayList<Node> list = Collections.EMPTY_LIST;
        JSONObject params = new JSONObject();
        params.put((Object)"nodeId", (Object)node.getNodeId());
        params.put((Object)"selector", (Object)selector);
        Response response = this.transport.sendBlockingCommand(new Command("DOM.querySelectorAll", params));
        if (response != null && (result = response.getResult()) != null) {
            list = new ArrayList<Node>();
            JSONArray array = (JSONArray)result.get((Object)"nodeIds");
            DOM dOM = this;
            synchronized (dOM) {
                for (Object id : array) {
                    int nodeId = ((Number)id).intValue();
                    Node n = this.nodes.get(nodeId);
                    if (n == null) continue;
                    list.add(n);
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node setNodeName(Node node, String name) {
        JSONObject result;
        Node n = null;
        JSONObject params = new JSONObject();
        params.put((Object)"nodeId", (Object)node.getNodeId());
        params.put((Object)"name", (Object)name);
        Response response = this.transport.sendBlockingCommand(new Command("DOM.setNodeName", params));
        if (response != null && (result = response.getResult()) != null) {
            int nodeId = ((Number)result.get((Object)"nodeId")).intValue();
            DOM dOM = this;
            synchronized (dOM) {
                n = this.nodes.get(nodeId);
            }
        }
        return n;
    }

    public void setNodeValue(Node node, String value) {
        JSONObject params = new JSONObject();
        params.put((Object)"nodeId", (Object)node.getNodeId());
        params.put((Object)"value", (Object)value);
        this.transport.sendCommand(new Command("DOM.setNodeValue", params));
    }

    public void removeNode(Node node) {
        JSONObject params = new JSONObject();
        params.put((Object)"nodeId", (Object)node.getNodeId());
        this.transport.sendCommand(new Command("DOM.removeNode", params));
    }

    public void setAttributeValue(Node node, String name, String value) {
        JSONObject params = new JSONObject();
        params.put((Object)"nodeId", (Object)node.getNodeId());
        params.put((Object)"name", (Object)name);
        params.put((Object)"value", (Object)value);
        this.transport.sendCommand(new Command("DOM.setAttributeValue", params));
    }

    public void removeAttribute(Node node, String name) {
        JSONObject params = new JSONObject();
        params.put((Object)"nodeId", (Object)node.getNodeId());
        params.put((Object)"name", (Object)name);
        this.transport.sendCommand(new Command("DOM.removeAttribute", params));
    }

    public String getOuterHTML(Node node) {
        JSONObject result;
        String html = null;
        JSONObject params = new JSONObject();
        params.put((Object)"nodeId", (Object)node.getNodeId());
        Response response = this.transport.sendBlockingCommand(new Command("DOM.getOuterHTML", params));
        if (response != null && (result = response.getResult()) != null) {
            html = (String)result.get((Object)"outerHTML");
        }
        return html;
    }

    public void setOuterHTML(Node node, String html) {
        JSONObject params = new JSONObject();
        params.put((Object)"nodeId", (Object)node.getNodeId());
        params.put((Object)"outerHTML", (Object)html);
        this.transport.sendCommand(new Command("DOM.setOuterHTML", params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node requestNode(RemoteObject remoteObject) {
        JSONObject result;
        Node n = null;
        JSONObject params = new JSONObject();
        params.put((Object)"objectId", (Object)remoteObject.getObjectID());
        Response response = this.transport.sendBlockingCommand(new Command("DOM.requestNode", params));
        if (response != null && (result = response.getResult()) != null) {
            int nodeId = ((Number)result.get((Object)"nodeId")).intValue();
            DOM dOM = this;
            synchronized (dOM) {
                n = this.nodes.get(nodeId);
            }
        }
        return n;
    }

    public RemoteObject resolveNode(Node node, String objectGroup) {
        JSONObject result;
        Response response;
        RemoteObject remoteObject = null;
        JSONObject params = new JSONObject();
        params.put((Object)"nodeId", (Object)node.getNodeId());
        if (objectGroup != null) {
            params.put((Object)"objectGroup", (Object)objectGroup);
        }
        if ((response = this.transport.sendBlockingCommand(new Command("DOM.resolveNode", params))) != null && (result = response.getResult()) != null) {
            JSONObject object = (JSONObject)result.get((Object)"object");
            remoteObject = new RemoteObject(object, this.webKit);
        }
        return remoteObject;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void reset() {
        this.documentNode = null;
        this.classForHover = null;
    }

    public void setClassForHover(String classForHover) {
        this.classForHover = classForHover;
    }

    private String getClassForHover() {
        return this.classForHover;
    }

    private void removeClassForHover(Node node) {
        Node.Attribute attr = node.getAttribute("class");
        if (attr != null) {
            String value = attr.getValue();
            String clazz = this.getClassForHover();
            if (clazz != null && value.contains(clazz)) {
                value = Pattern.compile(Pattern.quote(clazz)).matcher(value).replaceAll("").trim();
                if (value.isEmpty()) {
                    node.removeAttribute(attr.getName());
                } else {
                    attr.setValue(value);
                }
            }
        }
    }

    private void notifyChildNodesSet(Node parent) {
        for (Listener listener : this.listeners) {
            listener.childNodesSet(parent);
        }
    }

    private void notifyChildNodeRemoved(Node parent, Node child) {
        for (Listener listener : this.listeners) {
            listener.childNodeRemoved(parent, child);
        }
    }

    private void notifyChildNodeInserted(Node parent, Node child) {
        for (Listener listener : this.listeners) {
            listener.childNodeInserted(parent, child);
        }
    }

    private void notifyDocumentUpdated() {
        for (Listener listener : this.listeners) {
            listener.documentUpdated();
        }
    }

    private void notifyAttributeModified(Node node, String attrName, String attrValue) {
        for (Listener listener : this.listeners) {
            listener.attributeModified(node, attrName, attrValue);
        }
    }

    private void notifyAttributeRemoved(Node node, String attrName) {
        for (Listener listener : this.listeners) {
            listener.attributeRemoved(node, attrName);
        }
    }

    private void notifyCharacterDataModified(Node node) {
        for (Listener listener : this.listeners) {
            listener.characterDataModified(node);
        }
    }

    private void notifyShadowRootPushed(Node host, Node shadowRoot) {
        for (Listener listener : this.listeners) {
            listener.shadowRootPushed(host, shadowRoot);
        }
    }

    private void notifyShadowRootPopped(Node host, Node shadowRoot) {
        for (Listener listener : this.listeners) {
            listener.shadowRootPopped(host, shadowRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleSetChildNodes(JSONObject params) {
        Node parent;
        DOM dOM = this;
        synchronized (dOM) {
            int parentId = ((Number)params.get((Object)"parentId")).intValue();
            parent = this.nodes.get(parentId);
            if (parent == null) {
                Logger.getLogger(DOM.class.getName()).log(Level.INFO, "Nodes set to an unknown parent: {0}!", params);
                return;
            }
            JSONArray children = (JSONArray)params.get((Object)"nodes");
            parent.initChildren();
            ArrayList<Node> newChildren = new ArrayList<Node>(children.size());
            for (Object child : children) {
                Node node = new Node((JSONObject)child);
                newChildren.add(node);
            }
            parent.addChildren(newChildren);
            this.updateNodesMap(parent);
        }
        this.notifyChildNodesSet(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleChildNodeInserted(JSONObject params) {
        Node child;
        Node parent;
        DOM dOM = this;
        synchronized (dOM) {
            Number nodeId = (Number)params.get((Object)"parentNodeId");
            if (nodeId == null) {
                nodeId = (Number)params.get((Object)"parentId");
            }
            int parentId = nodeId.intValue();
            parent = this.nodes.get(parentId);
            Number prevId = (Number)params.get((Object)"previousNodeId");
            if (prevId == null) {
                prevId = (Number)params.get((Object)"prevId");
            }
            int previousNodeId = prevId.intValue();
            Node previousNode = this.nodes.get(previousNodeId);
            JSONObject childData = (JSONObject)params.get((Object)"node");
            child = new Node(childData);
            this.updateNodesMap(child);
            if (parent == null) {
                Logger.getLogger(DOM.class.getName()).log(Level.INFO, "Node inserted into an unknown parent: {0}!", params);
                return;
            }
            parent.insertChild(child, previousNode);
        }
        this.notifyChildNodeInserted(parent, child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleChildNodeRemoved(JSONObject params) {
        Node child;
        Node parent;
        DOM dOM = this;
        synchronized (dOM) {
            int parentId = ((Number)params.get((Object)"parentNodeId")).intValue();
            parent = this.nodes.get(parentId);
            int nodeId = ((Number)params.get((Object)"nodeId")).intValue();
            child = this.nodes.get(nodeId);
            if (parent == null) {
                Logger.getLogger(DOM.class.getName()).log(Level.INFO, "Node removed from an unknown parent: {0}!", params);
                return;
            }
            parent.removeChild(child);
            this.nodes.remove(nodeId);
        }
        this.notifyChildNodeRemoved(parent, child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDocumentUpdated() {
        DOM dOM = this;
        synchronized (dOM) {
            this.nodes.clear();
            this.documentNode = null;
            ++this.documentCounter;
        }
        this.notifyDocumentUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleAttributeModified(JSONObject params) {
        String value;
        String name;
        Node node;
        DOM dOM = this;
        synchronized (dOM) {
            String clazz;
            int nodeId = ((Number)params.get((Object)"nodeId")).intValue();
            node = this.nodes.get(nodeId);
            if (node == null) {
                return;
            }
            name = (String)params.get((Object)"name");
            value = (String)params.get((Object)"value");
            if ("class".equals(name) && (clazz = this.getClassForHover()) != null && value.contains(clazz)) {
                value = Pattern.compile(Pattern.quote(clazz)).matcher(value).replaceAll("").trim();
            }
            node.setAttribute(name, value);
        }
        this.notifyAttributeModified(node, name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleAttributeRemoved(JSONObject params) {
        String name;
        Node node;
        DOM dOM = this;
        synchronized (dOM) {
            int nodeId = ((Number)params.get((Object)"nodeId")).intValue();
            node = this.nodes.get(nodeId);
            if (node == null) {
                return;
            }
            name = (String)params.get((Object)"name");
            node.removeAttribute(name);
        }
        this.notifyAttributeRemoved(node, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleCharacterDataModified(JSONObject params) {
        Node node;
        DOM dOM = this;
        synchronized (dOM) {
            int nodeId = ((Number)params.get((Object)"nodeId")).intValue();
            node = this.nodes.get(nodeId);
            if (node == null) {
                return;
            }
            String characterData = (String)params.get((Object)"characterData");
            node.setNodeValue(characterData);
        }
        this.notifyCharacterDataModified(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleShadowRootPushed(JSONObject params) {
        Node shadowRoot;
        Node host;
        DOM dOM = this;
        synchronized (dOM) {
            int hostId = ((Number)params.get((Object)"hostId")).intValue();
            host = this.nodes.get(hostId);
            if (host == null) {
                return;
            }
            JSONObject root = (JSONObject)params.get((Object)"root");
            shadowRoot = new Node(root);
            host.addShadowRoot(shadowRoot);
            this.updateNodesMap(shadowRoot);
        }
        this.notifyShadowRootPushed(host, shadowRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleShadowRootPopped(JSONObject params) {
        Node shadowRoot;
        Node host;
        DOM dOM = this;
        synchronized (dOM) {
            int hostId = ((Number)params.get((Object)"hostId")).intValue();
            host = this.nodes.get(hostId);
            int rootId = ((Number)params.get((Object)"rootId")).intValue();
            shadowRoot = this.nodes.get(rootId);
            if (host == null || shadowRoot == null) {
                return;
            }
            host.removeShadowRoot(shadowRoot);
            this.nodes.remove(rootId);
        }
        this.notifyShadowRootPopped(host, shadowRoot);
    }

    class Callback
    implements ResponseCallback {
        Callback() {
        }

        @Override
        public void handleResponse(Response response) {
            String method = response.getMethod();
            JSONObject params = response.getParams();
            if ("DOM.setChildNodes".equals(method)) {
                DOM.this.handleSetChildNodes(params);
            } else if ("DOM.childNodeInserted".equals(method)) {
                DOM.this.handleChildNodeInserted(params);
            } else if ("DOM.childNodeRemoved".equals(method)) {
                DOM.this.handleChildNodeRemoved(params);
            } else if ("DOM.documentUpdated".equals(method)) {
                DOM.this.handleDocumentUpdated();
            } else if ("DOM.attributeModified".equals(method)) {
                DOM.this.handleAttributeModified(params);
            } else if ("DOM.attributeRemoved".equals(method)) {
                DOM.this.handleAttributeRemoved(params);
            } else if ("DOM.characterDataModified".equals(method)) {
                DOM.this.handleCharacterDataModified(params);
            } else if ("DOM.shadowRootPushed".equals(method)) {
                DOM.this.handleShadowRootPushed(params);
            } else if ("DOM.shadowRootPopped".equals(method)) {
                DOM.this.handleShadowRootPopped(params);
            }
        }
    }

    public static interface Listener {
        public void documentUpdated();

        public void childNodesSet(Node var1);

        public void childNodeRemoved(Node var1, Node var2);

        public void childNodeInserted(Node var1, Node var2);

        public void attributeModified(Node var1, String var2, String var3);

        public void attributeRemoved(Node var1, String var2);

        public void characterDataModified(Node var1);

        public void shadowRootPushed(Node var1, Node var2);

        public void shadowRootPopped(Node var1, Node var2);
    }
}

