/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.customizer;

import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JPanel;
import org.netbeans.modules.web.project.ui.customizer.WebProjectProperties;
import org.netbeans.modules.websvc.api.webservices.WsCompileEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class CustomizerWSServiceHost
extends JPanel
implements PropertyChangeListener,
HelpCtx.Provider {
    private WebProjectProperties webProperties;
    private WsCompileEditorSupport.Panel wsCompileEditor;
    private List serviceSettings;

    public CustomizerWSServiceHost(WebProjectProperties webProperties, List serviceSettings) {
        assert (serviceSettings != null);
        this.initComponents();
        this.webProperties = webProperties;
        this.wsCompileEditor = null;
        this.serviceSettings = serviceSettings;
        if (serviceSettings.size() > 0) {
            this.initValues();
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        JPanel component = this.wsCompileEditor.getComponent();
        this.removeAll();
        this.add(component);
        component.addPropertyChangeListener("featuresChanged", this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        JPanel component = this.wsCompileEditor.getComponent();
        component.removePropertyChangeListener("featuresChanged", this);
    }

    private void initValues() {
        if (this.wsCompileEditor == null) {
            WsCompileEditorSupport editorSupport = (WsCompileEditorSupport)Lookup.getDefault().lookup(WsCompileEditorSupport.class);
            this.wsCompileEditor = editorSupport.getWsCompileSupport();
        }
        this.wsCompileEditor.initValues(this.serviceSettings);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        WsCompileEditorSupport.FeatureDescriptor newFeatureDesc = (WsCompileEditorSupport.FeatureDescriptor)evt.getNewValue();
        String propertyName = "wscompile.service." + newFeatureDesc.getServiceName() + ".features";
        this.webProperties.putAdditionalProperty(propertyName, newFeatureDesc.getFeatures());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerWSServiceHost.class);
    }
}

