/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.jaxws;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.spi.jaxws.client.ProjectJAXWSClientSupport;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.filesystems.FileObject;

public class WebProjectJAXWSClientSupport
extends ProjectJAXWSClientSupport {
    WebProject project;

    public WebProjectJAXWSClientSupport(WebProject project, AntProjectHelper helper) {
        super((Project)project, helper);
        this.project = project;
    }

    public FileObject getWsdlFolder(boolean create) throws IOException {
        FileObject webInfFo;
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule != null && (webInfFo = webModule.getWebInf()) != null) {
            FileObject wsdlFo = webInfFo.getFileObject("wsdl");
            if (wsdlFo != null) {
                return wsdlFo;
            }
            if (create) {
                return webInfFo.createFolder("wsdl");
            }
        }
        return null;
    }

    protected void addJaxWs20Library() throws Exception {
        SourceGroup[] sgs = SourceGroups.getJavaSourceGroups((Project)this.project);
        if (sgs.length > 0) {
            FileObject srcRoot = sgs[0].getRootFolder();
            ClassPath compileClassPath = ClassPath.getClassPath((FileObject)srcRoot, (String)"classpath/compile");
            ClassPath bootClassPath = ClassPath.getClassPath((FileObject)srcRoot, (String)"classpath/boot");
            ClassPath classPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{compileClassPath, bootClassPath});
            FileObject jaxWsClass = classPath.findResource("javax/xml/ws/WebServiceFeature.class");
            if (jaxWsClass == null) {
                Library MetroLib = LibraryManager.getDefault().getLibrary("metro");
                if (MetroLib != null) {
                    try {
                        ProjectClassPathModifier.addLibraries((Library[])new Library[]{MetroLib}, (FileObject)srcRoot, (String)"classpath/compile");
                    }
                    catch (IOException e) {
                        throw new Exception("Unable to add Metro library", e);
                    }
                } else {
                    throw new Exception("Unable to add Metro Library");
                }
            }
            try {
                WSUtils.addJaxWsApiEndorsed((Project)this.project, (FileObject)srcRoot);
            }
            catch (IOException ex) {
                Logger.getLogger(WebProjectJAXWSClientSupport.class.getName()).log(Level.FINE, "Cannot add JAX-WS-ENDORSED classpath", ex);
            }
        }
    }

    protected FileObject getXmlArtifactsRoot() {
        FileObject confDir = this.project.getWebModule().getConfDir();
        return confDir == null ? super.getXmlArtifactsRoot() : confDir;
    }

    protected String getProjectJavaEEVersion() {
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule != null) {
            if (Profile.JAVA_EE_6_WEB.equals(webModule.getJ2eeProfile())) {
                return "java-ee-version-16";
            }
            if (Profile.JAVA_EE_6_FULL.equals(webModule.getJ2eeProfile())) {
                return "java-ee-version-16";
            }
            if (Profile.JAVA_EE_7_WEB.equals(webModule.getJ2eeProfile())) {
                return "java-ee-version-17";
            }
            if (Profile.JAVA_EE_7_FULL.equals(webModule.getJ2eeProfile())) {
                return "java-ee-version-17";
            }
            if (Profile.JAVA_EE_8_WEB.equals(webModule.getJ2eeProfile())) {
                return "java-ee-version-18";
            }
            if (Profile.JAVA_EE_8_FULL.equals(webModule.getJ2eeProfile())) {
                return "java-ee-version-18";
            }
            if (Profile.JAVA_EE_5.equals(webModule.getJ2eeProfile())) {
                return "java-ee-version-15";
            }
        }
        return "java-ee-version-none";
    }
}

