/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.awt.Component;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.jsf.wizards.FacesComponentPanel;
import org.netbeans.modules.web.jsf.wizards.TemplateIterator;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class FacesComponentIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_COMPONENT_NS = "http://xmlns.jcp.org/jsf/component";
    private transient WizardDescriptor.Panel[] panels;
    private int index;
    private FacesComponentPanel facesComponentPanel;

    public Set<DataObject> instantiate(TemplateWizard wizard) throws IOException {
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)wizard);
        String targetName = Templates.getTargetName((WizardDescriptor)wizard);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)targetFolder);
        FileObject template = Templates.getTemplate((WizardDescriptor)wizard);
        DataObject dTemplate = DataObject.find((FileObject)template);
        HashMap<String, Object> templateProperties = new HashMap<String, Object>();
        String tagName = (String)wizard.getProperty("tagName");
        String tagNamespace = (String)wizard.getProperty("tagNamespace");
        Boolean createSampleCode = (Boolean)wizard.getProperty("sampleCode");
        if (!tagName.isEmpty() && !tagName.equals(FacesComponentIterator.tagNameForClassName(targetName))) {
            templateProperties.put("tagName", tagName);
        }
        if (!tagNamespace.isEmpty() && !tagNamespace.equals(DEFAULT_COMPONENT_NS)) {
            templateProperties.put("tagNamespace", tagNamespace);
        }
        if (createSampleCode.booleanValue()) {
            templateProperties.put("sampleCode", Boolean.TRUE);
        }
        DataObject result = dTemplate.createFromTemplate(dataFolder, targetName, templateProperties);
        return Collections.singleton(result);
    }

    private static String tagNameForClassName(String className) {
        if (className.isEmpty()) {
            return "";
        }
        return className.substring(0, 1).toLowerCase() + className.substring(1);
    }

    public void initialize(TemplateWizard wiz) {
        this.index = 0;
        Project project = Templates.getProject((WizardDescriptor)wiz);
        this.panels = this.createPanels(project, wiz);
        Object prop = wiz.getProperty("WizardPanel_contentData");
        String[] beforeSteps = null;
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = this.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(TemplateWizard wiz) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public String name() {
        return NbBundle.getMessage(TemplateIterator.class, (String)"TITLE_x_of_y", (Object)new Integer(this.index + 1), (Object)new Integer(this.panels.length));
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    protected WizardDescriptor.Panel[] createPanels(Project project, TemplateWizard wiz) {
        WizardDescriptor.Panel javaPanel;
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        this.facesComponentPanel = new FacesComponentPanel((WizardDescriptor)wiz);
        if (sourceGroups.length == 0) {
            wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(FacesComponentIterator.class, (String)"MSG_No_Sources_found"));
            javaPanel = this.facesComponentPanel;
        } else {
            javaPanel = JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])sourceGroups, (WizardDescriptor.Panel)this.facesComponentPanel);
        }
        return new WizardDescriptor.Panel[]{javaPanel};
    }

    private String[] createSteps(String[] before, WizardDescriptor.Panel[] panels) {
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getComponent().getName();
        }
        return res;
    }
}

