/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.annotation;

import java.util.List;
import java.util.concurrent.CancellationException;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.editor.ext.ToolTipSupport;
import org.netbeans.modules.javascript2.debug.ui.tooltip.AbstractJSToolTipAnnotation;
import org.netbeans.modules.web.javascript.debugger.annotation.Bundle;
import org.netbeans.modules.web.javascript.debugger.eval.Evaluator;
import org.netbeans.modules.web.javascript.debugger.locals.VariablesModel;
import org.netbeans.modules.web.webkit.debugging.api.Debugger;
import org.netbeans.modules.web.webkit.debugging.api.debugger.CallFrame;
import org.netbeans.modules.web.webkit.debugging.api.debugger.RemoteObject;
import org.openide.util.Pair;

public class ToolTipAnnotation
extends AbstractJSToolTipAnnotation {
    protected void handleToolTipClose(DebuggerEngine engine, ToolTipSupport tts) {
        Debugger d = (Debugger)engine.lookupFirst(null, Debugger.class);
        if (d == null || !d.isSuspended()) {
            return;
        }
        ToolTipAnnotation.handleToolTipClose(d, tts);
    }

    static void handleToolTipClose(Debugger d, final ToolTipSupport tts) {
        Debugger.Listener dl = new Debugger.Listener(){

            public void paused(List<CallFrame> callStack, String reason) {
            }

            public void resumed() {
                this.doClose();
            }

            public void reset() {
                this.doClose();
            }

            public void enabled(boolean enabled) {
                if (!enabled) {
                    this.doClose();
                }
            }

            private void doClose() {
                tts.setToolTipVisible(false);
            }
        };
        d.addListener(dl);
        tts.addPropertyChangeListener(pl -> {
            if ("status".equals(pl.getPropertyName()) && !tts.isToolTipVisible()) {
                d.removeListener(dl);
            }
        });
    }

    protected Pair<String, Object> evaluate(String expression, DebuggerEngine engine) throws CancellationException {
        String tooltipText;
        Debugger d = (Debugger)engine.lookupFirst(null, Debugger.class);
        if (d == null || !d.isSuspended()) {
            return null;
        }
        CallFrame currentCallFrame = d.getCurrentCallFrame();
        VariablesModel.ScopedRemoteObject sv = Evaluator.evaluateExpression(currentCallFrame, expression, true);
        VariablesModel.ScopedRemoteObject tooltipVariable = null;
        if (sv != null) {
            RemoteObject var = sv.getRemoteObject();
            String value = ToolTipAnnotation.getStringValue(var);
            RemoteObject.Type type = var.getType();
            if (type == RemoteObject.Type.OBJECT) {
                tooltipVariable = sv;
            }
            if (type != RemoteObject.Type.UNDEFINED) {
                tooltipText = expression + " = " + value;
            } else {
                tooltipText = var.getDescription();
                if (tooltipText == null) {
                    tooltipText = Bundle.var_undefined(expression);
                }
            }
        } else {
            throw new CancellationException();
        }
        return Pair.of((Object)tooltipText, (Object)tooltipVariable);
    }

    static String getStringValue(RemoteObject var) {
        String value = var.getValueAsString();
        RemoteObject.Type type = var.getType();
        switch (type) {
            case STRING: {
                value = "\"" + value + "\"";
                break;
            }
            case FUNCTION: {
                value = var.getDescription();
                break;
            }
            case OBJECT: {
                String clazz = var.getClassName();
                if (clazz == null) {
                    clazz = type.getName();
                }
                if (value.isEmpty()) {
                    value = var.getDescription();
                }
                value = "(" + clazz + ") " + value;
            }
        }
        return value;
    }
}

