/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.browser.api.WebBrowsers;
import org.netbeans.modules.web.inspect.PageModel;
import org.netbeans.modules.web.inspect.webkit.ui.CustomToolbar;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class DomPanel
extends JPanel
implements ExplorerManager.Provider {
    private static final RequestProcessor RP = new RequestProcessor(DomPanel.class.getName(), 5);
    private final ExplorerManager manager = new ExplorerManager();
    private BeanTreeView treeView;
    private JLabel noDomLabel;
    private JLabel urlLabel;
    private JPanel headerPanel;
    private AbstractButton selectModeButton;
    private final PageModel pageModel;
    private boolean updatingView = false;
    private final List highlightedTreeNodes = new ArrayList();

    public DomPanel(PageModel pageModel) {
        this.pageModel = pageModel;
        this.setLayout(new BorderLayout());
        this.initTreeView();
        this.initNoDOMLabel();
        this.initHeader();
        this.add(this.noDomLabel);
        this.add((Component)this.headerPanel, "First");
        if (pageModel != null) {
            pageModel.addPropertyChangeListener(this.createModelListener());
            this.manager.addPropertyChangeListener(this.createSelectedNodesListener());
            this.update();
        }
    }

    private void initTreeView() {
        this.treeView = new BeanTreeView(){
            {
                MouseAdapter listener = DomPanel.this.createTreeMouseListener();
                this.tree.addMouseListener(listener);
                this.tree.addMouseMotionListener(listener);
                this.tree.setCellRenderer(DomPanel.this.createTreeCellRenderer(this.tree.getCellRenderer()));
            }
        };
        this.treeView.setAllowedDragActions(0);
        this.treeView.setAllowedDropActions(0);
        this.treeView.setRootVisible(false);
    }

    private MouseAdapter createTreeMouseListener() {
        return new MouseAdapter(){
            private Object lastHover = null;

            @Override
            public void mouseEntered(MouseEvent e) {
                this.processEvent(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.processEvent(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.processEvent(null);
                this.lastHover = new Object();
            }

            private void processEvent(MouseEvent e) {
                JTree tree;
                TreePath path;
                Object hover = null;
                if (e != null && (path = (tree = (JTree)e.getSource()).getPathForLocation(e.getX(), e.getY())) != null) {
                    hover = path.getLastPathComponent();
                }
                if (hover != this.lastHover) {
                    List<Node> highlight;
                    this.lastHover = hover;
                    if (hover != null) {
                        Node node = Visualizer.findNode(hover);
                        highlight = Arrays.asList(node);
                    } else {
                        highlight = Collections.EMPTY_LIST;
                    }
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            DomPanel.this.pageModel.setHighlightedNodes(highlight);
                        }
                    });
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void updateHighlight() {
        List list = this.highlightedTreeNodes;
        synchronized (list) {
            this.highlightedTreeNodes.clear();
            for (Node node : this.pageModel.getHighlightedNodes()) {
                TreeNode visualizer = Visualizer.findVisualizer((Node)node);
                this.highlightedTreeNodes.add(visualizer);
            }
        }
        this.treeView.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isHighlighted(Object treeNode) {
        List list = this.highlightedTreeNodes;
        synchronized (list) {
            return this.highlightedTreeNodes.contains(treeNode);
        }
    }

    private TreeCellRenderer createTreeCellRenderer(final TreeCellRenderer delegate) {
        Color origColor = UIManager.getColor("Tree.selectionBackground");
        Color color = origColor.brighter().brighter();
        if (color.equals(Color.WHITE)) {
            color = origColor.darker();
        }
        final Color hoverColor = color;
        final boolean nimbus = "Nimbus".equals(UIManager.getLookAndFeel().getID());
        final JPanel nimbusPanel = nimbus ? new JPanel(new BorderLayout()) : null;
        return new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JComponent component;
                if (!selected && DomPanel.this.isHighlighted(value)) {
                    component = (JComponent)delegate.getTreeCellRendererComponent(tree, value, true, expanded, leaf, row, hasFocus);
                    if (nimbus) {
                        nimbusPanel.removeAll();
                        nimbusPanel.add(component);
                        component = nimbusPanel;
                    }
                    component.setBackground(hoverColor);
                    component.setOpaque(true);
                } else {
                    component = (JLabel)delegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                }
                return component;
            }
        };
    }

    private void initNoDOMLabel() {
        this.noDomLabel = new JLabel();
        this.noDomLabel.setText(NbBundle.getMessage(DomPanel.class, (String)"DomPanel.noDomLabel.text"));
        this.noDomLabel.setHorizontalAlignment(0);
        this.noDomLabel.setVerticalAlignment(0);
        this.noDomLabel.setEnabled(false);
        this.noDomLabel.setBackground(UIManager.getColor("Tree.background"));
        this.noDomLabel.setOpaque(true);
    }

    private void initHeader() {
        this.selectModeButton = this.createSelectModeButton();
        this.initURLLabel();
        CustomToolbar toolbar = new CustomToolbar();
        toolbar.addButton(this.selectModeButton);
        this.headerPanel = new JPanel();
        this.headerPanel.setLayout(new BoxLayout(this.headerPanel, 0));
        this.headerPanel.add(toolbar);
        this.headerPanel.add(this.urlLabel);
        this.headerPanel.setVisible(false);
    }

    private void initURLLabel() {
        this.urlLabel = new JLabel(){

            @Override
            public Dimension getMinimumSize() {
                Dimension dim = super.getMinimumSize();
                return new Dimension(0, dim.height);
            }
        };
        this.urlLabel.setOpaque(false);
        if (this.pageModel != null) {
            BrowserFamilyId id;
            Lookup lookup = this.pageModel.getPageContext();
            Image image = (Image)lookup.lookup(Image.class);
            Icon icon = image == null ? (Icon)lookup.lookup(Icon.class) : new ImageIcon(image);
            if (icon == null && (id = (BrowserFamilyId)lookup.lookup(BrowserFamilyId.class)) != null) {
                for (WebBrowser browser : WebBrowsers.getInstance().getAll(true, true, true, false)) {
                    if (!browser.hasNetBeansIntegration() || id != browser.getBrowserFamily() || (image = browser.getIconImage(true)) == null) continue;
                    icon = new ImageIcon(image);
                    break;
                }
            }
            if (icon != null) {
                this.urlLabel.setIcon(icon);
            }
        }
    }

    private AbstractButton createSelectModeButton() {
        JToggleButton button = new JToggleButton();
        button.setFocusPainted(false);
        button.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/web/inspect/resources/selectionMode.png", (boolean)true));
        button.setToolTipText(NbBundle.getMessage(DomPanel.class, (String)"DomPanel.inspectMode"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractButton button = (AbstractButton)e.getSource();
                final boolean selectMode = button.isSelected();
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        DomPanel.this.pageModel.setSelectionMode(selectMode);
                    }
                });
            }
        });
        return button;
    }

    void updateSelectionMode() {
        if (EventQueue.isDispatchThread()) {
            boolean selectMode = this.pageModel.isSelectionMode();
            this.selectModeButton.setSelected(selectMode);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DomPanel.this.updateSelectionMode();
                }
            });
        }
    }

    private void update() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                final Node node = DomPanel.this.pageModel.getDocumentNode();
                final String url = DomPanel.this.pageModel.getDocumentURL();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DomPanel.this.update(node, url);
                        DomPanel.this.updateSelection();
                        DomPanel.this.updateHighlight();
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Node documentNode, String url) {
        assert (EventQueue.isDispatchThread());
        this.updatingView = true;
        try {
            if (documentNode == null) {
                AbstractNode root = new AbstractNode(Children.LEAF);
                this.headerPanel.setVisible(false);
                this.replace((Component)this.treeView, this.noDomLabel);
                this.manager.setRootContext((Node)root);
            } else {
                this.manager.setRootContext(documentNode);
                this.urlLabel.setText(url);
                this.headerPanel.setVisible(true);
                this.replace(this.noDomLabel, (Component)this.treeView);
                this.expandNodes();
            }
        }
        finally {
            this.updatingView = false;
        }
    }

    private void expandNodes() {
        Node root = this.manager.getRootContext();
        this.treeView.expandNode(root);
        for (Node node : root.getChildren().getNodes()) {
            String nodeName = node.getName();
            if (nodeName == null || !nodeName.trim().equalsIgnoreCase("html")) continue;
            this.treeView.expandNode(node);
            for (Node subNode : node.getChildren().getNodes()) {
                nodeName = subNode.getName();
                if (nodeName == null || !nodeName.trim().equalsIgnoreCase("body")) continue;
                this.treeView.expandNode(subNode);
            }
        }
    }

    private void replace(Component componentToHide, Component componentToShow) {
        if (componentToHide.getParent() != null) {
            this.remove(componentToHide);
            this.add(componentToShow);
            this.revalidate();
            this.repaint();
        }
    }

    private PropertyChangeListener createModelListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propName = evt.getPropertyName();
                if ("selectedNodes".equals(propName)) {
                    DomPanel.this.updateSelection();
                } else if ("highlightedNodes".equals(propName)) {
                    DomPanel.this.updateHighlight();
                } else if ("document".equals(propName)) {
                    DomPanel.this.update();
                } else if ("selectionMode".equals(propName)) {
                    DomPanel.this.updateSelectionMode();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSelection() {
        if (EventQueue.isDispatchThread()) {
            List nodes = this.pageModel.getSelectedNodes();
            Node[] selection = nodes.toArray(new Node[0]);
            this.updatingView = true;
            try {
                this.manager.setSelectedNodes(selection);
            }
            catch (PropertyVetoException pvex) {
                Logger.getLogger(DomPanel.class.getName()).log(Level.INFO, null, pvex);
            }
            finally {
                this.updatingView = false;
            }
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DomPanel.this.updateSelection();
                }
            });
        }
    }

    private PropertyChangeListener createSelectedNodesListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propName = evt.getPropertyName();
                if ("selectedNodes".equals(propName)) {
                    if (DomPanel.this.updatingView) {
                        return;
                    }
                    final Node[] nodes = DomPanel.this.manager.getSelectedNodes();
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            DomPanel.this.pageModel.setSelectedNodes(Arrays.asList(nodes));
                        }
                    });
                }
            }
        };
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.treeView.requestFocusInWindow();
    }
}

