/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.files;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Files {
    private static final Logger LOGGER = Logger.getLogger(Files.class.getName());
    private static final String RESOURCE_BASE = "/org/netbeans/modules/web/inspect/files/";
    private static final String SCRIPT_EXTENSION = ".js";
    private static final String SCRIPT_COMMENT_START = "/*";
    private static final String SCRIPT_COMMENT_END = "*/";
    private static final String HTML_EXTENSION = ".html";
    private static final String HTML_COMMENT_START = "<!--";
    private static final String HTML_COMMENT_END = "-->";
    private static final ConcurrentMap<String, String> FILES = new ConcurrentHashMap<String, String>();

    private Files() {
    }

    public static String getScript(String name) {
        return Files.getContent(name + SCRIPT_EXTENSION, SCRIPT_COMMENT_START, SCRIPT_COMMENT_END);
    }

    public static String getHtml(String name) {
        return Files.getContent(name + HTML_EXTENSION, HTML_COMMENT_START, HTML_COMMENT_END);
    }

    private static String getContent(String filename, String commentStart, String commentEnd) {
        String content = (String)FILES.get(filename);
        if (content != null) {
            return content;
        }
        String resourceName = RESOURCE_BASE + filename;
        content = Files.loadContent(resourceName, commentStart, commentEnd);
        FILES.put(filename, content);
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadContent(String resourceName, String commentStart, String commentEnd) {
        InputStream stream = Files.class.getResourceAsStream(resourceName);
        String content = null;
        if (stream != null) {
            BufferedReader br = new BufferedReader(new InputStreamReader(stream, Charset.forName("UTF-8")));
            try {
                String line;
                StringBuilder sb = new StringBuilder(stream.available());
                while ((line = br.readLine()) != null) {
                    sb.append(line).append('\n');
                }
                content = Files.removeLicense(sb.toString(), commentStart, commentEnd);
            }
            catch (IOException ioex) {
                LOGGER.log(Level.INFO, null, ioex);
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                }
            }
        }
        return content;
    }

    private static String removeLicense(String content, String commentStart, String commentEnd) {
        while (content.trim().startsWith(commentStart)) {
            int endOfComment = content.indexOf(commentEnd);
            content = content.substring(endOfComment + commentEnd.length()).trim();
        }
        return content;
    }
}

