/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el.completion;

import com.sun.el.parser.AstDotSuffix;
import com.sun.el.parser.AstIdentifier;
import com.sun.el.parser.AstMethodArguments;
import com.sun.el.parser.Node;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementScanner6;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.spi.DefaultCompletionProposal;
import org.netbeans.modules.web.el.AstPath;
import org.netbeans.modules.web.el.CompilationContext;
import org.netbeans.modules.web.el.ELElement;
import org.netbeans.modules.web.el.completion.ELCodeCompletionHandler;

public class ELJavaCompletion {
    private static final Set<Modifier> PUBLIC_STATIC = EnumSet.of(Modifier.PUBLIC, Modifier.STATIC);
    private static final Set<ElementKind> FIELD_METHOD = EnumSet.of(ElementKind.FIELD, ElementKind.METHOD);
    private static final String JAVA_LANG_PACKAGE = "java.lang";
    private static final String JAVA_LANG_PREFIX = "java.lang.";
    private static final PackageEntry DEFAULT_PACKAGE = new PackageEntry("java.lang", true);

    private ELJavaCompletion() {
    }

    protected static void propose(CompilationContext ccontext, CodeCompletionContext context, ELElement element, Node targetNode, List<CompletionProposal> proposals) throws IOException {
        String prefix = ELJavaCompletion.getPrefixForNode(context, element, targetNode);
        ELCodeCompletionHandler.PrefixMatcher prefixMatcher = ELCodeCompletionHandler.PrefixMatcher.create(prefix, context);
        ELJavaCompletion.doJavaCompletion(ccontext, prefixMatcher, context.getCaretOffset() - prefix.length(), proposals);
    }

    private static String getPrefixForNode(CodeCompletionContext context, ELElement element, Node targetNode) {
        if (targetNode instanceof AstDotSuffix) {
            AstPath path = new AstPath(element.getNode());
            return ELJavaCompletion.extractPrefixFromPath(path.rootToNode(targetNode)) + ".";
        }
        if (targetNode instanceof AstMethodArguments) {
            AstPath path = new AstPath(targetNode);
            return ELJavaCompletion.extractPrefixFromPath(path.rootToLeaf());
        }
        return context.getPrefix() != null ? context.getPrefix() : "";
    }

    private static void doJavaCompletion(CompilationContext ccontext, ELCodeCompletionHandler.PrefixMatcher pm, int offset, List<CompletionProposal> proposals) throws IOException {
        CompilationController cc = (CompilationController)ccontext.info();
        String packName = pm.getPrefix();
        int dotIndex = pm.getPrefix().lastIndexOf(46);
        if (dotIndex != -1) {
            packName = pm.getPrefix().substring(0, dotIndex);
        }
        ELJavaCompletion.addPackages(cc, pm.getPrefix(), offset, proposals);
        HashSet<PackageEntry> packages = new HashSet<PackageEntry>();
        if (dotIndex == -1) {
            packages.add(DEFAULT_PACKAGE);
        }
        if (!packName.isEmpty()) {
            packages.add(new PackageEntry(packName, false));
        }
        ELJavaCompletion.addTypesFromPackages(cc, pm, packages, offset + dotIndex + 1, proposals);
        TypeElement typeElement = cc.getElements().getTypeElement(packName);
        if (typeElement == null && dotIndex != -1) {
            typeElement = cc.getElements().getTypeElement(JAVA_LANG_PREFIX + pm.getPrefix().substring(0, dotIndex));
        }
        if (typeElement != null) {
            proposals.addAll(ELJavaCompletion.getFieldsAndMethods(typeElement, offset + dotIndex + 1));
        }
    }

    private static void addTypesFromPackages(CompilationController cc, ELCodeCompletionHandler.PrefixMatcher pm, Set<PackageEntry> packages, int offset, List<CompletionProposal> proposals) {
        for (PackageEntry packageEntry : packages) {
            PackageElement pkgElem = cc.getElements().getPackageElement(packageEntry.packageName);
            if (pkgElem == null) continue;
            List tes = (List)new TypeScanner().scan(pkgElem);
            for (TypeElement te : tes) {
                JavaTypeCompletionItem item;
                if (packageEntry.imported) {
                    if (!pm.matches(te.getSimpleName().toString())) continue;
                    item = new JavaTypeCompletionItem(te, offset);
                    proposals.add((CompletionProposal)item);
                    continue;
                }
                if (!pm.matches(te.getQualifiedName().toString())) continue;
                item = new JavaTypeCompletionItem(te, offset);
                proposals.add((CompletionProposal)item);
            }
        }
    }

    private static Collection<DefaultCompletionProposal> getFieldsAndMethods(TypeElement typeElement, int i) {
        HashMap<String, JavaFieldCompletionItem> classProposals = new HashMap<String, JavaFieldCompletionItem>();
        for (Element element : typeElement.getEnclosedElements()) {
            if (!element.getModifiers().containsAll(PUBLIC_STATIC) || !FIELD_METHOD.contains((Object)element.getKind())) continue;
            classProposals.put(element.getSimpleName().toString(), new JavaFieldCompletionItem(element, typeElement.getSimpleName().toString(), i));
        }
        return classProposals.values();
    }

    private static void addPackages(CompilationController controler, String fqnPrefix, int offset, List<CompletionProposal> proposals) {
        if (fqnPrefix == null || fqnPrefix.isEmpty()) {
            fqnPrefix = "java";
        }
        for (String pkgName : controler.getClasspathInfo().getClassIndex().getPackageNames(fqnPrefix, true, EnumSet.allOf(ClassIndex.SearchScope.class))) {
            if (!ELJavaCompletion.isImportedPackage(pkgName)) continue;
            proposals.add((CompletionProposal)new JavaPackageCompletionItem(pkgName, offset));
        }
    }

    private static String extractPrefixFromPath(List<Node> pathToNode) {
        StringBuilder sb = new StringBuilder();
        for (Node node : pathToNode) {
            if (node instanceof AstIdentifier) {
                sb.append(node.getImage());
                continue;
            }
            if (!(node instanceof AstDotSuffix)) continue;
            sb.append(".").append(node.getImage());
        }
        return sb.toString();
    }

    private static boolean isImportedPackage(String pkgName) {
        return pkgName.startsWith("java.") || pkgName.startsWith("javax.") || pkgName.equals("java") || pkgName.equals("javax");
    }

    private static final class PackageEntry {
        private final String packageName;
        private final boolean imported;

        public PackageEntry(String packageName, boolean imported) {
            this.packageName = packageName;
            this.imported = imported;
        }

        public int hashCode() {
            int hash = 7;
            hash = 23 * hash + this.packageName.hashCode();
            hash = 23 * hash + Boolean.valueOf(this.imported).hashCode();
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PackageEntry other = (PackageEntry)obj;
            if (!this.packageName.equals(other.packageName)) {
                return false;
            }
            return this.imported == other.imported;
        }
    }

    private static final class TypeScanner
    extends ElementScanner6<List<TypeElement>, Void> {
        public TypeScanner() {
            super(new ArrayList());
        }

        private static boolean isAccessibleClass(TypeElement te) {
            NestingKind nestingKind = te.getNestingKind();
            return nestingKind == NestingKind.TOP_LEVEL && te.getModifiers().contains((Object)Modifier.PUBLIC);
        }

        @Override
        public List<TypeElement> visitType(TypeElement typeElement, Void arg) {
            if (typeElement.getKind() == ElementKind.CLASS && TypeScanner.isAccessibleClass(typeElement)) {
                ((List)this.DEFAULT_VALUE).add(typeElement);
            }
            return (List)super.visitType(typeElement, arg);
        }
    }

    private static final class JavaPackageCompletionItem
    extends DefaultCompletionProposal {
        private final String name;
        private final int offset;

        public JavaPackageCompletionItem(String name, int offset) {
            this.name = name;
            this.offset = offset;
        }

        public ElementHandle getElement() {
            return null;
        }

        public org.netbeans.modules.csl.api.ElementKind getKind() {
            return org.netbeans.modules.csl.api.ElementKind.PACKAGE;
        }

        public int getAnchorOffset() {
            return this.offset;
        }

        public String getName() {
            return this.name;
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return this.name;
        }
    }

    private static final class JavaFieldCompletionItem
    extends DefaultCompletionProposal {
        private final String name;
        private final String enclosingName;
        private final org.netbeans.modules.csl.api.ElementKind kind;
        private final int offset;

        public JavaFieldCompletionItem(Element e, String enclosingName, int offset) {
            this.name = e.getSimpleName().toString();
            this.enclosingName = enclosingName;
            this.kind = e.getKind() == ElementKind.METHOD ? org.netbeans.modules.csl.api.ElementKind.METHOD : org.netbeans.modules.csl.api.ElementKind.CONSTANT;
            this.offset = offset;
        }

        public ElementHandle getElement() {
            return null;
        }

        public org.netbeans.modules.csl.api.ElementKind getKind() {
            return this.kind;
        }

        public String getName() {
            return this.name;
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return this.enclosingName;
        }

        public int getAnchorOffset() {
            return this.offset;
        }

        public String getCustomInsertTemplate() {
            if (this.isMethod()) {
                return super.getCustomInsertTemplate() + "(${cursor})";
            }
            return super.getCustomInsertTemplate();
        }

        private boolean isMethod() {
            return this.kind == org.netbeans.modules.csl.api.ElementKind.METHOD;
        }
    }

    private static final class JavaTypeCompletionItem
    extends DefaultCompletionProposal {
        private final String simpleName;
        private final String fqn;
        private final int offset;

        public JavaTypeCompletionItem(TypeElement te, int offset) {
            this.simpleName = te.getSimpleName().toString();
            this.fqn = te.getQualifiedName().toString();
            this.offset = offset;
        }

        public ElementHandle getElement() {
            return null;
        }

        public org.netbeans.modules.csl.api.ElementKind getKind() {
            return org.netbeans.modules.csl.api.ElementKind.CLASS;
        }

        public String getName() {
            return this.simpleName;
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return this.fqn;
        }

        public int getAnchorOffset() {
            return this.offset;
        }
    }
}

