/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui.customizer;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.api.platform.PlatformProviders;
import org.netbeans.modules.web.clientproject.env.CommonProjectHelper;
import org.netbeans.modules.web.clientproject.env.Env;
import org.netbeans.modules.web.clientproject.env.Licenses;
import org.netbeans.modules.web.clientproject.spi.platform.ClientProjectEnhancedBrowserImplementation;
import org.netbeans.modules.web.clientproject.ui.customizer.Bundle;
import org.netbeans.modules.web.clientproject.util.ClientSideProjectUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.EditableProperties;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.RequestProcessor;

public final class ClientSideProjectProperties {
    private static final Logger LOGGER = Logger.getLogger(ClientSideProjectProperties.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(ClientSideProjectProperties.class);
    final ClientSideProject project;
    private volatile AtomicReference<String> sourceFolder = null;
    private volatile AtomicReference<String> siteRootFolder = null;
    private volatile AtomicReference<String> testFolder = null;
    private volatile AtomicReference<String> testSeleniumFolder = null;
    private volatile String jsLibFolder = null;
    private volatile String encoding = null;
    private volatile Boolean runBrowser = null;
    private volatile AtomicReference<String> runAs = null;
    private volatile String startFile = null;
    private volatile String selectedBrowser = null;
    private volatile String webRoot = null;
    private volatile String projectUrl = null;
    private volatile ProjectServer projectServer = null;
    private volatile ClientProjectEnhancedBrowserImplementation enhancedBrowserSettings = null;
    private volatile Boolean autoconfigured = null;
    private Licenses licenseSupport;

    public ClientSideProjectProperties(ClientSideProject project) {
        this.project = project;
    }

    public void save() {
        assert (!EventQueue.isDispatchThread());
        try {
            this.getLicenseSupport().saveLicenseFile();
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    ClientSideProjectProperties.this.saveProperties();
                    ClientSideProjectProperties.this.saveEnhancedBrowserConfiguration();
                    ProjectManager.getDefault().saveProject((Project)ClientSideProjectProperties.this.project);
                    return null;
                }
            });
            RP.post(new Runnable(){

                @Override
                public void run() {
                    ClientSideProjectProperties.this.firePropertyChanges();
                }
            }, 100);
        }
        catch (IOException | MutexException e) {
            LOGGER.log(Level.WARNING, null, e);
        }
    }

    void saveProperties() {
        String sourceFolderReference = this.createForeignFileReference(this.sourceFolder, true);
        String siteRootFolderReference = this.createForeignFileReference(this.siteRootFolder, true);
        String testFolderReference = this.createForeignFileReference(this.testFolder, false);
        String testSeleniumFolderReference = this.createForeignFileReference(this.testSeleniumFolder, false);
        EditableProperties privateProperties = this.project.getProjectHelper().getProperties(CommonProjectHelper.PRIVATE_PROPERTIES_PATH);
        EditableProperties projectProperties = this.project.getProjectHelper().getProperties(CommonProjectHelper.PROJECT_PROPERTIES_PATH);
        if (this.sourceFolder != null) {
            if (sourceFolderReference != null) {
                this.putProperty(projectProperties, "source.folder", sourceFolderReference);
            } else {
                projectProperties.remove((Object)"source.folder");
            }
        }
        if (this.siteRootFolder != null) {
            if (siteRootFolderReference != null) {
                File siteRootF = this.project.getProjectHelper().resolveFile(this.siteRootFolder.get());
                if (siteRootF != null && siteRootF.exists()) {
                    this.putProperty(projectProperties, "site.root.folder", siteRootFolderReference);
                }
            } else {
                projectProperties.remove((Object)"site.root.folder");
            }
        }
        if (this.testFolder != null) {
            if (testFolderReference != null) {
                this.putProperty(projectProperties, "test.folder", testFolderReference);
            } else {
                projectProperties.remove((Object)"test.folder");
            }
        }
        if (this.testSeleniumFolder != null) {
            if (testSeleniumFolderReference != null) {
                this.putProperty(projectProperties, "test.selenium.folder", testSeleniumFolderReference);
            } else {
                projectProperties.remove((Object)"test.selenium.folder");
            }
        }
        this.putProperty(projectProperties, "files.encoding", this.encoding);
        if (this.runAs != null) {
            String runAsValue = this.runAs.get();
            if (runAsValue != null) {
                this.putProperty(projectProperties, "run.as", runAsValue);
            } else {
                projectProperties.remove((Object)"run.as");
            }
        }
        this.putProperty(projectProperties, "browser.run", this.runBrowser);
        this.putProperty(projectProperties, "start.file", this.startFile);
        projectProperties.remove((Object)"browser");
        this.putProperty(privateProperties, "browser", this.selectedBrowser);
        if (this.projectServer != null) {
            projectProperties.remove((Object)"server");
            this.putProperty(privateProperties, "server", this.projectServer.name());
        }
        projectProperties.remove((Object)"external.project.url");
        this.putProperty(privateProperties, "external.project.url", this.projectUrl);
        this.putProperty(projectProperties, "web.context.root", this.webRoot);
        this.getLicenseSupport().updateProperties(projectProperties);
        if (this.autoconfigured != null) {
            if (this.autoconfigured.booleanValue()) {
                privateProperties.put("autoconfigured", Boolean.TRUE.toString());
            } else {
                privateProperties.remove((Object)"autoconfigured");
            }
        }
        this.project.getProjectHelper().putProperties(CommonProjectHelper.PROJECT_PROPERTIES_PATH, projectProperties);
        this.project.getProjectHelper().putProperties(CommonProjectHelper.PRIVATE_PROPERTIES_PATH, privateProperties);
    }

    void saveEnhancedBrowserConfiguration() {
        assert (ProjectManager.mutex().isWriteAccess()) : "Write mutex required";
        if (this.enhancedBrowserSettings != null) {
            this.enhancedBrowserSettings.save();
        }
    }

    void firePropertyChanges() {
        if (this.runAs != null) {
            String runAsValue = this.runAs.get();
            PlatformProviders.getDefault().notifyPropertyChanged((Project)this.project, new PropertyChangeEvent(this.project, "RUN_CONFIGURATION", null, runAsValue));
        }
    }

    ClientProjectEnhancedBrowserImplementation createEnhancedBrowserSettings(WebBrowser wb) {
        this.enhancedBrowserSettings = ClientSideProject.createEnhancedBrowserImpl(this.project, wb);
        return this.enhancedBrowserSettings;
    }

    public ClientSideProject getProject() {
        return this.project;
    }

    public boolean isAutoconfigured() {
        if (this.autoconfigured == null) {
            this.autoconfigured = Boolean.parseBoolean(this.getProjectProperty("autoconfigured", Boolean.FALSE.toString()));
        }
        return this.autoconfigured;
    }

    public void setAutoconfigured(boolean autoconfigured) {
        this.autoconfigured = autoconfigured;
    }

    public AtomicReference<String> getSourceFolder() {
        if (this.sourceFolder == null) {
            this.sourceFolder = new AtomicReference<String>(this.getProjectProperty("source.folder", null));
        }
        return this.sourceFolder;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = new AtomicReference<String>(sourceFolder);
    }

    public AtomicReference<String> getSiteRootFolder() {
        if (this.siteRootFolder == null) {
            this.siteRootFolder = new AtomicReference<String>(this.getProjectProperty("site.root.folder", null));
        }
        return this.siteRootFolder;
    }

    public void setSiteRootFolder(String siteRootFolder) {
        this.siteRootFolder = new AtomicReference<String>(siteRootFolder);
    }

    public AtomicReference<String> getTestFolder() {
        if (this.testFolder == null) {
            this.testFolder = new AtomicReference<String>(this.getProjectProperty("test.folder", null));
        }
        return this.testFolder;
    }

    public void setTestFolder(String testFolder) {
        this.testFolder = new AtomicReference<String>(testFolder);
    }

    public AtomicReference<String> getTestSeleniumFolder() {
        if (this.testSeleniumFolder == null) {
            this.testSeleniumFolder = new AtomicReference<String>(this.getProjectProperty("test.selenium.folder", null));
        }
        return this.testSeleniumFolder;
    }

    public void setTestSeleniumFolder(String testSeleniumFolder) {
        this.testSeleniumFolder = new AtomicReference<String>(testSeleniumFolder);
    }

    public String getEncoding() {
        if (this.encoding == null) {
            this.encoding = this.getProjectProperty("files.encoding", ClientSideProjectUtilities.DEFAULT_PROJECT_CHARSET.name());
        }
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public AtomicReference<String> getRunAs() {
        if (this.runAs == null) {
            this.runAs = new AtomicReference<String>(this.getProjectProperty("run.as", null));
        }
        return this.runAs;
    }

    public void setRunAs(String runAs) {
        this.runAs = new AtomicReference<String>(runAs);
    }

    public boolean isRunBrowser() {
        if (this.runBrowser == null) {
            this.runBrowser = this.project.isRunBrowser();
        }
        return this.runBrowser;
    }

    public void setRunBrowser(boolean runBrowser) {
        this.runBrowser = runBrowser;
    }

    public String getStartFile() {
        if (this.startFile == null) {
            this.startFile = this.project.getStartFile();
        }
        return this.startFile;
    }

    public void setStartFile(String startFile) {
        this.startFile = startFile;
    }

    public String getSelectedBrowser() {
        if (this.selectedBrowser == null) {
            this.selectedBrowser = this.project.getSelectedBrowser();
        }
        return this.selectedBrowser;
    }

    public void setSelectedBrowser(String selectedBrowser) {
        this.selectedBrowser = selectedBrowser;
    }

    public String getWebRoot() {
        if (this.webRoot == null) {
            this.webRoot = this.project.getWebContextRoot();
        }
        return this.webRoot;
    }

    public void setWebRoot(String webRoot) {
        this.webRoot = webRoot;
    }

    public String getProjectUrl() {
        if (this.projectUrl == null) {
            this.projectUrl = this.getProjectProperty("external.project.url", "");
        }
        return this.projectUrl;
    }

    public void setProjectUrl(String projectUrl) {
        this.projectUrl = projectUrl;
    }

    public ProjectServer getProjectServer() {
        if (this.projectServer == null) {
            String value = this.getProjectProperty("server", ProjectServer.INTERNAL.name());
            try {
                this.projectServer = ProjectServer.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                LOGGER.log(Level.INFO, "Unknown project server type", ex);
                this.projectServer = ProjectServer.INTERNAL;
            }
        }
        return this.projectServer;
    }

    public void setProjectServer(ProjectServer projectServer) {
        this.projectServer = projectServer;
    }

    public void setJsLibFolder(String jsLibFolder) {
        assert (jsLibFolder != null);
        this.jsLibFolder = jsLibFolder;
    }

    public String getJsLibFolder() {
        return this.jsLibFolder;
    }

    @CheckForNull
    public File getResolvedSourceFolder() {
        return this.resolveFile(this.getSourceFolder().get());
    }

    @CheckForNull
    public File getResolvedSiteRootFolder() {
        return this.resolveFile(this.getSiteRootFolder().get());
    }

    @CheckForNull
    public File getResolvedTestFolder() {
        return this.resolveFile(this.getTestFolder().get());
    }

    @CheckForNull
    public File getResolvedStartFile() {
        String siteRoot = this.getSiteRootFolder().get();
        if (siteRoot == null) {
            return null;
        }
        return this.resolveFile(siteRoot + (siteRoot.isEmpty() ? "" : "/") + this.getStartFile());
    }

    private String getProjectProperty(String property, String defaultValue) {
        String value = this.project.getEvaluator().getProperty(property);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    private void putProperty(EditableProperties properties, String property, String value) {
        if (value != null) {
            properties.put(property, value);
        }
    }

    private void putProperty(EditableProperties properties, String property, Boolean value) {
        if (value != null) {
            properties.put(property, value.toString());
        }
    }

    private String createForeignFileReference(AtomicReference<String> filePath, boolean storeEmptyPath) {
        if (filePath == null) {
            return null;
        }
        return this.createForeignFileReference(filePath.get(), storeEmptyPath);
    }

    private String createForeignFileReference(String filePath, boolean storeEmptyPath) {
        if (filePath == null) {
            return null;
        }
        if (filePath.isEmpty()) {
            if (storeEmptyPath) {
                return "";
            }
            return null;
        }
        File file = this.project.getProjectHelper().resolveFile(filePath);
        return this.project.getReferenceHelper().createForeignFileReference(file, null);
    }

    @CheckForNull
    private File resolveFile(String path) {
        if (path == null) {
            return null;
        }
        if (path.isEmpty()) {
            return FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        }
        return this.project.getProjectHelper().resolveFile(path);
    }

    public Licenses getLicenseSupport() {
        if (this.licenseSupport == null) {
            Env is = this.project.is;
            this.licenseSupport = is.newLicensePanelSupport(this.project.getEvaluator(), this.project.getProjectHelper(), this.getProjectProperty("project.licensePath", null), this.getProjectProperty("project.license", null));
        }
        return this.licenseSupport;
    }

    public static final class ProjectServer
    extends Enum<ProjectServer> {
        public static final /* enum */ ProjectServer INTERNAL = new ProjectServer(Bundle.ProjectServer_internal_title());
        public static final /* enum */ ProjectServer EXTERNAL = new ProjectServer(Bundle.ProjectServer_external_title());
        private final String title;
        private static final /* synthetic */ ProjectServer[] $VALUES;

        public static ProjectServer[] values() {
            return (ProjectServer[])$VALUES.clone();
        }

        public static ProjectServer valueOf(String name) {
            return Enum.valueOf(ProjectServer.class, name);
        }

        private ProjectServer(String title) {
            assert (title != null);
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }

        static {
            $VALUES = new ProjectServer[]{INTERNAL, EXTERNAL};
        }
    }
}

