/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.browser.ui.picker;

import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JComponent;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import org.netbeans.modules.web.browser.ui.picker.ListItem;
import org.netbeans.modules.web.browser.ui.picker.SelectionListImpl;

final class SelectionList {
    private final SelectionListImpl theList = new SelectionListImpl();

    SelectionList() {
    }

    public JComponent getComponent() {
        return this.theList;
    }

    public void setItems(List<? extends ListItem> items) {
        final List<? extends ListItem> listItems = Collections.unmodifiableList(items);
        this.setItems((ListModel<ListItem>)new AbstractListModel<ListItem>(){

            @Override
            public int getSize() {
                return listItems.size();
            }

            @Override
            public ListItem getElementAt(int index) {
                return (ListItem)listItems.get(index);
            }
        });
    }

    public void setItems(ListModel<ListItem> items) {
        ListItem selItem = (ListItem)this.theList.getSelectedValue();
        this.theList.setModel(items);
        if (null != selItem) {
            this.setSelectedItem(selItem);
        }
    }

    ListSelectionModel getSelectionModel() {
        return this.theList.getSelectionModel();
    }

    void clearSelection() {
        this.theList.clearSelection();
    }

    ListItem getSelectedItem() {
        return (ListItem)this.theList.getSelectedValue();
    }

    boolean setSelectedItem(ListItem item) {
        ListModel model = this.theList.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            if (!item.equals(model.getElementAt(i))) continue;
            this.theList.setSelectedIndex(i);
            return true;
        }
        return false;
    }
}

