/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.modules.web.beans.impl.model.Filter;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;

public class RestrictedTypedFilter
extends Filter<TypeElement> {
    private TypeElement myElement;
    private WebBeansModelImplementation myImpl;

    @Override
    void filter(Set<TypeElement> elements) {
        HashSet<TypeElement> allImplementors = new HashSet<TypeElement>(elements);
        Iterator iterator = allImplementors.iterator();
        while (iterator.hasNext()) {
            TypeElement typeElement = (TypeElement)iterator.next();
            Collection<TypeMirror> restrictedTypes = RestrictedTypedFilter.getRestrictedTypes(typeElement, this.getImplementation());
            if (restrictedTypes == null) continue;
            boolean hasBeanType = false;
            TypeElement element = this.getElement();
            TypeMirror type = element.asType();
            Types types = this.getImplementation().getHelper().getCompilationController().getTypes();
            for (TypeMirror restrictedType : restrictedTypes) {
                if (!types.isSameType(types.erasure(type), types.erasure(restrictedType))) continue;
                hasBeanType = true;
                break;
            }
            if (hasBeanType) continue;
            iterator.remove();
        }
    }

    static Collection<TypeMirror> getRestrictedTypes(Element element, WebBeansModelImplementation implementation) {
        if (element == null) {
            return null;
        }
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        Map annotations = implementation.getHelper().getAnnotationsByType(annotationMirrors);
        AnnotationMirror typedAnnotation = (AnnotationMirror)annotations.get("javax.enterprise.inject.Typed");
        if (typedAnnotation == null) {
            return null;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = typedAnnotation.getElementValues();
        if (elementValues == null) {
            return Collections.emptyList();
        }
        AnnotationValue restrictedTypes = null;
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
            ExecutableElement key = entry.getKey();
            AnnotationValue value = entry.getValue();
            if (!key.getSimpleName().contentEquals("value")) continue;
            restrictedTypes = value;
            break;
        }
        if (restrictedTypes == null) {
            return Collections.emptyList();
        }
        Object value = restrictedTypes.getValue();
        LinkedList<TypeMirror> result = new LinkedList<TypeMirror>();
        if (value instanceof List) {
            for (Object type : (List)value) {
                AnnotationValue annotationValue = (AnnotationValue)type;
                if (!((type = annotationValue.getValue()) instanceof TypeMirror)) continue;
                result.add((TypeMirror)type);
            }
        }
        return result;
    }

    void init(TypeElement element, WebBeansModelImplementation modelImpl) {
        this.myImpl = modelImpl;
        this.myElement = element;
    }

    private WebBeansModelImplementation getImplementation() {
        return this.myImpl;
    }

    private TypeElement getElement() {
        return this.myElement;
    }
}

