/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.ui.history;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.swing.Action;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.ui.history.History;
import org.netbeans.modules.versioning.ui.history.HistoryEntry;
import org.netbeans.modules.versioning.ui.history.TableEntry;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

class RevisionNode
extends AbstractNode
implements Comparable {
    static final String PROPERTY_NAME_LABEL = "label";
    static final String PROPERTY_NAME_USER = "user";
    static final String PROPERTY_NAME_VERSION = "version";
    private HistoryEntry entry;
    private static DateFormat dateFormat = DateFormat.getDateTimeInstance();
    private static DateFormat timeFormat = DateFormat.getTimeInstance();

    private RevisionNode(HistoryEntry entry, Lookup l) {
        super(RevisionNode.createChildren(entry), l);
        this.entry = entry;
        this.initProperties();
    }

    static RevisionNode create(HistoryEntry entry) {
        VCSFileProxy[] proxies;
        LinkedList<Object> lookup = new LinkedList<Object>();
        for (VCSFileProxy proxy : proxies = entry.getFiles()) {
            lookup.add(proxy);
            File f = proxy.toFile();
            if (f == null) continue;
            lookup.add(f);
        }
        lookup.addAll(Arrays.asList(entry.getLookupObjects()));
        lookup.add(entry);
        return new RevisionNode(entry, Lookups.fixed((Object[])lookup.toArray(new Object[lookup.size()])));
    }

    private static Children createChildren(HistoryEntry entry) {
        if (entry.getFiles().length == 1) {
            return Children.LEAF;
        }
        FileNode[] nodes = new FileNode[entry.getFiles().length];
        int i = 0;
        for (VCSFileProxy file : entry.getFiles()) {
            nodes[i++] = new FileNode(entry, file);
        }
        Children.SortedArray children = new Children.SortedArray();
        children.add((Node[])nodes);
        return children;
    }

    private void initProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = Sheet.createPropertiesSet();
        ps.put((Node.Property)new RevisionProperty());
        ps.put((Node.Property)new UserProperty());
        ps.put((Node.Property)(this.entry.canEdit() ? new EditableMessageProperty() : new MessageProperty()));
        sheet.put(ps);
        this.setSheet(sheet);
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getName() {
        return RevisionNode.getFormatedDate(this.entry);
    }

    public String toString() {
        return this.getName();
    }

    static String getFormatedDate(HistoryEntry se) {
        int day = RevisionNode.getDay(se.getDateTime().getTime());
        switch (day) {
            case 0: {
                return NbBundle.getMessage(RevisionNode.class, (String)"LBL_Today", (Object[])new Object[]{timeFormat.format(se.getDateTime())});
            }
            case 1: {
                return NbBundle.getMessage(RevisionNode.class, (String)"LBL_Yesterday", (Object[])new Object[]{timeFormat.format(se.getDateTime())});
            }
        }
        return dateFormat.format(se.getDateTime());
    }

    private static int getDay(long ts) {
        Date date = new Date(ts);
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        int todayMillis = c.get(11) * 60 * 60 * 1000 + c.get(12) * 60 * 1000 + c.get(13) * 1000 + c.get(14);
        c.add(14, -1 * todayMillis);
        if (c.getTime().compareTo(date) < 0) {
            return 0;
        }
        return (int)((c.getTimeInMillis() - ts) / 86400000L) + 1;
    }

    public Action[] getActions(boolean context) {
        return this.entry.getActions();
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof RevisionNode) || obj == null) {
            return -1;
        }
        RevisionNode node = (RevisionNode)obj;
        return this.entry.getDateTime().compareTo(node.entry.getDateTime());
    }

    static class FileNode
    extends AbstractNode
    implements Comparable {
        private final HistoryEntry entry;
        private final VCSFileProxy file;

        FileNode(HistoryEntry entry, VCSFileProxy file) {
            super(Children.LEAF, FileNode.createLookup(file, entry));
            this.entry = entry;
            this.file = file;
        }

        private static Lookup createLookup(VCSFileProxy proxy, HistoryEntry entry) {
            LinkedList<Object> lookup = new LinkedList<Object>();
            lookup.add(proxy);
            File f = proxy.toFile();
            if (f != null) {
                lookup.add(f);
            }
            lookup.add(entry);
            lookup.addAll(Arrays.asList(entry.getLookupObjects()));
            return Lookups.fixed((Object[])lookup.toArray(new Object[lookup.size()]));
        }

        public Action[] getActions(boolean context) {
            return this.entry.getActions();
        }

        public String getName() {
            return this.file.getName();
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof FileNode) || obj == null) {
                return -1;
            }
            FileNode node = (FileNode)obj;
            return this.getName().compareTo(node.getName());
        }
    }

    class RevisionProperty
    extends PropertySupport.ReadOnly<TableEntry> {
        private final TableEntry te;

        public RevisionProperty() {
            super(RevisionNode.PROPERTY_NAME_VERSION, TableEntry.class, NbBundle.getMessage(RevisionNode.class, (String)"LBL_VersionProperty_Name"), NbBundle.getMessage(RevisionNode.class, (String)"LBL_VersionProperty_Desc"));
            this.te = new RevisionEntry(RevisionNode.this.entry);
        }

        public TableEntry getValue() throws IllegalAccessException, InvocationTargetException {
            return this.te;
        }

        public String toString() {
            return RevisionNode.this.entry.getRevision();
        }

        private class RevisionEntry
        extends TableEntry {
            private final HistoryEntry entry;

            private RevisionEntry(HistoryEntry entry) {
                this.entry = entry;
            }

            @Override
            public String getDisplayValue() {
                return this.entry.getRevisionShort();
            }

            @Override
            public String getTooltip() {
                return this.entry.getRevision();
            }

            @Override
            public int compareTo(TableEntry e) {
                if (e == null) {
                    return 1;
                }
                try {
                    Integer i1 = Integer.parseInt(this.getDisplayValue());
                    Integer i2 = Integer.parseInt(e.getDisplayValue());
                    return i1.compareTo(i2);
                }
                catch (NumberFormatException numberFormatException) {
                    return super.compareTo(e);
                }
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                String r1 = this.entry.getRevisionShort();
                String r2 = ((RevisionEntry)obj).entry.getRevisionShort();
                return r1 != null && r1.equals(r2);
            }

            public int hashCode() {
                int hash = 7;
                hash = 71 * hash + (this.entry.getRevisionShort() != null ? this.entry.getRevisionShort().hashCode() : 0);
                return hash;
            }
        }
    }

    class UserProperty
    extends PropertySupport.ReadOnly<TableEntry> {
        private TableEntry te;

        public UserProperty() {
            super(RevisionNode.PROPERTY_NAME_USER, TableEntry.class, NbBundle.getMessage(RevisionNode.class, (String)"LBL_UserProperty_Name"), NbBundle.getMessage(RevisionNode.class, (String)"LBL_UserProperty_Desc"));
            this.te = new UserEntry(RevisionNode.this.entry);
        }

        public TableEntry getValue() throws IllegalAccessException, InvocationTargetException {
            return this.te;
        }

        public String toString() {
            return RevisionNode.this.entry.getUsername();
        }

        private class UserEntry
        extends TableEntry {
            private final HistoryEntry entry;

            public UserEntry(HistoryEntry entry) {
                this.entry = entry;
            }

            @Override
            public String getDisplayValue() {
                return this.entry.getUsernameShort();
            }

            @Override
            public String getTooltip() {
                return this.entry.getUsername();
            }

            public int hashCode() {
                int hash = 7;
                hash = 47 * hash + (this.entry.getUsernameShort() != null ? this.entry.getUsernameShort().hashCode() : 0);
                return hash;
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                UserEntry other = (UserEntry)obj;
                String un1 = this.entry.getUsernameShort();
                String un2 = other.entry.getUsernameShort();
                return un1 != null && un1.equals(un2);
            }
        }
    }

    class EditableMessageProperty
    extends PropertySupport.ReadWrite<TableEntry> {
        private TableEntry te;

        public EditableMessageProperty() {
            super(RevisionNode.PROPERTY_NAME_LABEL, TableEntry.class, NbBundle.getMessage(RevisionNode.class, (String)"LBL_LabelProperty_Name"), NbBundle.getMessage(RevisionNode.class, (String)"LBL_LabelProperty_Desc"));
            this.te = new MsgEntry(RevisionNode.this.entry);
        }

        public TableEntry getValue() throws IllegalAccessException, InvocationTargetException {
            return this.te;
        }

        public void setValue(TableEntry te) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.te = te;
        }

        public PropertyEditor getPropertyEditor() {
            return new PropertyEditorSupport(){

                @Override
                public void setAsText(String text) throws IllegalArgumentException {
                    if (text instanceof String) {
                        try {
                            RevisionNode.this.entry.setMessage(!text.equals("") ? text : null);
                        }
                        catch (IOException ex) {
                            History.LOG.log(Level.WARNING, null, ex);
                        }
                        return;
                    }
                    throw new IllegalArgumentException(text);
                }

                @Override
                public String getAsText() {
                    return EditableMessageProperty.this.te.getDisplayValue();
                }
            };
        }

        public String toString() {
            return RevisionNode.this.entry.getMessage();
        }

        private class MsgEntry
        extends TableEntry {
            private final HistoryEntry entry;

            public MsgEntry(HistoryEntry entry) {
                this.entry = entry;
            }

            @Override
            public String getDisplayValue() {
                return this.entry.getMessage();
            }

            @Override
            public String getTooltip() {
                String tooltip = this.entry.getMessage();
                if (tooltip == null || "".equals(tooltip.trim())) {
                    tooltip = NbBundle.getMessage(RevisionNode.class, (String)"LBL_SetTooltip");
                }
                return tooltip;
            }

            @Override
            public String toString() {
                return this.entry.getMessage();
            }

            public int hashCode() {
                int hash = 7;
                hash = 11 * hash + (this.entry.getMessage() != null ? this.entry.getMessage().hashCode() : 0);
                return hash;
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                MsgEntry other = (MsgEntry)obj;
                String msg1 = this.entry.getMessage();
                String msg2 = other.entry.getMessage();
                return msg1 != null && msg1.equals(msg2);
            }
        }
    }

    class MessageProperty
    extends PropertySupport.ReadOnly<TableEntry> {
        private TableEntry te;

        public MessageProperty() {
            super(RevisionNode.PROPERTY_NAME_LABEL, TableEntry.class, NbBundle.getMessage(RevisionNode.class, (String)"LBL_LabelProperty_Name"), NbBundle.getMessage(RevisionNode.class, (String)"LBL_LabelProperty_Desc"));
            this.te = new TableEntry(){

                @Override
                public String getDisplayValue() {
                    return RevisionNode.this.entry.getMessage();
                }

                @Override
                public String getTooltip() {
                    return RevisionNode.this.entry.getMessage();
                }
            };
        }

        public TableEntry getValue() throws IllegalAccessException, InvocationTargetException {
            return this.te;
        }

        public String toString() {
            return RevisionNode.this.entry.getMessage();
        }
    }
}

