/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.ui.nodes;

import java.awt.Image;
import java.util.LinkedList;
import javax.swing.Action;
import org.netbeans.modules.j2ee.deployment.plugins.api.UISupport;
import org.netbeans.modules.tomcat5.deploy.TomcatManager;
import org.netbeans.modules.tomcat5.ui.nodes.TomcatWebModule;
import org.netbeans.modules.tomcat5.ui.nodes.actions.ContextLogAction;
import org.netbeans.modules.tomcat5.ui.nodes.actions.OpenURLAction;
import org.netbeans.modules.tomcat5.ui.nodes.actions.StartAction;
import org.netbeans.modules.tomcat5.ui.nodes.actions.StopAction;
import org.netbeans.modules.tomcat5.ui.nodes.actions.UndeployAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class TomcatWebModuleNode
extends AbstractNode {
    private TomcatWebModule module;

    public TomcatWebModuleNode(TomcatWebModule module) {
        super(Children.LEAF);
        this.module = module;
        this.setDisplayName(this.constructName());
        this.setShortDescription(module.getTomcatModule().getWebURL());
        this.getCookieSet().add((Node.Cookie)module);
    }

    public Action[] getActions(boolean context) {
        TomcatManager tm = (TomcatManager)this.module.getDeploymentManager();
        LinkedList<SystemAction> actions = new LinkedList<SystemAction>();
        actions.add(SystemAction.get(StartAction.class));
        actions.add(SystemAction.get(StopAction.class));
        actions.add(null);
        actions.add(SystemAction.get(OpenURLAction.class));
        if (tm != null && tm.isTomcat50()) {
            actions.add(SystemAction.get(ContextLogAction.class));
        }
        actions.add(null);
        actions.add(SystemAction.get(UndeployAction.class));
        return actions.toArray(new SystemAction[actions.size()]);
    }

    public Image getIcon(int type) {
        return UISupport.getIcon((UISupport.ServerIcon)UISupport.ServerIcon.WAR_ARCHIVE);
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    private String constructName() {
        if (this.module.isRunning()) {
            return this.module.getTomcatModule().getPath();
        }
        return this.module.getTomcatModule().getPath() + " [" + NbBundle.getMessage(TomcatWebModuleNode.class, (String)"LBL_Stopped") + "]";
    }
}

