/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.actions.Savable;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.gsf.testrunner.plugin.CommonPlugin;
import org.netbeans.modules.testng.Bundle;
import org.netbeans.modules.testng.ProgressIndicator;
import org.netbeans.modules.testng.TestCreator;
import org.netbeans.modules.testng.TestNGPlugin;
import org.netbeans.modules.testng.TestNGSettings;
import org.netbeans.modules.testng.TestUtil;
import org.netbeans.modules.testng.TestabilityResult;
import org.netbeans.modules.testng.TopClassFinder;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Mutex;

public final class DefaultPlugin
extends TestNGPlugin {
    private static final String templatePropBeforeClass = "classSetUp";
    private static final String templatePropAfterClass = "classTearDown";
    private static final String templatePropBefore = "methodSetUp";
    private static final String templatePropAfter = "methodTearDown";
    private static final String templatePropCodeHints = "sourceCodeHint";
    private static final String templatePropMethodPH = "testMethodsPlaceholder";
    private static final String templatePropUseAnnotations = "useAnnotations";
    private static final String templatePropClassNames = "classNames";
    private static final String templatePropClasses = "classes";
    private static final String NGPrefix = "NG";

    protected boolean canCreateTests(FileObject ... fileObjects) {
        if (fileObjects.length == 0) {
            return false;
        }
        FileObject firstFile = fileObjects[0];
        SourceGroup sourceGroup = DefaultPlugin.findSourceGroup(firstFile);
        if (sourceGroup == null) {
            return false;
        }
        FileObject rootFolder = sourceGroup.getRootFolder();
        if (UnitTestForSourceQuery.findUnitTests((FileObject)rootFolder).length == 0) {
            return false;
        }
        if (fileObjects.length == 1) {
            return true;
        }
        for (int i = 1; i < fileObjects.length; ++i) {
            FileObject fileObj = fileObjects[i];
            if (FileUtil.isParentOf((FileObject)rootFolder, (FileObject)fileObj) && sourceGroup.contains(fileObj)) continue;
            return false;
        }
        return true;
    }

    private static SourceGroup findSourceGroup(FileObject file) {
        SourceGroup[] srcGrps;
        Project project = FileOwnerQuery.getOwner((FileObject)file);
        if (project == null) {
            return null;
        }
        Sources src = ProjectUtils.getSources((Project)project);
        for (SourceGroup srcGrp : srcGrps = src.getSourceGroups("java")) {
            FileObject rootFolder = srcGrp.getRootFolder();
            if (file != rootFolder && !FileUtil.isParentOf((FileObject)rootFolder, (FileObject)file) || !srcGrp.contains(file)) continue;
            return srcGrp;
        }
        return null;
    }

    protected CommonPlugin.Location getTestLocation(CommonPlugin.Location sourceLocation) {
        String testResName;
        FileObject fileObj = sourceLocation.getFileObject();
        ClassPath srcCp = ClassPath.getClassPath((FileObject)fileObj, (String)"classpath/source");
        if (srcCp == null) {
            return null;
        }
        String baseResName = srcCp.getResourceName(fileObj, '/', false);
        if (baseResName == null) {
            return null;
        }
        String string = testResName = !fileObj.isFolder() ? DefaultPlugin.getTestResName(baseResName, fileObj.getExt()) : DefaultPlugin.getSuiteResName(baseResName);
        assert (testResName != null);
        return DefaultPlugin.getOppositeLocation(sourceLocation, srcCp, testResName, true);
    }

    protected CommonPlugin.Location getTestedLocation(CommonPlugin.Location testLocation) {
        ClassPath srcCp;
        FileObject fileObj = testLocation.getFileObject();
        if (fileObj.isFolder() || (srcCp = ClassPath.getClassPath((FileObject)fileObj, (String)"classpath/source")) == null) {
            return null;
        }
        String baseResName = srcCp.getResourceName(fileObj, '/', false);
        if (baseResName == null) {
            return null;
        }
        String srcResName = DefaultPlugin.getSrcResName(baseResName, fileObj.getExt());
        if (srcResName == null) {
            return null;
        }
        return DefaultPlugin.getOppositeLocation(testLocation, srcCp, srcResName, false);
    }

    private static CommonPlugin.Location getOppositeLocation(CommonPlugin.Location sourceLocation, ClassPath fileObjCp, String oppoResourceName, boolean sourceToTest) {
        URL[] oppoRootsURLs;
        FileObject fileObj = sourceLocation.getFileObject();
        FileObject fileObjRoot = fileObjCp.findOwnerRoot(fileObj);
        if (fileObjRoot == null) {
            return null;
        }
        URL[] uRLArray = oppoRootsURLs = sourceToTest ? UnitTestForSourceQuery.findUnitTests((FileObject)fileObjRoot) : UnitTestForSourceQuery.findSources((FileObject)fileObjRoot);
        if (oppoRootsURLs == null || oppoRootsURLs.length == 0) {
            return null;
        }
        ClassPath oppoRootsClassPath = ClassPathSupport.createClassPath((URL[])oppoRootsURLs);
        List oppoFiles = oppoRootsClassPath.findAllResources(oppoResourceName);
        if (oppoFiles.isEmpty()) {
            return null;
        }
        return new CommonPlugin.Location((FileObject)oppoFiles.get(0));
    }

    private static String getTestResName(String baseResName, String ext) {
        StringBuilder buf = new StringBuilder(baseResName.length() + ext.length() + 10);
        buf.append(baseResName).append("NGTest");
        if (ext.length() != 0) {
            buf.append('.').append(ext);
        }
        return buf.toString();
    }

    private static String getSuiteResName(String baseResName) {
        if (baseResName.length() == 0) {
            return TestNGSettings.getDefault().getRootSuiteClassName();
        }
        String suiteSuffix = "Suite";
        String lastNamePart = baseResName.substring(baseResName.lastIndexOf(47) + 1);
        StringBuilder buf = new StringBuilder(baseResName.length() + lastNamePart.length() + "Suite".length() + 6);
        buf.append(baseResName).append('/');
        buf.append(Character.toUpperCase(lastNamePart.charAt(0))).append(lastNamePart.substring(1));
        buf.append("Suite");
        buf.append(".java");
        return buf.toString();
    }

    private static String getSrcResName(String testResName, String ext) {
        if (!testResName.endsWith("NGTest")) {
            return null;
        }
        StringBuilder buf = new StringBuilder(testResName.length() + ext.length());
        buf.append(testResName.substring(0, testResName.length() - 6));
        if (ext.length() != 0) {
            buf.append('.').append(ext);
        }
        return buf.toString();
    }

    private static String getTestClassName(String baseClassName) {
        return baseClassName + NGPrefix + "Test";
    }

    private static String getSourceClassName(String testClassName) {
        String suffix = "Test";
        int suffixLen = "Test".length();
        return testClassName.length() > suffixLen && testClassName.endsWith("Test") ? testClassName.substring(0, testClassName.length() - suffixLen) : null;
    }

    private static String getTestMethodName(String baseMethodName) {
        String prefix = "test";
        int prefixLen = "test".length();
        StringBuffer buf = new StringBuffer(prefixLen + baseMethodName.length());
        buf.append("test").append(baseMethodName);
        buf.setCharAt(prefixLen, Character.toUpperCase(baseMethodName.charAt(0)));
        return buf.toString();
    }

    private static String getSourceMethodName(String testMethodName) {
        String prefix = "test";
        int prefixLen = "test".length();
        return testMethodName.length() > prefixLen && testMethodName.startsWith("test") ? new StringBuilder(testMethodName.length() - prefixLen).append(Character.toLowerCase(testMethodName.charAt(prefixLen))).append(testMethodName.substring(prefixLen + 1)).toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject[] createTests(FileObject[] filesToTest, FileObject targetRoot, Map<CommonPlugin.CreateTestParam, Object> params) {
        FileObject[] createdFiles;
        CreationResults results;
        ProgressIndicator progress = new ProgressIndicator();
        progress.show();
        String msg = Bundle.MSG_StatusBar_CreateTest_Begin();
        progress.displayStatusText(msg);
        TestCreator testCreator = new TestCreator(params);
        try {
            DataObject doSuiteTempl;
            DataObject doTestTempl;
            boolean forTestSuite = filesToTest != null && filesToTest.length != 0 && (filesToTest.length > 1 || !filesToTest[0].isData());
            String templateId = Bundle.PROP_testng_testClassTemplate();
            String suiteTemplateId = forTestSuite ? Bundle.PROP_testng_testSuiteTemplate() : null;
            DataObject dataObject = doTestTempl = templateId != null ? DefaultPlugin.loadTestTemplate(templateId) : null;
            if (doTestTempl == null) {
                FileObject[] fileObjectArray = null;
                return fileObjectArray;
            }
            DataObject dataObject2 = doSuiteTempl = suiteTemplateId != null ? DefaultPlugin.loadTestTemplate(suiteTemplateId) : null;
            if (forTestSuite && doSuiteTempl == null) {
                FileObject[] fileObjectArray = null;
                return fileObjectArray;
            }
            Map<String, Boolean> templateParams = DefaultPlugin.createTemplateParams(params);
            DefaultPlugin.setAnnotationsSupport(targetRoot, templateParams);
            if (filesToTest == null || filesToTest.length == 0) {
                DefaultPlugin.addTemplateParamEntry(params, CommonPlugin.CreateTestParam.INC_CODE_HINT, templateParams, templatePropMethodPH);
                String testClassName = (String)params.get(CommonPlugin.CreateTestParam.CLASS_NAME);
                assert (testClassName != null);
                results = new CreationResults(1);
                DataObject testDataObj = this.createEmptyTest(targetRoot, testClassName, testCreator, templateParams, doTestTempl);
                if (testDataObj != null) {
                    results.addCreated(testDataObj);
                }
            } else {
                ClassPath testClassPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{targetRoot});
                if (!forTestSuite) {
                    String testClassName = (String)params.get(CommonPlugin.CreateTestParam.CLASS_NAME);
                    if (testClassName == null) {
                        String srcClassName = ClassPath.getClassPath((FileObject)filesToTest[0], (String)"classpath/source").getResourceName(filesToTest[0], '.', false);
                        testClassName = DefaultPlugin.getTestClassName(srcClassName);
                    }
                    try {
                        results = DefaultPlugin.createSingleTest(filesToTest[0], testClassName, testCreator, templateParams, doTestTempl, testClassPath, TestabilityResult.NO_TESTEABLE_METHODS.getReasonValue(), null, progress);
                    }
                    catch (CreationError ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                        results = new CreationResults(1);
                    }
                } else {
                    results = new CreationResults();
                    for (FileObject fileToTest : filesToTest) {
                        try {
                            results.combine(DefaultPlugin.createTests(fileToTest, testCreator, templateParams, doTestTempl, doSuiteTempl, testClassPath, null, progress));
                        }
                        catch (CreationError e) {
                            ErrorManager.getDefault().notify((Throwable)e);
                        }
                    }
                }
            }
        }
        finally {
            progress.hide();
        }
        Set<TestabilityResult.SkippedClass> skipped = results.getSkipped();
        Set<DataObject> created = results.getCreated();
        if (!skipped.isEmpty()) {
            String message;
            if (skipped.size() == 1) {
                TestabilityResult.SkippedClass skippedClass = skipped.iterator().next();
                message = Bundle.MSG_skipped_class(skippedClass.clsName, DefaultPlugin.strReason(skippedClass.reason, "COMMA", "AND"));
            } else {
                TestabilityResult reason = TestabilityResult.OK;
                for (TestabilityResult.SkippedClass sc : skipped) {
                    reason = TestabilityResult.combine(reason, sc.reason);
                }
                message = Bundle.MSG_skipped_classes(DefaultPlugin.strReason(reason, "COMMA", "OR"));
            }
            TestUtil.notifyUser(message, 1);
        }
        if (created.isEmpty()) {
            Mutex.EVENT.writeAccess(new Runnable(){

                @Override
                public void run() {
                    TestUtil.notifyUser(Bundle.MSG_No_test_created(), 1);
                }
            });
        }
        if (created.isEmpty()) {
            createdFiles = new FileObject[]{};
        } else {
            createdFiles = new FileObject[created.size()];
            int i = 0;
            for (DataObject dObj : created) {
                createdFiles[i++] = dObj.getPrimaryFile();
            }
        }
        return createdFiles;
    }

    public static final Map<String, Boolean> createTemplateParams(Map<CommonPlugin.CreateTestParam, Object> params) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(7);
        DefaultPlugin.addTemplateParamEntry(params, CommonPlugin.CreateTestParam.INC_CLASS_SETUP, result, templatePropBeforeClass);
        DefaultPlugin.addTemplateParamEntry(params, CommonPlugin.CreateTestParam.INC_CLASS_TEAR_DOWN, result, templatePropAfterClass);
        DefaultPlugin.addTemplateParamEntry(params, CommonPlugin.CreateTestParam.INC_SETUP, result, templatePropBefore);
        DefaultPlugin.addTemplateParamEntry(params, CommonPlugin.CreateTestParam.INC_TEAR_DOWN, result, templatePropAfter);
        DefaultPlugin.addTemplateParamEntry(params, CommonPlugin.CreateTestParam.INC_CODE_HINT, result, templatePropCodeHints);
        return result;
    }

    private static void addTemplateParamEntry(Map<CommonPlugin.CreateTestParam, Object> srcParams, CommonPlugin.CreateTestParam srcParamKey, Map<String, Boolean> templParams, String templParamKey) {
        Object value = srcParams.get(srcParamKey);
        if (value instanceof Boolean) {
            templParams.put(templParamKey, (Boolean)Boolean.class.cast(value));
        }
    }

    private DataObject createEmptyTest(FileObject targetRoot, String testClassName, TestCreator testCreator, Map<String, ? extends Object> templateParams, DataObject templateDataObj) {
        if (testClassName == null) {
            throw new IllegalArgumentException("testClassName = null");
        }
        DataObject testDataObj = null;
        try {
            DataFolder targetFolderDataObj = DataFolder.findFolder((FileObject)targetRoot);
            testDataObj = templateDataObj.createFromTemplate(targetFolderDataObj, testClassName, templateParams);
            testCreator.createEmptyTest(testDataObj.getPrimaryFile());
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        return testDataObj;
    }

    private static CreationResults createSingleTest(FileObject sourceFile, String requestedTestClassName, TestCreator testCreator, Map<String, ? extends Object> templateParams, DataObject templateDataObj, ClassPath testClassPath, long skipTestabilityResultMask, List<String> parentSuite, ProgressIndicator progress) throws CreationError {
        List<ElementHandle<TypeElement>> testable;
        List<TestabilityResult.SkippedClass> nonTestable;
        try {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)sourceFile);
            if (javaSource == null) {
                return CreationResults.EMPTY;
            }
            if (skipTestabilityResultMask != 0L) {
                nonTestable = new ArrayList();
                testable = TopClassFinder.findTestableTopClasses(javaSource, testCreator, nonTestable, skipTestabilityResultMask);
            } else {
                nonTestable = Collections.emptyList();
                testable = TopClassFinder.findTopClasses(javaSource);
            }
        }
        catch (IOException ex) {
            throw new CreationError(ex);
        }
        CreationResults result = new CreationResults(4);
        if (!nonTestable.isEmpty()) {
            result.addSkipped(nonTestable);
        }
        if (!testable.isEmpty()) {
            boolean mainClassProcessed = false;
            try {
                for (ElementHandle<TypeElement> clsToTest : testable) {
                    boolean isNew;
                    String testClassName;
                    String srcClassNameFull = clsToTest.getQualifiedName();
                    if (requestedTestClassName != null && !mainClassProcessed && TestUtil.getSimpleName(srcClassNameFull).equals(sourceFile.getName())) {
                        testClassName = requestedTestClassName;
                        mainClassProcessed = true;
                    } else {
                        testClassName = TestUtil.getTestClassName(srcClassNameFull.concat(NGPrefix));
                    }
                    String testResourceName = testClassName.replace('.', '/');
                    DataObject testDataObj = null;
                    FileObject testFile = testClassPath.findResource(testResourceName + ".java");
                    boolean bl = isNew = testFile == null;
                    if (testFile == null) {
                        testDataObj = DefaultPlugin.createTestClass(testClassPath, testResourceName, templateDataObj, templateParams);
                        testFile = testDataObj.getPrimaryFile();
                    }
                    testCreator.createSimpleTest(clsToTest, testFile, isNew);
                    if (testDataObj == null) {
                        testDataObj = DataObject.find((FileObject)testFile);
                    }
                    DefaultPlugin.save(testDataObj);
                    result.addCreated(testDataObj);
                    if (parentSuite == null) continue;
                    parentSuite.add(testClassName);
                }
            }
            catch (IOException ex) {
                throw new CreationError(ex);
            }
        }
        return result;
    }

    private static CreationResults createTests(FileObject srcFileObj, TestCreator testCreator, Map<String, ? extends Object> templateParams, DataObject doTestT, DataObject doSuiteT, ClassPath testClassPath, List<String> parentSuite, ProgressIndicator progress) throws CreationError {
        CreationResults results;
        if (srcFileObj.isFolder()) {
            results = new CreationResults();
            LinkedList<String> mySuite = new LinkedList<String>();
            progress.setMessage(DefaultPlugin.getScanningMsg(srcFileObj.getName()));
            for (FileObject childFileObj : srcFileObj.getChildren()) {
                if (progress.isCanceled()) {
                    results.setAbborted();
                    break;
                }
                if (!VisibilityQuery.getDefault().isVisible(childFileObj)) continue;
                results.combine(DefaultPlugin.createTests(childFileObj, testCreator, templateParams, doTestT, doSuiteT, testClassPath, mySuite, progress));
                if (results.isAbborted()) break;
            }
            if (!results.isAbborted() && TestNGSettings.getDefault().isGenerateSuiteClasses()) {
                DefaultPlugin.createSuiteTest(srcFileObj, null, testCreator, templateParams, doSuiteT, testClassPath, mySuite, parentSuite, progress);
            }
        } else {
            results = srcFileObj.isData() && TestUtil.isJavaFile((FileObject)srcFileObj) ? DefaultPlugin.createSingleTest(srcFileObj, null, testCreator, templateParams, doTestT, testClassPath, TestabilityResult.NO_TESTEABLE_METHODS.getReasonValue(), parentSuite, progress) : CreationResults.EMPTY;
        }
        return results;
    }

    private static DataObject createSuiteTest(FileObject folder, String suiteName, TestCreator testCreator, Map<String, ? extends Object> templateParams, DataObject templateDataObj, ClassPath testClassPath, List<String> classesToInclude, List<String> parentSuite, ProgressIndicator progress) throws CreationError {
        ClassPath cp = ClassPath.getClassPath((FileObject)folder, (String)"classpath/source");
        assert (cp != null) : "SOURCE classpath was not found for " + folder;
        if (cp == null) {
            return null;
        }
        String pkg = cp.getResourceName(folder, '/', false);
        if (pkg.length() > 0) {
            FileObject rootOwnerFO;
            String rootFolderName = "";
            if (cp.getRoots().length > 1 && (rootOwnerFO = cp.findOwnerRoot(folder)) != null) {
                rootFolderName = rootOwnerFO.getName() + '/';
            }
            String dotPkg = pkg.replace('/', '.');
            String fullSuiteName = rootFolderName.concat(suiteName != null ? pkg + '/' + suiteName : TestUtil.convertPackage2SuiteName(pkg));
            HashMap<String, ? extends Object> suiteTemplParams = new HashMap<String, Object>(templateParams);
            String projectName = ProjectUtils.getInformation((Project)FileOwnerQuery.getOwner((FileObject)folder)).getName();
            suiteTemplParams.put("suiteName", projectName);
            suiteTemplParams.put("testName", dotPkg.concat(" suite"));
            suiteTemplParams.put("pkg", dotPkg);
            try {
                boolean isNew;
                DataObject testDataObj = null;
                FileObject testFile = testClassPath.findResource(fullSuiteName + ".xml");
                boolean bl = isNew = testFile == null;
                if (testFile == null) {
                    testDataObj = DefaultPlugin.createTestClass(testClassPath, fullSuiteName, templateDataObj, suiteTemplParams);
                    testFile = testDataObj.getPrimaryFile();
                }
                try {
                    if (testDataObj == null) {
                        testDataObj = DataObject.find((FileObject)testFile);
                    }
                    DefaultPlugin.save(testDataObj);
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(65536, (Throwable)ex);
                    return null;
                }
                return testDataObj;
            }
            catch (IOException ioe) {
                throw new CreationError(ioe);
            }
        }
        return null;
    }

    public DataObject createSuiteTest(FileObject targetRootFolder, FileObject targetFolder, String suiteName, Map<CommonPlugin.CreateTestParam, Object> params) {
        Map<String, Boolean> templateParams = DefaultPlugin.createTemplateParams(params);
        DefaultPlugin.setAnnotationsSupport(targetFolder, templateParams);
        TestCreator testCreator = new TestCreator(params);
        ClasspathInfo cpInfo = ClasspathInfo.create((FileObject)targetRootFolder);
        List<String> testClassNames = TestUtil.getJavaFileNames(targetFolder, cpInfo);
        String templateId = Bundle.PROP_testng_testSuiteTemplate();
        DataObject doSuiteTempl = DefaultPlugin.loadTestTemplate(templateId);
        if (doSuiteTempl == null) {
            return null;
        }
        try {
            return DefaultPlugin.createSuiteTest(targetFolder, suiteName, testCreator, templateParams, doSuiteTempl, cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE), new LinkedList<String>(testClassNames), null, null);
        }
        catch (CreationError ex) {
            return null;
        }
    }

    private static DataObject createTestClass(ClassPath cp, String testClassName, DataObject templateDataObj, Map<String, ? extends Object> templateParams) throws DataObjectNotFoundException, IOException {
        String clazz;
        int index;
        FileObject root = cp.getRoots()[0];
        String rootFolderName = "";
        if (cp.getRoots().length > 1) {
            int indexFirst = testClassName.indexOf(47);
            int indexLast = testClassName.lastIndexOf(47);
            assert (indexFirst != indexLast) : "ClassPath=" + cp + "\ntestClassName=" + testClassName;
            rootFolderName = testClassName.substring(0, indexFirst);
            testClassName = testClassName.substring(indexLast + 1);
            for (int i = 0; i < cp.getRoots().length; ++i) {
                FileObject rootFO = cp.getRoots()[i];
                if (!rootFO.getPath().endsWith(rootFolderName)) continue;
                root = rootFO;
            }
        }
        String pkg = (index = testClassName.lastIndexOf(47)) > -1 ? testClassName.substring(0, index) : "";
        String string = clazz = index > -1 ? testClassName.substring(index + 1) : testClassName;
        if (pkg.length() > 0) {
            root = FileUtil.createFolder((FileObject)root, (String)pkg);
        }
        return templateDataObj.createFromTemplate(DataFolder.findFolder((FileObject)root), clazz, templateParams);
    }

    private static boolean setAnnotationsSupport(FileObject testFolder, Map<String, Boolean> templateParams) {
        if (!testFolder.isFolder()) {
            throw new IllegalArgumentException("not a folder");
        }
        templateParams.put(templatePropUseAnnotations, true);
        return true;
    }

    private static void save(DataObject dataObj) throws IOException {
        Savable sc = (Savable)dataObj.getLookup().lookup(Savable.class);
        if (null != sc) {
            sc.save();
        }
    }

    private static DataObject loadTestTemplate(String templateID) {
        String path = templateID;
        try {
            FileObject fo = FileUtil.getConfigFile((String)path);
            if (fo == null) {
                DefaultPlugin.noTemplateMessage(path);
                return null;
            }
            return DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException e) {
            DefaultPlugin.noTemplateMessage(path);
            return null;
        }
    }

    private static void noTemplateMessage(String temp) {
        String msg = Bundle.MSG_template_not_found(temp);
        NotifyDescriptor.Message descr = new NotifyDescriptor.Message((Object)msg, 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)descr);
    }

    private static String strReason(TestabilityResult reason, String commaKey, String andKey) {
        String strComma = Bundle.COMMA();
        String strAnd = andKey.equals("OR") ? Bundle.OR() : Bundle.AND();
        String strReason = reason.getReason(strComma, strAnd);
        return strReason;
    }

    private static String getCreatingMsg(String className) {
        return Bundle.FMT_generator_status_creating(className);
    }

    private static String getScanningMsg(String sourceName) {
        return Bundle.FMT_generator_status_scanning(sourceName);
    }

    private static String getIgnoringMsg(String sourceName, String reason) {
        return Bundle.FMT_generator_status_ignoring(sourceName);
    }

    static final class CreationResults {
        static final CreationResults EMPTY = new CreationResults();
        Set<DataObject> created;
        Set<TestabilityResult.SkippedClass> skipped;
        boolean abborted = false;

        CreationResults() {
            this(20);
        }

        CreationResults(int expectedSize) {
            this.created = new HashSet<DataObject>(expectedSize * 2, 0.5f);
            this.skipped = new HashSet<TestabilityResult.SkippedClass>(expectedSize * 2, 0.5f);
        }

        void setAbborted() {
            this.abborted = true;
        }

        boolean isAbborted() {
            return this.abborted;
        }

        boolean addCreated(DataObject test) {
            return this.created.add(test);
        }

        boolean addSkipped(TestabilityResult.SkippedClass skippedClass) {
            return this.skipped.add(skippedClass);
        }

        void addSkipped(Collection<TestabilityResult.SkippedClass> skippedClasses) {
            if (!skippedClasses.isEmpty()) {
                this.skipped.addAll(skippedClasses);
            }
        }

        Set<TestabilityResult.SkippedClass> getSkipped() {
            return this.skipped;
        }

        Set<DataObject> getCreated() {
            return this.created;
        }

        void combine(CreationResults rhs) {
            if (rhs.abborted) {
                this.abborted = true;
            }
            this.created.addAll(rhs.created);
            this.skipped.addAll(rhs.skipped);
        }
    }

    private static final class CreationError
    extends Exception {
        CreationError() {
        }

        CreationError(Throwable cause) {
            super(cause);
        }
    }
}

