/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClassMap {
    private static final int SETUP_POS_INDEX = 0;
    private static final int TEARDOWN_POS_INDEX = 1;
    private static final int FIRST_METHOD_POS_INDEX = 2;
    private static final int LAST_INIT_POS_INDEX = 3;
    private static final int FIRST_NESTED_POS_INDEX = 4;
    private static final int BEFORE_POS_INDEX = 5;
    private static final int AFTER_POS_INDEX = 6;
    private static final int BEFORE_CLASS_POS_INDEX = 7;
    private static final int AFTER_CLASS_POS_INDEX = 8;
    private static final String TESTNG_PKG_PREFIX = "org.testng.annotations.";
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private final List<String> signatures;
    private final int[] positions = new int[9];

    private ClassMap(List<String> signatures) {
        for (int i = 0; i < this.positions.length; ++i) {
            this.positions[i] = -1;
        }
        this.signatures = signatures;
    }

    static ClassMap forClass(ClassTree cls, TreePath clsTreePath, Trees trees) {
        if (cls == null) {
            throw new IllegalArgumentException("ClassTree: null");
        }
        if (clsTreePath == null) {
            throw new IllegalArgumentException("TreePath: null");
        }
        if (clsTreePath.getLeaf() != cls) {
            throw new IllegalArgumentException("given ClassTree is not leaf of the given TreePath");
        }
        List<? extends Tree> members = cls.getMembers();
        if (members.isEmpty()) {
            return new ClassMap(new ArrayList<String>());
        }
        ArrayList<String> entries = new ArrayList<String>(members.size());
        ClassMap map = new ClassMap(entries);
        int index = 0;
        for (Tree tree : members) {
            String signature;
            switch (tree.getKind()) {
                case BLOCK: {
                    signature = "* ";
                    map.setLastInitializerIndex(index);
                    break;
                }
                case VARIABLE: {
                    signature = "- ";
                    break;
                }
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    ClassTree clazz = (ClassTree)tree;
                    signature = "[ " + clazz.getSimpleName();
                    if (map.getFirstNestedClassIndex() != -1) break;
                    map.setFirstNestedClassIndex(index);
                    break;
                }
                case METHOD: {
                    MethodTree method = (MethodTree)tree;
                    boolean hasParams = !method.getParameters().isEmpty();
                    Name methodName = method.getName();
                    if (methodName.contentEquals("<init>")) {
                        signature = hasParams ? "*+" : "* ";
                        map.setLastInitializerIndex(index);
                        break;
                    }
                    if (!hasParams) {
                        if (map.getSetUpIndex() == -1 && methodName.contentEquals("setUp")) {
                            map.setSetUpIndex(index);
                        }
                        if (map.getTearDownIndex() == -1 && methodName.contentEquals("tearDown")) {
                            map.setTearDownIndex(index);
                        }
                    }
                    signature = (hasParams ? "!+" : "! ") + methodName.toString();
                    if (map.getFirstMethodIndex() == -1) {
                        map.setFirstMethodIndex(index);
                    }
                    if (method.getModifiers().getAnnotations().isEmpty()) break;
                    TreePath methodTreePath = new TreePath(clsTreePath, method);
                    Element methodElement = trees.getElement(methodTreePath);
                    for (AnnotationMirror annotationMirror : methodElement.getAnnotationMirrors()) {
                        int posIndex;
                        Element annElem = annotationMirror.getAnnotationType().asElement();
                        String fullName = ((TypeElement)annElem).getQualifiedName().toString();
                        if (!fullName.startsWith(TESTNG_PKG_PREFIX)) continue;
                        String shortName = fullName.substring(TESTNG_PKG_PREFIX.length());
                        if (shortName.equals("BeforeMethod")) {
                            posIndex = 5;
                        } else if (shortName.equals("AfterMethod")) {
                            posIndex = 6;
                        } else if (shortName.equals("BeforeClass")) {
                            posIndex = 7;
                        } else {
                            if (!shortName.equals("AfterClass")) continue;
                            posIndex = 8;
                        }
                        if (map.positions[posIndex] != -1) continue;
                        map.positions[posIndex] = index;
                    }
                    break;
                }
                default: {
                    signature = "x ";
                }
            }
            entries.add(signature);
            ++index;
        }
        return map;
    }

    int getSetUpIndex() {
        return this.positions[0];
    }

    private void setSetUpIndex(int setUpIndex) {
        this.positions[0] = setUpIndex;
    }

    int getTearDownIndex() {
        return this.positions[1];
    }

    private void setTearDownIndex(int tearDownIndex) {
        this.positions[1] = tearDownIndex;
    }

    int getBeforeIndex() {
        return this.positions[5];
    }

    private void setBeforeIndex(int index) {
        this.positions[5] = index;
    }

    int getAfterIndex() {
        return this.positions[6];
    }

    private void setAfterIndex(int index) {
        this.positions[6] = index;
    }

    int getBeforeClassIndex() {
        return this.positions[7];
    }

    private void setBeforeClassIndex(int index) {
        this.positions[7] = index;
    }

    int getAfterClassIndex() {
        return this.positions[8];
    }

    private void setAfterClassIndex(int index) {
        this.positions[8] = index;
    }

    int getFirstMethodIndex() {
        return this.positions[2];
    }

    private void setFirstMethodIndex(int firstMethodIndex) {
        this.positions[2] = firstMethodIndex;
    }

    int getFirstNestedClassIndex() {
        return this.positions[4];
    }

    private void setFirstNestedClassIndex(int firstNestedClassIndex) {
        this.positions[4] = firstNestedClassIndex;
    }

    int getLastInitializerIndex() {
        return this.positions[3];
    }

    private void setLastInitializerIndex(int lastInitializerIndex) {
        this.positions[3] = lastInitializerIndex;
    }

    boolean containsSetUp() {
        return this.getSetUpIndex() != -1;
    }

    boolean containsTearDown() {
        return this.getTearDownIndex() != -1;
    }

    boolean containsBefore() {
        return this.getBeforeIndex() != -1;
    }

    boolean containsAfter() {
        return this.getAfterIndex() != -1;
    }

    boolean containsBeforeClass() {
        return this.getBeforeClassIndex() != -1;
    }

    boolean containsAfterClass() {
        return this.getAfterClassIndex() != -1;
    }

    boolean containsNoArgMethod(String name) {
        return this.findNoArgMethod(name) != -1;
    }

    boolean containsMethods() {
        return this.getFirstMethodIndex() != -1;
    }

    boolean containsInitializers() {
        return this.getLastInitializerIndex() != -1;
    }

    boolean containsNestedClasses() {
        return this.getFirstNestedClassIndex() != -1;
    }

    int findNoArgMethod(String name) {
        if (!this.containsMethods()) {
            return -1;
        }
        if (name.equals("setUp")) {
            return this.getSetUpIndex();
        }
        if (name.equals("tearDown")) {
            return this.getTearDownIndex();
        }
        return this.signatures.indexOf("! " + name);
    }

    void addNoArgMethod(String name) {
        this.addNoArgMethod(name, this.size());
    }

    void addNoArgMethod(String name, int index) {
        int currSize = this.size();
        if (index > currSize) {
            throw new IndexOutOfBoundsException("index: " + index + ", size: " + currSize);
        }
        String signature = "! " + name;
        if (index != currSize) {
            this.signatures.add(index, signature);
            this.shiftPositions(index, 1);
        } else {
            this.signatures.add(signature);
        }
        if (name.equals("setUp")) {
            this.setSetUpIndex(index);
        } else if (name.equals("tearDown")) {
            this.setTearDownIndex(index);
        }
        if (this.getFirstMethodIndex() == -1) {
            this.setFirstMethodIndex(index);
        }
    }

    void addNoArgMethod(String name, String annotationName) {
        this.addNoArgMethod(name, annotationName, this.size());
    }

    void addNoArgMethod(String name, String annotationName, int index) {
        this.addNoArgMethod(name, index);
        if (annotationName.equals("org.testng.annotations.BeforeMethod")) {
            this.setBeforeIndex(index);
        } else if (annotationName.equals("org.testng.annotations.AfterMethod")) {
            this.setAfterIndex(index);
        } else if (annotationName.equals("org.testng.annotations.BeforeClass")) {
            this.setBeforeClassIndex(index);
        } else if (annotationName.equals("org.testng.annotations.AfterClass")) {
            this.setAfterClassIndex(index);
        }
    }

    void removeNoArgMethod(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("negative index (" + index + ')');
        }
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("index: " + index + ", size: " + this.size());
        }
        String signature = this.signatures.get(index);
        if (!signature.startsWith("! ")) {
            throw new IllegalArgumentException("not a no-arg method at the given index (" + index + ')');
        }
        if (index == this.getSetUpIndex()) {
            this.setSetUpIndex(-1);
        } else if (index == this.getTearDownIndex()) {
            this.setTearDownIndex(-1);
        }
        if (index == this.getFirstMethodIndex()) {
            int currSize = this.size();
            if (index == currSize - 1) {
                this.setFirstMethodIndex(-1);
            } else {
                int newFirstMethodIndex = -1;
                int memberIndex = index + 1;
                for (String sign : this.signatures.subList(index + 1, currSize)) {
                    if (sign.startsWith("! ")) {
                        newFirstMethodIndex = memberIndex;
                        break;
                    }
                    ++memberIndex;
                }
                this.setFirstMethodIndex(newFirstMethodIndex);
            }
        }
        this.shiftPositions(index + 1, -1);
    }

    List<String> getNoArgMethods() {
        if (!this.containsMethods()) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList(this.signatures.size());
        for (String signature : this.signatures) {
            if (!signature.startsWith("! ")) continue;
            result.add(signature.substring(2));
        }
        return result.isEmpty() ? Collections.emptyList() : result;
    }

    void addNestedClass(String name) {
        int currSize = this.size();
        this.signatures.add("[ " + name);
        if (this.getFirstNestedClassIndex() == -1) {
            this.setFirstNestedClassIndex(currSize);
        }
    }

    List<String> getNestedClasses() {
        int firstIndex = this.getFirstNestedClassIndex();
        if (firstIndex == -1) {
            return Collections.emptyList();
        }
        assert (this.signatures.get(firstIndex).charAt(0) == '[');
        String firstNestedClass = this.signatures.get(firstIndex).substring(2);
        int size = this.size();
        if (firstIndex == size - 1) {
            return Collections.singletonList(firstNestedClass);
        }
        List<String> result = null;
        int startIndex = firstIndex + 1;
        Iterator<String> it = this.signatures.subList(startIndex, size).iterator();
        int index = startIndex;
        while (it.hasNext()) {
            String signature = it.next();
            if (signature.charAt(0) == '[') {
                if (result == null) {
                    int initialCapacity = Math.min(4, size - index + 1);
                    result = new ArrayList<String>(initialCapacity);
                    result.add(firstNestedClass);
                }
                result.add(signature.substring(2));
            }
            ++index;
        }
        if (result == null) {
            result = Collections.singletonList(firstNestedClass);
        }
        return result;
    }

    int[] getNestedClassIndexes() {
        int firstIndex = this.getFirstNestedClassIndex();
        if (firstIndex == -1) {
            return EMPTY_INT_ARRAY;
        }
        assert (this.signatures.get(firstIndex).charAt(0) == '[');
        int size = this.size();
        if (firstIndex == size - 1) {
            return new int[]{firstIndex};
        }
        int[] result = null;
        int count = 1;
        int startIndex = firstIndex + 1;
        Iterator<String> it = this.signatures.subList(startIndex, size).iterator();
        int index = startIndex;
        while (it.hasNext()) {
            if (it.next().charAt(0) == '[') {
                if (result == null) {
                    result = new int[size - index + 1];
                }
                result[count++] = index;
            }
            ++index;
        }
        assert (count == 1 == (result == null));
        if (result == null) {
            result = new int[1];
        } else if (count < result.length) {
            int[] oldResult = result;
            result = new int[count];
            System.arraycopy(oldResult, 1, result, 1, count - 1);
        }
        result[0] = firstIndex;
        return result;
    }

    int size() {
        return this.signatures.size();
    }

    private void shiftPositions(int fromIndex, int shiftSize) {
        for (int i = 0; i < this.positions.length; ++i) {
            int pos = this.positions[i];
            if (pos == -1 || pos < fromIndex) continue;
            this.positions[i] = pos + shiftSize;
        }
    }
}

