/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.ui.actions;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.gsf.testrunner.ui.api.TestMethodController;
import org.netbeans.modules.java.testrunner.ui.spi.ComputeTestMethods;
import org.netbeans.spi.project.SingleMethod;
import org.openide.filesystems.FileObject;

public final class TestClassInfoTask
implements CancellableTask<CompilationController> {
    private final int caretPosition;
    private String packageName;
    private String className;
    private String methodName;
    private FileObject fo;
    static String ANNOTATION = "org.testng.annotations.Test";

    TestClassInfoTask(int caretPosition) {
        this.caretPosition = caretPosition;
    }

    public void cancel() {
    }

    public void run(CompilationController controller) throws Exception {
        List<TestMethodController.TestMethod> testMethods;
        controller.toPhase(JavaSource.Phase.RESOLVED);
        this.fo = controller.getFileObject();
        TypeElement typeElement2 = null;
        List topLevelElements = controller.getTopLevelElements();
        for (TypeElement typeElement2 : topLevelElements) {
            if (typeElement2.getKind() != ElementKind.CLASS) continue;
            this.className = typeElement2.getSimpleName().toString();
            break;
        }
        Elements elements = controller.getElements();
        if (typeElement2 != null) {
            this.packageName = elements.getPackageOf(typeElement2).getQualifiedName().toString();
        }
        if (!(testMethods = TestClassInfoTask.computeTestMethods((CompilationInfo)controller, new AtomicBoolean(), this.caretPosition)).isEmpty()) {
            this.methodName = testMethods.iterator().next().method().getMethodName();
        }
    }

    String getClassName() {
        return this.className;
    }

    String getMethodName() {
        return this.methodName;
    }

    String getPackageName() {
        return this.packageName;
    }

    FileObject getFileObject() {
        return this.fo;
    }

    public static List<TestMethodController.TestMethod> computeTestMethods(CompilationInfo info, AtomicBoolean cancel, int caretPosIfAny) {
        List<TreePath> methods;
        FileObject fileObject = info.getFileObject();
        if (caretPosIfAny == -1) {
            Optional<Tree> anyClass = info.getCompilationUnit().getTypeDecls().stream().filter(t -> t.getKind() == Tree.Kind.CLASS).findAny();
            if (!anyClass.isPresent()) {
                return Collections.emptyList();
            }
            ClassTree clazz = (ClassTree)anyClass.get();
            TreePath pathToClass = new TreePath(new TreePath(info.getCompilationUnit()), clazz);
            methods = clazz.getMembers().stream().filter(m -> m.getKind() == Tree.Kind.METHOD).map(m -> new TreePath(pathToClass, (Tree)m)).collect(Collectors.toList());
        } else {
            TreePath tp;
            for (tp = info.getTreeUtilities().pathFor(caretPosIfAny); tp != null && tp.getLeaf().getKind() != Tree.Kind.METHOD; tp = tp.getParentPath()) {
            }
            if (tp != null) {
                methods = Collections.singletonList(tp);
            } else {
                return Collections.emptyList();
            }
        }
        Elements elements = info.getElements();
        ArrayList<TestMethodController.TestMethod> result = new ArrayList<TestMethodController.TestMethod>();
        for (TreePath tp : methods) {
            if (cancel.get()) {
                return null;
            }
            Element element = info.getTrees().getElement(tp);
            if (element == null) continue;
            List<? extends AnnotationMirror> allAnnotationMirrors = elements.getAllAnnotationMirrors(element);
            for (AnnotationMirror annotationMirror : allAnnotationMirrors) {
                TypeElement typeElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
                if (!typeElement.getQualifiedName().contentEquals(ANNOTATION)) continue;
                String mn = element.getSimpleName().toString();
                SourcePositions sp = info.getTrees().getSourcePositions();
                int start = (int)sp.getStartPosition(tp.getCompilationUnit(), tp.getLeaf());
                int end = (int)sp.getEndPosition(tp.getCompilationUnit(), tp.getLeaf());
                Document doc = info.getSnapshot().getSource().getDocument(false);
                try {
                    result.add(new TestMethodController.TestMethod(new SingleMethod(fileObject, mn), doc != null ? doc.createPosition(start) : null, doc != null ? doc.createPosition(end) : null));
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        return result;
    }

    public static final class ComputeTestMethodsImpl
    implements ComputeTestMethods.Factory {
        public ComputeTestMethods create() {
            return new TaskImpl();
        }

        private static class TaskImpl
        implements ComputeTestMethods {
            private final AtomicBoolean cancel = new AtomicBoolean();

            private TaskImpl() {
            }

            public void cancel() {
                this.cancel.set(true);
            }

            public List<TestMethodController.TestMethod> computeTestMethods(CompilationInfo info) {
                return TestClassInfoTask.computeTestMethods(info, this.cancel, -1);
            }
        }
    }
}

