/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.ant;

import java.io.File;
import java.util.Properties;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.apache.tools.ant.module.spi.TaskStructure;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.java.testrunner.ant.utils.AntLoggerUtils;
import org.netbeans.modules.testng.ant.AntSessionInfo;
import org.netbeans.modules.testng.ant.TestNGOutputReader;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class TestNGAntLogger
extends AntLogger {
    private static final int[] LEVELS_OF_INTEREST = new int[]{2, 1, 3, 0};
    private static final String[] INTERESTING_TASKS = new String[]{"java", "testng"};
    private static final String ANT_TEST_RUNNER_CLASS_NAME = "org.testng.TestNG";

    public boolean interestedInSession(AntSession session) {
        return true;
    }

    public String[] interestedInTargets(AntSession session) {
        return AntLogger.ALL_TARGETS;
    }

    public String[] interestedInTasks(AntSession session) {
        return INTERESTING_TASKS;
    }

    public boolean interestedInScript(File script, AntSession session) {
        return true;
    }

    public int[] interestedInLogLevels(AntSession session) {
        return LEVELS_OF_INTEREST;
    }

    public void messageLogged(AntEvent event) {
        if (this.isTestTaskRunning(event)) {
            if (event.getLogLevel() != 3) {
                this.getOutputReader(event).messageLogged(event);
            } else {
                this.getOutputReader(event).verboseMessageLogged(event);
            }
        }
    }

    private boolean isTestTaskRunning(AntEvent event) {
        return AntLoggerUtils.isTestSessionType((TestSession.SessionType)this.getSessionInfo(event.getSession()).getCurrentSessionType());
    }

    public void taskStarted(AntEvent event) {
        TestSession.SessionType sessionType = AntLoggerUtils.detectSessionType((AntEvent)event, (String)"testng");
        if (AntLoggerUtils.isTestSessionType((TestSession.SessionType)sessionType)) {
            AntSessionInfo sessionInfo = this.getSessionInfo(event.getSession());
            assert (!AntLoggerUtils.isTestSessionType((TestSession.SessionType)sessionInfo.getCurrentSessionType()));
            sessionInfo.setTimeOfTestTaskStart(System.currentTimeMillis());
            sessionInfo.setCurrentSessionType(sessionType);
            if (sessionInfo.getSessionType() == null) {
                sessionInfo.setSessionType(sessionType);
            }
            String suiteName = null;
            String logLevel = null;
            TaskStructure struct = event.getTaskStructure();
            if ("testng".equals(struct.getName())) {
                suiteName = struct.getAttribute("suitename");
                logLevel = struct.getAttribute("verbose");
                if (logLevel == null) {
                    logLevel = struct.getAttribute("log");
                }
            } else if ("java".equals(struct.getName())) {
                TaskStructure[] nestedElems;
                for (TaskStructure ts : nestedElems = struct.getChildren()) {
                    String a;
                    if (!ts.getName().equals("arg") || (a = ts.getAttribute("line")) == null) continue;
                    String[] args = event.evaluate(a).split(" ");
                    int size = args.length;
                    for (int i = 0; i < size; ++i) {
                        String curr = args[i];
                        if ("-suitename".equals(curr)) {
                            suiteName = i + 1 < size ? args[i + 1] : null;
                            ++i;
                            continue;
                        }
                        if (!"-log".equals(curr) && !"-verbose".equals(curr)) continue;
                        logLevel = i + 1 < size ? args[i + 1] : null;
                        ++i;
                    }
                }
            } else assert (false) : "Unexpeted task " + struct.getName();
            if (suiteName != null) {
                sessionInfo.setSessionName(event.evaluate(suiteName));
            }
            boolean offline = false;
            if (logLevel != null) {
                int lvl;
                try {
                    lvl = Integer.valueOf(event.evaluate(logLevel));
                }
                catch (NumberFormatException nfe) {
                    lvl = -1;
                }
                offline = lvl == 0;
            }
            this.getOutputReader(event).testTaskStarted(offline, event);
        }
    }

    public void taskFinished(AntEvent event) {
        AntSessionInfo sessionInfo = this.getSessionInfo(event.getSession());
        if (AntLoggerUtils.isTestSessionType((TestSession.SessionType)sessionInfo.getCurrentSessionType())) {
            this.getOutputReader(event).testTaskFinished();
            sessionInfo.setCurrentSessionType(null);
        }
    }

    public void buildFinished(AntEvent event) {
        AntSession session = event.getSession();
        AntSessionInfo sessionInfo = this.getSessionInfo(session);
        if (AntLoggerUtils.isTestSessionType((TestSession.SessionType)sessionInfo.getSessionType())) {
            this.getOutputReader(event).buildFinished(event);
        }
        session.putCustomData((AntLogger)this, null);
    }

    private TestNGOutputReader getOutputReader(AntEvent event) {
        assert (AntLoggerUtils.isTestSessionType((TestSession.SessionType)this.getSessionInfo(event.getSession()).getSessionType()));
        AntSession session = event.getSession();
        AntSessionInfo sessionInfo = this.getSessionInfo(session);
        TestNGOutputReader outputReader = sessionInfo.outputReader;
        if (outputReader == null) {
            String[] propsOfInterest;
            String projectDir = null;
            Project project = null;
            try {
                projectDir = event.getProperty("work.dir");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (projectDir == null) {
                    projectDir = event.getProperty("basedir");
                }
                if (projectDir != null && projectDir.length() != 0) {
                    File f = FileUtil.normalizeFile((File)new File(projectDir));
                    project = FileOwnerQuery.getOwner((FileObject)FileUtil.toFileObject((File)f));
                }
            }
            catch (Exception f) {
                // empty catch block
            }
            Properties props = new Properties();
            for (String prop : propsOfInterest = new String[]{"test.class", "test.methods", "javac.includes", "classname", "methodname", "work.dir", "classpath", "platform.java", "test.includes"}) {
                String val = event.getProperty(prop);
                if (val == null) continue;
                props.setProperty(prop, val);
            }
            sessionInfo.outputReader = outputReader = new TestNGOutputReader(session, sessionInfo, project, props);
        }
        return outputReader;
    }

    private AntSessionInfo getSessionInfo(AntSession session) {
        AntSessionInfo sessionInfo;
        Object o = session.getCustomData((AntLogger)this);
        assert (o == null || o instanceof AntSessionInfo);
        if (o != null) {
            sessionInfo = (AntSessionInfo)o;
        } else {
            sessionInfo = new AntSessionInfo();
            session.putCustomData((AntLogger)this, (Object)sessionInfo);
        }
        return sessionInfo;
    }
}

