/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.terminal.nb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.terminal.support.TerminalPinSupport;
import org.openide.util.NbPreferences;

public class TerminalPinnedTabOptions {
    private static final Preferences defaultPrefs = NbPreferences.forModule(TerminalPinnedTabOptions.class).node("TerminalPinTabs");
    private static final TerminalPinnedTabOptions INSTANCE = new TerminalPinnedTabOptions(defaultPrefs);
    private static final String DELIMITER = "_";
    private static final String CUSTOM_TITLE = "customTitle";
    private static final String CWD = "cwd";
    private static final String EXEC_ENV = "execEnv";
    private static final String PWD_FLAG = "pwdFlag";
    private static final String TITLE = "title";
    private final Preferences prefs;

    private TerminalPinnedTabOptions(Preferences prefs) {
        this.prefs = prefs;
    }

    public static TerminalPinnedTabOptions getDefault() {
        return INSTANCE;
    }

    public void persist(TerminalPinSupport.TerminalDetails details) {
        TerminalPinSupport.TerminalCreationDetails creationDetails = details.getCreationDetails();
        TerminalPinSupport.TerminalPinningDetails pinningDetails = details.getPinningDetails();
        long id = creationDetails.getId();
        this.writeProp(id, CUSTOM_TITLE, String.valueOf(pinningDetails.isCustomTitle()));
        this.writeProp(id, CWD, pinningDetails.getCwd());
        this.writeProp(id, EXEC_ENV, creationDetails.getExecEnv());
        this.writeProp(id, PWD_FLAG, String.valueOf(creationDetails.isPwdFlag()));
        this.writeProp(id, TITLE, pinningDetails.getTitle());
    }

    public void forget(long id) {
        this.removeProp(id, CUSTOM_TITLE);
        this.removeProp(id, CWD);
        this.removeProp(id, EXEC_ENV);
        this.removeProp(id, PWD_FLAG);
        this.removeProp(id, TITLE);
    }

    public void clear() {
        try {
            this.prefs.clear();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    private void writeProp(long id, String postfix, String value) {
        String key = Long.toString(id).concat(DELIMITER).concat(postfix);
        if (value != null) {
            this.prefs.put(key, value);
        } else {
            this.prefs.put(key, "");
        }
    }

    private void removeProp(long id, String postfix) {
        String key = Long.toString(id).concat(DELIMITER).concat(postfix);
        this.prefs.remove(key);
    }

    public List<TerminalPinSupport.TerminalDetails> readStoredDetails() {
        HashMap<Long, TerminalPinSupport.TerminalDetails> map = new HashMap<Long, TerminalPinSupport.TerminalDetails>();
        try {
            String[] keys = this.prefs.keys();
            for (int i = 0; i < keys.length; ++i) {
                long id = this.getId(keys[i]);
                boolean customTitle = Boolean.valueOf(this.prefs.get(keys[i], ""));
                String cwd = this.prefs.get(keys[++i], "");
                String execEnv = this.prefs.get(keys[++i], "");
                boolean pwdFlag = Boolean.valueOf(this.prefs.get(keys[++i], ""));
                String title = this.prefs.get(keys[++i], "");
                map.put(id, new TerminalPinSupport.TerminalDetails(TerminalPinSupport.TerminalCreationDetails.create(id, execEnv, pwdFlag), TerminalPinSupport.TerminalPinningDetails.create(customTitle, title, cwd, false)));
            }
        }
        catch (Exception ex) {
            try {
                this.prefs.clear();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
        return new ArrayList<TerminalPinSupport.TerminalDetails>(map.values());
    }

    private long getId(String value) {
        String[] split = value.split(DELIMITER);
        return Long.parseLong(split[0]);
    }
}

