/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.terminal.nb;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.terminal.support.TerminalPinSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PinPanel
extends JPanel {
    public static final String PROPERTY_VALID = "valid";
    private JCheckBox customCheckBox;
    private JTextField directoryField;
    private JLabel directoryLabel;
    private JTextField envField;
    private JLabel envLabel;
    private JLabel statusLabel;
    private JTextField titleField;
    private JLabel titleLabel;

    public PinPanel(TerminalPinSupport.TerminalDetails details) {
        this.initComponents();
        TerminalPinSupport.TerminalCreationDetails creationDetails = details.getCreationDetails();
        TerminalPinSupport.TerminalPinningDetails pinningDetails = details.getPinningDetails();
        this.envField.setText(creationDetails.getExecEnv());
        this.titleField.setText(pinningDetails.getTitle());
        this.customCheckBox.setSelected(pinningDetails.isCustomTitle());
        this.customStateChanged(pinningDetails.isCustomTitle());
        if (pinningDetails.getCwd() != null) {
            this.directoryField.setText(pinningDetails.getCwd());
        } else {
            this.directoryField.setText("");
        }
        this.directoryField.getDocument().addDocumentListener(new Validator());
    }

    public String getTitle() {
        return this.titleField.getText();
    }

    public boolean isCustomTitle() {
        return this.customCheckBox.isSelected();
    }

    public String getDirectory() {
        return this.directoryField.getText();
    }

    private void initComponents() {
        this.envLabel = new JLabel();
        this.envField = new JTextField();
        this.titleLabel = new JLabel();
        this.titleField = new JTextField();
        this.customCheckBox = new JCheckBox();
        this.directoryLabel = new JLabel();
        this.directoryField = new JTextField();
        this.statusLabel = new JLabel();
        this.envLabel.setLabelFor(this.envField);
        Mnemonics.setLocalizedText((JLabel)this.envLabel, (String)NbBundle.getMessage(PinPanel.class, (String)"PinPanel.envLabel.text"));
        this.envField.setEditable(false);
        this.envField.setText(NbBundle.getMessage(PinPanel.class, (String)"PinPanel.envField.text"));
        this.envField.setFocusable(false);
        this.envField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PinPanel.this.envFieldActionPerformed(evt);
            }
        });
        this.titleLabel.setLabelFor(this.titleField);
        Mnemonics.setLocalizedText((JLabel)this.titleLabel, (String)NbBundle.getMessage(PinPanel.class, (String)"PinPanel.titleLabel.text"));
        this.titleField.setText(NbBundle.getMessage(PinPanel.class, (String)"PinPanel.titleField.text"));
        this.customCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.customCheckBox, (String)NbBundle.getMessage(PinPanel.class, (String)"PinPanel.customCheckBox.text"));
        this.customCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PinPanel.this.customCheckBoxActionPerformed(evt);
            }
        });
        this.directoryLabel.setLabelFor(this.directoryField);
        Mnemonics.setLocalizedText((JLabel)this.directoryLabel, (String)NbBundle.getMessage(PinPanel.class, (String)"PinPanel.directoryLabel.text"));
        this.directoryField.setText(NbBundle.getMessage(PinPanel.class, (String)"PinPanel.directoryField.text"));
        Mnemonics.setLocalizedText((JLabel)this.statusLabel, (String)NbBundle.getMessage(PinPanel.class, (String)"PinPanel.statusLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusLabel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.directoryLabel).addComponent(this.titleLabel).addComponent(this.envLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.envField).addGroup(layout.createSequentialGroup().addComponent(this.titleField, -1, 133, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.customCheckBox)).addComponent(this.directoryField)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.envLabel).addComponent(this.envField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.titleLabel).addComponent(this.titleField, -2, -1, -2).addComponent(this.customCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.directoryLabel).addComponent(this.directoryField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.statusLabel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.envLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PinPanel.class, (String)"PinPanel.envLabel.AccessibleContext.accessibleDescription"));
        this.envField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PinPanel.class, (String)"PinPanel.envField.AccessibleContext.accessibleName"));
        this.envField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PinPanel.class, (String)"PinPanel.envField.AccessibleContext.accessibleDescription"));
        this.titleLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PinPanel.class, (String)"PinPanel.titleLabel.AccessibleContext.accessibleDescription"));
        this.titleField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PinPanel.class, (String)"PinPanel.titleField.AccessibleContext.accessibleName"));
        this.titleField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PinPanel.class, (String)"PinPanel.titleField.AccessibleContext.accessibleDescription"));
        this.customCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PinPanel.class, (String)"PinPanel.customCheckBox.AccessibleContext.accessibleDescription"));
        this.directoryLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PinPanel.class, (String)"PinPanel.directoryLabel.AccessibleContext.accessibleDescription"));
        this.directoryField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PinPanel.class, (String)"PinPanel.directoryField.AccessibleContext.accessibleName"));
        this.directoryField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PinPanel.class, (String)"PinPanel.directoryField.AccessibleContext.accessibleDescription"));
    }

    private void envFieldActionPerformed(ActionEvent evt) {
    }

    private void customCheckBoxActionPerformed(ActionEvent evt) {
        this.customStateChanged(this.customCheckBox.isSelected());
    }

    private void customStateChanged(boolean newState) {
        if (newState) {
            this.titleField.setEnabled(true);
            this.titleField.requestFocus();
        } else {
            this.titleField.setEnabled(false);
        }
    }

    public class Validator
    implements DocumentListener {
        private boolean validOld = true;

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateText();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateText();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateText();
        }

        private boolean isValid() {
            String text = PinPanel.this.directoryField.getText();
            return text.startsWith("/") || text.startsWith("~") || text.startsWith("$");
        }

        private void updateText() {
            boolean validNew = this.isValid();
            if (validNew && !this.validOld) {
                PinPanel.this.firePropertyChange(PinPanel.PROPERTY_VALID, this.validOld, validNew);
                this.validOld = true;
                PinPanel.this.statusLabel.setText("");
            } else if (!validNew && this.validOld) {
                PinPanel.this.firePropertyChange(PinPanel.PROPERTY_VALID, this.validOld, validNew);
                this.validOld = false;
                PinPanel.this.statusLabel.setText(NbBundle.getMessage(PinPanel.class, (String)"ERR_RelativeDir"));
                PinPanel.this.statusLabel.setForeground(Color.RED);
            }
        }
    }
}

