/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.team.commons.treelist;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.MissingResourceException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.team.commons.ColorManager;
import org.netbeans.modules.team.commons.treelist.LinkButton;
import org.netbeans.modules.team.commons.treelist.ProgressLabel;
import org.netbeans.modules.team.commons.treelist.TreeLabel;
import org.netbeans.modules.team.commons.treelist.TreeListNode;
import org.openide.util.Cancellable;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public abstract class AsynchronousNode<T>
extends TreeListNode {
    private JComponent inner = null;
    private JPanel panel;
    private JLabel lblTitle;
    private JLabel lblIcon;
    private ProgressLabel lblLoading;
    private JLabel lblError;
    private LinkButton btnRetry;
    private boolean loaded = false;
    private Loader loader;
    private final Object LOCK = new Object();
    private JLabel lblFill;
    private boolean expandAfterRefresh;
    private final String title;
    private final Icon icon;
    private static final RequestProcessor RP = new RequestProcessor("Asynchronous Tree List Node - Loader", 5);

    public AsynchronousNode(boolean expandable, TreeListNode parent, String title) {
        this(expandable, parent, title, null);
    }

    public AsynchronousNode(boolean expandable, TreeListNode parent, String title, Icon icon) {
        super(expandable, parent);
        this.title = title;
        this.icon = icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final JComponent getComponent(Color foreground, Color background, boolean isSelected, boolean hasFocus, int rowWidth) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.panel == null) {
                this.getPanel();
            }
            if (null != this.inner) {
                this.configure(this.inner, foreground, background, isSelected, hasFocus, rowWidth);
            } else {
                if (!this.loaded && null == this.loader) {
                    this.startLoading();
                }
                if (isSelected) {
                    this.lblLoading.setForeground(foreground);
                    this.lblError.setForeground(foreground);
                    this.btnRetry.setForeground(foreground);
                } else {
                    this.lblLoading.setForeground(ColorManager.getDefault().getDisabledColor());
                    this.lblError.setForeground(ColorManager.getDefault().getErrorColor());
                }
                this.lblTitle.setForeground(foreground);
                String renderedTitle = this.getTitle(this.lblTitle, isSelected, hasFocus, rowWidth);
                if (renderedTitle != null) {
                    this.lblTitle.setText(renderedTitle);
                }
            }
        }
        return this.panel;
    }

    protected String getTitle(JComponent component, boolean isSelected, boolean hasFocus, int rowWidth) {
        return null;
    }

    protected abstract void configure(JComponent var1, Color var2, Color var3, boolean var4, boolean var5, int var6);

    protected abstract JComponent createComponent(T var1);

    protected abstract T load();

    protected final void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = AsynchronousNode.this.LOCK;
                synchronized (object) {
                    AsynchronousNode.this.expandAfterRefresh = AsynchronousNode.this.isExpandable() && AsynchronousNode.this.isExpanded();
                    if (AsynchronousNode.this.expandAfterRefresh) {
                        AsynchronousNode.this.setExpanded(false);
                    }
                    AsynchronousNode.this.loaded = false;
                    JPanel p = AsynchronousNode.this.getPanel();
                    if (null != AsynchronousNode.this.inner) {
                        p.remove(AsynchronousNode.this.inner);
                        AsynchronousNode.this.lblTitle.setText(AsynchronousNode.this.title);
                        p.add((Component)AsynchronousNode.this.lblIcon, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
                        p.add((Component)AsynchronousNode.this.lblTitle, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
                        p.add((Component)AsynchronousNode.this.lblFill, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                    }
                    AsynchronousNode.this.inner = null;
                    AsynchronousNode.this.startLoading();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isLoaded() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.loaded;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLoadingVisible(boolean bl) {
        Object object = this.LOCK;
        synchronized (object) {
            this.lblLoading.setVisible(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLoading() {
        Object object = this.LOCK;
        synchronized (object) {
            this.loaded = false;
            this.lblLoading.setVisible(true);
            this.lblError.setVisible(false);
            this.btnRetry.setVisible(false);
        }
        if (null != this.loader) {
            this.loader.cancel();
        }
        this.loader = new Loader();
        RP.post((Runnable)this.loader);
    }

    private void timedout() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = AsynchronousNode.this.LOCK;
                synchronized (object) {
                    AsynchronousNode.this.lblError.setVisible(true);
                    AsynchronousNode.this.btnRetry.setVisible(true);
                    AsynchronousNode.this.lblLoading.setVisible(false);
                    AsynchronousNode.this.loaded = true;
                    AsynchronousNode.this.loader = null;
                }
                AsynchronousNode.this.fireContentChanged();
            }
        });
    }

    private void loaded(final T data) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = AsynchronousNode.this.LOCK;
                synchronized (object) {
                    JComponent c = AsynchronousNode.this.createComponent(data);
                    AsynchronousNode.this.loaded = true;
                    JPanel p = AsynchronousNode.this.getPanel();
                    if (null == c) {
                        AsynchronousNode.this.lblLoading.setVisible(false);
                        AsynchronousNode.this.lblError.setVisible(true);
                        AsynchronousNode.this.btnRetry.setVisible(true);
                    } else {
                        AsynchronousNode.this.lblLoading.setVisible(false);
                        AsynchronousNode.this.lblError.setVisible(false);
                        AsynchronousNode.this.btnRetry.setVisible(false);
                        if (null != AsynchronousNode.this.inner) {
                            p.remove(AsynchronousNode.this.inner);
                        }
                        AsynchronousNode.this.inner = c;
                        p.remove(AsynchronousNode.this.lblTitle);
                        AsynchronousNode.this.lblTitle.setText("");
                        p.remove(AsynchronousNode.this.lblIcon);
                        p.remove(AsynchronousNode.this.lblFill);
                        p.add((Component)AsynchronousNode.this.inner, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                    }
                    p.invalidate();
                    p.revalidate();
                    p.repaint();
                    AsynchronousNode.this.loader = null;
                    if (AsynchronousNode.this.expandAfterRefresh) {
                        AsynchronousNode.this.setExpanded(true);
                    }
                }
                AsynchronousNode.this.fireContentChanged();
            }
        });
    }

    private JPanel getPanel() throws MissingResourceException {
        if (this.panel == null) {
            this.panel = new JPanel(new GridBagLayout());
            this.panel.setOpaque(false);
            this.lblTitle = new TreeLabel(this.title);
            this.lblIcon = new TreeLabel();
            this.lblIcon.setIcon(this.icon);
            this.lblLoading = this.createProgressLabel("");
            this.lblLoading.setForeground(ColorManager.getDefault().getDisabledColor());
            this.lblError = new TreeLabel(NbBundle.getMessage(AsynchronousNode.class, (String)"LBL_NotResponding"));
            this.lblError.setForeground(ColorManager.getDefault().getErrorColor());
            Image img = ImageUtilities.loadImage((String)"org/netbeans/modules/team/commons/resources/error.png");
            this.lblError.setIcon(new ImageIcon(img));
            this.lblFill = new JLabel();
            this.btnRetry = new LinkButton(NbBundle.getMessage(AsynchronousNode.class, (String)"LBL_Retry"), (Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AsynchronousNode.this.refresh();
                }
            });
            this.panel.add((Component)this.lblIcon, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
            this.panel.add((Component)this.lblTitle, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
            this.panel.add((Component)this.lblFill, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.lblLoading, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
            this.panel.add((Component)this.lblError, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
            this.panel.add((Component)this.btnRetry, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        }
        return this.panel;
    }

    private class Loader
    implements Runnable,
    Cancellable {
        private boolean cancelled = false;
        private Thread t = null;

        private Loader() {
        }

        @Override
        public void run() {
            block4: {
                final Object[] res = new Object[1];
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        res[0] = AsynchronousNode.this.load();
                    }
                };
                this.t = new Thread(r);
                this.t.start();
                try {
                    this.t.join(TreeListNode.TIMEOUT_INTERVAL_MILLIS);
                    if (null == res[0]) {
                        AsynchronousNode.this.timedout();
                        return;
                    }
                    if (this.cancelled) {
                        return;
                    }
                    AsynchronousNode.this.loaded(res[0]);
                }
                catch (InterruptedException iE) {
                    if (this.cancelled) break block4;
                    AsynchronousNode.this.timedout();
                }
            }
        }

        public boolean cancel() {
            this.cancelled = true;
            if (null != this.t) {
                this.t.interrupt();
            }
            return true;
        }
    }
}

