/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.history;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.history.RepositoryRevision;
import org.netbeans.modules.subversion.ui.history.SearchCriteriaPanel;
import org.netbeans.modules.subversion.ui.history.SearchHistoryPanel;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.utils.SVNUrlUtils;

class SearchExecutor
extends SvnProgressSupport {
    public static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    static final SimpleDateFormat fullDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    static final DateFormat[] dateFormats = new DateFormat[]{fullDateFormat, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), simpleDateFormat, new SimpleDateFormat("yyyy-MM-dd")};
    private static final Logger LOG = Logger.getLogger(SearchExecutor.class.getName());
    private final SearchHistoryPanel master;
    private Map<SVNUrl, Set<File>> workFiles;
    private Map<String, File> pathToRoot;
    private final SearchCriteriaPanel criteria;
    private int completedSearches;
    private boolean searchCanceled;
    private List<RepositoryRevision> results = new ArrayList<RepositoryRevision>();
    static final int DEFAULT_LIMIT = 10;
    private final SVNRevision fromRevision;
    private final SVNRevision toRevision;
    private final int limit;
    private SvnProgressSupport currentSearch;

    public SearchExecutor(SearchHistoryPanel master) {
        this.master = master;
        this.criteria = master.getCriteria();
        this.fromRevision = this.criteria.getFrom();
        this.toRevision = this.criteria.getTo();
        this.limit = this.searchingUrl() || master.getRoots().length == 1 ? 10 : 0;
    }

    private void populatePathToRoot() {
        this.pathToRoot = new HashMap<String, File>();
        try {
            if (this.searchingUrl()) {
                String rootPath = SvnUtils.getRepositoryPath(this.master.getRoots()[0]);
                this.pathToRoot.put(rootPath, this.master.getRoots()[0]);
            } else {
                this.workFiles = new HashMap<SVNUrl, Set<File>>();
                for (File file : this.master.getRoots()) {
                    SVNUrl rootUrl = SvnUtils.getRepositoryRootUrl(file);
                    this.populatePathToRoot(file, rootUrl);
                    Set<File> set = this.workFiles.get(rootUrl);
                    if (set == null) {
                        set = new HashSet<File>(2);
                        this.workFiles.put(rootUrl, set);
                    }
                    set.add(file);
                }
            }
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
        }
    }

    private void populatePathToRoot(File file, SVNUrl rootUrl) throws SVNClientException {
        Map<File, SVNUrl> m = SvnUtils.getRepositoryUrls(file);
        for (Map.Entry<File, SVNUrl> e : m.entrySet()) {
            SVNUrl url = e.getValue();
            if (url == null) continue;
            String rootPath = SvnUtils.decodeToString(SVNUrlUtils.getRelativePath((SVNUrl)rootUrl, (SVNUrl)url, (boolean)true));
            if (rootPath == null) {
                LOG.log(Level.FINE, "populatePathToRoot: rootUrl: {0}, url: {1}, probably svn:externals", new String[]{rootUrl.toString(), url.toString()});
                continue;
            }
            String fileAbsPath = e.getKey().getAbsolutePath().replace(File.separatorChar, '/');
            int commonPathLength = this.getCommonPostfixLength(rootPath, fileAbsPath);
            this.pathToRoot.put(rootPath.substring(0, rootPath.length() - commonPathLength), new File(fileAbsPath.substring(0, fileAbsPath.length() - commonPathLength)));
        }
    }

    private int getCommonPostfixLength(String a, String b) {
        int ai = a.length() - 1;
        int slash = -1;
        for (int bi = b.length() - 1; ai >= 0 && bi >= 0; --ai, --bi) {
            char ca = a.charAt(ai);
            char cb = b.charAt(bi);
            if (ca == '/') {
                slash = ai;
            }
            if (ca == cb) continue;
            if (slash <= -1) break;
            return a.length() - slash;
        }
        return a.length() - ai - 1;
    }

    @Override
    public void perform() {
        this.populatePathToRoot();
        if (this.fromRevision == null || this.toRevision == null) {
            LOG.log(Level.WARNING, "wrong revision: [{0}:{1}] - [{2}:{3}]", new Object[]{this.fromRevision, this.criteria.tfFrom.getText(), this.toRevision, this.criteria.tfTo.getText()});
            return;
        }
        this.completedSearches = 0;
        if (this.searchingUrl()) {
            RequestProcessor rp = Subversion.getInstance().getRequestProcessor(this.master.getRepositoryUrl());
            this.currentSearch = new SvnProgressSupport(){

                @Override
                public void perform() {
                    SearchExecutor.this.search(SearchExecutor.this.master.getRepositoryUrl(), null, SearchExecutor.this.fromRevision, SearchExecutor.this.toRevision, this, false, SearchExecutor.this.limit);
                    SearchExecutor.this.checkFinished();
                }
            };
            this.currentSearch.start(rp, this.master.getRepositoryUrl(), NbBundle.getMessage(SearchExecutor.class, (String)"MSG_Search_Progress")).waitFinished();
        } else {
            for (final SVNUrl rootUrl : this.workFiles.keySet()) {
                final Set<File> files = this.workFiles.get(rootUrl);
                RequestProcessor rp = Subversion.getInstance().getRequestProcessor(rootUrl);
                this.currentSearch = new SvnProgressSupport(){

                    @Override
                    public void perform() {
                        SearchExecutor.this.search(rootUrl, files, SearchExecutor.this.fromRevision, SearchExecutor.this.toRevision, this, false, SearchExecutor.this.limit);
                        SearchExecutor.this.checkFinished();
                    }
                };
                this.currentSearch.start(rp, rootUrl, NbBundle.getMessage(SearchExecutor.class, (String)"MSG_Search_Progress")).waitFinished();
                if (!this.isCanceled() && !this.currentSearch.isCanceled()) continue;
                this.cancel();
                break;
            }
        }
    }

    private void search(SVNUrl rootUrl, Set<File> files, SVNRevision fromRevision, SVNRevision toRevision, SvnProgressSupport progressSupport, boolean fetchDetailsPaths, int limit) {
        block15: {
            SvnClient client;
            try {
                client = Subversion.getInstance().getClient(rootUrl, progressSupport);
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                return;
            }
            if (progressSupport.isCanceled()) {
                this.searchCanceled = true;
                return;
            }
            if (this.searchingUrl()) {
                try {
                    ISVNLogMessage[] messages = client.getLogMessages(rootUrl, null, toRevision, fromRevision, false, fetchDetailsPaths, limit);
                    this.appendResults(rootUrl, messages, null);
                }
                catch (SVNClientException e) {
                    if (!SvnClientExceptionHandler.handleLogException(rootUrl, toRevision, e)) {
                        progressSupport.annotate(e);
                    }
                    break block15;
                }
            }
            String[] paths = new String[files.size()];
            int idx = 0;
            HashMap<String, SVNRevision> revisions = new HashMap<String, SVNRevision>();
            try {
                for (File file : files) {
                    ISVNInfo info = client.getInfoFromWorkingCopy(file);
                    String p = SvnUtils.getRelativePath(file);
                    if (p != null && p.startsWith("/")) {
                        p = p.substring(1);
                    }
                    paths[idx++] = p;
                    if (info == null || info.getRevision() == null) continue;
                    revisions.put(p, (SVNRevision)info.getRevision());
                }
                ISVNLogMessage[] messages = SvnUtils.getLogMessages(client, rootUrl, paths, revisions, toRevision, fromRevision, false, fetchDetailsPaths, limit);
                this.appendResults(rootUrl, messages, revisions);
            }
            catch (SVNClientException e) {
                block16: {
                    try {
                        if (SvnClientExceptionHandler.isHTTP403(e.getMessage())) {
                            for (String path : paths) {
                                ISVNLogMessage[] messages = client.getLogMessages(rootUrl.appendPath(path), null, toRevision, fromRevision, false, fetchDetailsPaths, limit);
                                this.appendResults(rootUrl, messages, revisions);
                            }
                            return;
                        }
                    }
                    catch (SVNClientException ex) {
                        if (SvnClientExceptionHandler.handleLogException(rootUrl, toRevision, e)) break block16;
                        progressSupport.annotate(ex);
                    }
                }
                if (SvnClientExceptionHandler.handleLogException(rootUrl, toRevision, e)) break block15;
                progressSupport.annotate(e);
            }
        }
    }

    private synchronized void appendResults(SVNUrl rootUrl, ISVNLogMessage[] logMessages, Map<String, SVNRevision> pegRevisions) {
        for (int i = logMessages.length - 1; i >= 0; --i) {
            ISVNLogMessage logMessage = logMessages[i];
            if (logMessage == null) continue;
            RepositoryRevision rev = new RepositoryRevision(logMessage, rootUrl, this.master.getRoots(), this.pathToRoot, pegRevisions);
            this.results.add(rev);
        }
    }

    private boolean searchingUrl() {
        return this.master.getRepositoryUrl() != null;
    }

    private void checkFinished() {
        ++this.completedSearches;
        if (this.searchingUrl() && this.completedSearches >= 1 || this.workFiles.size() == this.completedSearches) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SearchExecutor.this.master.setResults(SearchExecutor.this.results, SearchHistoryPanel.createKenaiUsersMap(SearchExecutor.this.results), SearchExecutor.this.limit);
                }
            });
        }
    }

    void start() {
        this.start(Subversion.getInstance().getParallelRequestProcessor(), null, null);
    }

    @Override
    public synchronized boolean cancel() {
        if (this.currentSearch != null) {
            this.currentSearch.cancel();
        }
        return super.cancel();
    }

    @Override
    protected void finnishProgress() {
    }

    @Override
    protected void startProgress() {
    }

    @Override
    protected ProgressHandle getProgressHandle() {
        return null;
    }

    List<RepositoryRevision> search(SVNUrl repositoryUrl, int count, SvnProgressSupport supp) {
        this.results.clear();
        this.search(repositoryUrl, this.searchingUrl() ? null : new HashSet<File>(Arrays.asList(this.master.getRoots())), this.fromRevision, this.toRevision, supp, false, count);
        return new ArrayList<RepositoryRevision>(this.results);
    }
}

