/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.spring.api.SpringUtilities;
import org.netbeans.modules.spring.beans.index.SpringIndex;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.schema.completion.spi.CompletionContext;
import org.netbeans.modules.xml.schema.completion.spi.CompletionModelProvider;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.JarFileSystem;
import org.openide.util.Exceptions;

public class OpenTagCompletionProvider
extends CompletionModelProvider {
    private static final Logger LOGGER = Logger.getLogger(OpenTagCompletionProvider.class.getSimpleName());
    private Map<String, String> declaredNamespaces;
    private Set<String> usedPrefixes = new HashSet<String>();

    public List<CompletionModelProvider.CompletionModel> getModels(CompletionContext context) {
        if (!context.getCompletionType().equals((Object)CompletionContext.CompletionType.COMPLETION_TYPE_ELEMENT)) {
            return Collections.emptyList();
        }
        BaseDocument doc = context.getBaseDocument();
        String mime = (String)doc.getProperty((Object)"mimeType");
        if (!"text/x-springconfig+xml".equals(mime)) {
            return Collections.emptyList();
        }
        ArrayList<CompletionModelProvider.CompletionModel> models = new ArrayList<CompletionModelProvider.CompletionModel>();
        FileObject primaryFile = context.getPrimaryFile();
        ClassPath cp = ClassPath.getClassPath((FileObject)primaryFile, (String)"classpath/compile");
        if (cp == null) {
            return Collections.emptyList();
        }
        FileObject resource = cp.findResource("org.springframework.core.SpringVersion".replace('.', '/') + ".class");
        if (resource != null) {
            FileObject ownerRoot = cp.findOwnerRoot(resource);
            String version = this.findVersion(ownerRoot);
            if (version == null) {
                LOGGER.log(Level.WARNING, "Unknown version of Spring jars: ownerRoot={0}", ownerRoot);
                return Collections.emptyList();
            }
            LOGGER.log(Level.FINE, "Spring jars version={0}", version);
            if (this.declaredNamespaces == null) {
                this.declaredNamespaces = context.getDeclaredNamespaces();
            }
            Map<String, FileObject> map = new SpringIndex(primaryFile).getAllSpringLibraryDescriptors();
            for (String namespace : map.keySet()) {
                FileObject file;
                String fVersion;
                if (this.declaredNamespaces.containsValue(namespace) || !version.startsWith(fVersion = this.parseVersion(file = map.get(namespace)))) continue;
                ModelSource source = Utilities.getModelSource((FileObject)file, (boolean)true);
                SchemaModel model = SchemaModelFactory.getDefault().getModel(source);
                OpenTagCompletionModel completionModel = new OpenTagCompletionModel(this.generatePrefix(namespace), model);
                models.add(completionModel);
            }
            this.usedPrefixes.clear();
            return models;
        }
        return Collections.emptyList();
    }

    private String parseVersion(FileObject file) {
        String version = file.getName();
        version = version.substring(version.lastIndexOf("-") + 1);
        return version;
    }

    private String findVersion(FileObject ownerRoot) {
        try {
            if (ownerRoot != null && ownerRoot.getFileSystem() instanceof JarFileSystem) {
                JarFileSystem jarFileSystem = (JarFileSystem)ownerRoot.getFileSystem();
                return SpringUtilities.getImplementationVersion(jarFileSystem);
            }
        }
        catch (FileStateInvalidException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return null;
    }

    private String generatePrefix(String namespace) {
        String prefix = namespace.substring(namespace.lastIndexOf("/") + 1).toLowerCase();
        int i = 1;
        Object newPrefix = prefix;
        while (this.usedPrefixes.contains(newPrefix)) {
            newPrefix = prefix + i++;
        }
        this.usedPrefixes.add((String)newPrefix);
        return newPrefix;
    }

    public final class OpenTagCompletionModel
    extends CompletionModelProvider.CompletionModel {
        private final String prefix;
        private final SchemaModel model;

        public OpenTagCompletionModel(String prefix, SchemaModel model) {
            this.prefix = prefix;
            this.model = model;
            LOGGER.log(Level.FINE, "Created model: {0}:{1}", new Object[]{prefix, this.getTargetNamespace()});
        }

        public String getSuggestedPrefix() {
            return this.prefix;
        }

        public String getTargetNamespace() {
            Schema schema = this.model.getSchema();
            if (schema != null) {
                return schema.getTargetNamespace();
            }
            return null;
        }

        public SchemaModel getSchemaModel() {
            return this.model;
        }
    }
}

