/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.refactoring;

import java.io.CharConversionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.spring.api.beans.model.Location;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringBeanProperty;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.beans.editor.BeanClassFinder;
import org.netbeans.modules.spring.beans.editor.SpringXMLConfigEditorUtils;
import org.netbeans.modules.spring.beans.refactoring.AttributeFinder;
import org.netbeans.modules.spring.beans.refactoring.Occurrences;
import org.netbeans.modules.spring.beans.refactoring.PropertyChildFinder;
import org.netbeans.modules.spring.beans.refactoring.SpringRefactorings;
import org.netbeans.modules.spring.java.JavaUtils;
import org.netbeans.modules.spring.java.MatchType;
import org.netbeans.modules.spring.java.Property;
import org.netbeans.modules.spring.java.PropertyFinder;
import org.netbeans.modules.spring.java.PropertyType;
import org.netbeans.modules.xml.text.api.dom.XMLSyntaxSupport;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.xml.XMLUtil;

public class PropertyRefFinder {
    private final SpringConfigModel.DocumentAccess docAccess;
    private final XMLSyntaxSupport syntaxSupport;
    private final CompilationController cc;
    private final SpringRefactorings.RenamedProperty renamedProperty;

    public PropertyRefFinder(SpringConfigModel.DocumentAccess docAccess, CompilationController cc, SpringRefactorings.RenamedProperty renamedProperty) {
        this.docAccess = docAccess;
        BaseDocument document = (BaseDocument)docAccess.getDocument();
        this.syntaxSupport = XMLSyntaxSupport.getSyntaxSupport((Document)document);
        this.cc = cc;
        this.renamedProperty = renamedProperty;
    }

    public void addOccurrences(List<Occurrences.Occurrence> result) throws BadLocationException {
        Collection<ElementHandle<ExecutableElement>> methodHandles = this.renamedProperty.getMethodHandles();
        Collection<ExecutableElement> methods = JavaUtils.getMethodsFromHandles((CompilationInfo)this.cc, methodHandles);
        List<SpringBean> beans = this.docAccess.getSpringBeans().getFileBeans(this.docAccess.getFileObject()).getBeans();
        for (SpringBean bean : beans) {
            TypeElement beanTypeElement;
            String className;
            Set<SpringBeanProperty> properties = bean.getProperties();
            if (properties.isEmpty() || (className = new BeanClassFinder(bean, this.docAccess.getFileObject()).findImplementationClass(false)) == null || (beanTypeElement = JavaUtils.findClassElementByBinaryName(className, this.cc)) == null) continue;
            for (SpringBeanProperty property : properties) {
                this.processPropertyOccurrence(property, bean, beanTypeElement, methods, result);
            }
        }
    }

    private void processPropertyOccurrence(SpringBeanProperty property, SpringBean bean, TypeElement beanTypeElement, Collection<ExecutableElement> methods, List<Occurrences.Occurrence> result) throws BadLocationException {
        String propertyName = property.getName();
        if (this.renamedProperty.getType() == PropertyType.WRITE_ONLY && !propertyName.contains(".") && propertyName.equals(this.renamedProperty.getOldName())) {
            this.addSimpleSetterOccurrences(property, bean, beanTypeElement, methods, result);
            return;
        }
        if (propertyName.contains(" ")) {
            return;
        }
        String[] pathElements = propertyName.split("\\.");
        if (pathElements.length == 0) {
            return;
        }
        if (this.renamedProperty.getType() == PropertyType.WRITE_ONLY && pathElements[pathElements.length - 1].equals(this.renamedProperty.getOldName())) {
            this.addSetterInPathOccurrence(propertyName, pathElements, bean, beanTypeElement.asType(), methods, result);
            return;
        }
        if (this.renamedProperty.getType() == PropertyType.READ_ONLY) {
            for (String elem : pathElements) {
                if (!elem.equals(this.renamedProperty.getOldName())) continue;
                this.addGetterInPathOccurrences(propertyName, pathElements, bean, beanTypeElement.asType(), methods, result);
                return;
            }
        }
    }

    private void addSimpleSetterOccurrences(SpringBeanProperty property, SpringBean bean, TypeElement beanTypeElement, Collection<ExecutableElement> methods, List<Occurrences.Occurrence> result) throws BadLocationException {
        PositionRef endRef;
        PositionRef startRef;
        String displayText;
        LineDocument document;
        String prefix;
        if (beanTypeElement == null) {
            return;
        }
        PropertyFinder propertyFinder = new PropertyFinder(beanTypeElement.asType(), property.getName(), this.cc.getElementUtilities(), MatchType.EXACT);
        Property[] props = propertyFinder.findProperties();
        if (props == null || props.length == 0) {
            return;
        }
        ExecutableElement setter = props[0].getSetter();
        if (setter == null) {
            return;
        }
        if (!this.isSameOrOverrides(setter, methods)) {
            return;
        }
        Location loc = bean.getLocation();
        if (loc == null) {
            return;
        }
        int beanOffset = loc.getOffset();
        if (beanOffset == -1) {
            return;
        }
        PropertyChildFinder finder = new PropertyChildFinder(this.syntaxSupport, beanOffset);
        String name = property.getName();
        if (finder.find(name)) {
            int foundOffset = finder.getFoundOffset();
            String foundValue = finder.getValue();
            int index = foundValue.indexOf(name);
            if (index != -1) {
                String displayText2 = this.createPropertyChildDisplayText(foundValue, index, name.length());
                PositionRef startRef2 = this.docAccess.createPositionRef(foundOffset + index, Position.Bias.Forward);
                PositionRef endRef2 = this.docAccess.createPositionRef(foundOffset + index + name.length(), Position.Bias.Backward);
                result.add(new PropertyRefOccurrence(displayText2, this.docAccess.getFileObject(), new PositionBounds(startRef2, endRef2)));
            }
        }
        if ((prefix = SpringXMLConfigEditorUtils.getPNamespacePrefix((Document)(document = this.syntaxSupport.getDocument()), beanOffset)) == null) {
            return;
        }
        AttributeFinder attribFinder = new AttributeFinder(this.syntaxSupport, beanOffset);
        String attribName = prefix + ":" + name;
        if (attribFinder.find(attribName)) {
            int foundOffset = attribFinder.getFoundOffset();
            int index = attribName.indexOf(name);
            if (index != -1) {
                displayText = this.createPropertyAttributeDisplayText(attribName, index, name.length());
                startRef = this.docAccess.createPositionRef(foundOffset + index, Position.Bias.Forward);
                endRef = this.docAccess.createPositionRef(foundOffset + index + name.length(), Position.Bias.Backward);
                result.add(new PropertyRefOccurrence(displayText, this.docAccess.getFileObject(), new PositionBounds(startRef, endRef)));
            }
        }
        if (attribFinder.find(attribName = attribName + "-ref")) {
            int foundOffset = attribFinder.getFoundOffset();
            int index = attribName.indexOf(name);
            if (index != -1) {
                displayText = this.createPropertyAttributeDisplayText(attribName, index, name.length());
                startRef = this.docAccess.createPositionRef(foundOffset + index, Position.Bias.Forward);
                endRef = this.docAccess.createPositionRef(foundOffset + index + name.length(), Position.Bias.Backward);
                result.add(new PropertyRefOccurrence(displayText, this.docAccess.getFileObject(), new PositionBounds(startRef, endRef)));
            }
        }
    }

    private void addSetterInPathOccurrence(String propertyPath, String[] pathTokens, SpringBean bean, TypeMirror beanType, Collection<ExecutableElement> methods, List<Occurrences.Occurrence> result) throws BadLocationException {
        Location loc = bean.getLocation();
        if (loc == null) {
            return;
        }
        int beanOffset = loc.getOffset();
        if (beanOffset == -1) {
            return;
        }
        PropertyChildFinder finder = new PropertyChildFinder(this.syntaxSupport, beanOffset);
        if (!finder.find(propertyPath)) {
            return;
        }
        int foundOffset = finder.getFoundOffset();
        String foundValue = finder.getValue();
        int index = foundValue.indexOf(propertyPath);
        if (index == -1) {
            return;
        }
        PropertyPathElement[] pathElements = this.evaluatePropertyPath(this.cc.getElementUtilities(), beanType, pathTokens);
        if (pathElements.length <= 1) {
            return;
        }
        PropertyPathElement setterElement = pathElements[pathElements.length - 1];
        if (!this.isSameOrOverrides(setterElement.getProperty().getSetter(), methods)) {
            return;
        }
        String displayText = this.createPropertyChildDisplayText(foundValue, index + setterElement.getStartIndex(), setterElement.getEndIndex() - setterElement.getStartIndex());
        PositionRef startRef = this.docAccess.createPositionRef(foundOffset + index + setterElement.getStartIndex(), Position.Bias.Forward);
        PositionRef endRef = this.docAccess.createPositionRef(foundOffset + index + setterElement.getEndIndex(), Position.Bias.Backward);
        result.add(new PropertyRefOccurrence(displayText, this.docAccess.getFileObject(), new PositionBounds(startRef, endRef)));
    }

    private boolean isSameOrOverrides(ExecutableElement m1, Collection<ExecutableElement> methods) {
        for (ExecutableElement method : methods) {
            if (!m1.equals(method) && !this.cc.getElements().overrides(m1, method, (TypeElement)m1.getEnclosingElement())) continue;
            return true;
        }
        return false;
    }

    private void addGetterInPathOccurrences(String propertyPath, String[] pathTokens, SpringBean bean, TypeMirror beanType, Collection<ExecutableElement> methods, List<Occurrences.Occurrence> result) throws BadLocationException {
        Location loc = bean.getLocation();
        if (loc == null) {
            return;
        }
        int beanOffset = loc.getOffset();
        if (beanOffset == -1) {
            return;
        }
        PropertyChildFinder finder = new PropertyChildFinder(this.syntaxSupport, beanOffset);
        if (!finder.find(propertyPath)) {
            return;
        }
        int foundOffset = finder.getFoundOffset();
        String foundValue = finder.getValue();
        int index = foundValue.indexOf(propertyPath);
        if (index == -1) {
            return;
        }
        PropertyPathElement[] pathElements = this.evaluatePropertyPath(this.cc.getElementUtilities(), beanType, pathTokens);
        if (pathElements.length <= 1) {
            return;
        }
        for (int i = 0; i < pathElements.length - 1; ++i) {
            PropertyPathElement pathElement = pathElements[i];
            if (!this.isSameOrOverrides(pathElement.getProperty().getSetter(), methods)) {
                return;
            }
            String displayText = this.createPropertyChildDisplayText(foundValue, index + pathElement.getStartIndex(), pathElement.getEndIndex() - pathElement.getStartIndex());
            PositionRef startRef = this.docAccess.createPositionRef(foundOffset + index + pathElement.getStartIndex(), Position.Bias.Forward);
            PositionRef endRef = this.docAccess.createPositionRef(foundOffset + index + pathElement.getEndIndex(), Position.Bias.Backward);
            result.add(new PropertyRefOccurrence(displayText, this.docAccess.getFileObject(), new PositionBounds(startRef, endRef)));
        }
    }

    private String createPropertyChildDisplayText(String attrValue, int matchIndex, int matchLength) throws BadLocationException {
        StringBuilder builder = new StringBuilder();
        builder.append("&lt;property");
        String beforeMatch = this.escapeAttrValue(attrValue.substring(0, matchIndex));
        String match = this.escapeAttrValue(attrValue.substring(matchIndex, matchIndex + matchLength));
        String afterMatch = this.escapeAttrValue(attrValue.substring(matchIndex + matchLength));
        if (beforeMatch != null && match != null && afterMatch != null) {
            builder.append(" name=");
            builder.append(beforeMatch).append("<b>").append(match).append("</b>").append(afterMatch);
        }
        return builder.toString();
    }

    private String createPropertyAttributeDisplayText(String attr, int matchIndex, int matchLength) throws BadLocationException {
        StringBuilder builder = new StringBuilder();
        String beforeMatch = attr.substring(0, matchIndex);
        String match = attr.substring(matchIndex, matchIndex + matchLength);
        String afterMatch = this.escapeAttrValue(attr.substring(matchIndex + matchLength));
        if (beforeMatch != null && match != null && afterMatch != null) {
            builder.append(beforeMatch).append("<b>").append(match).append("</b>").append(afterMatch);
        }
        return builder.toString();
    }

    private String escapeAttrValue(String attrValue) {
        try {
            return XMLUtil.toAttributeValue((String)attrValue);
        }
        catch (CharConversionException e) {
            return null;
        }
    }

    private PropertyPathElement[] evaluatePropertyPath(ElementUtilities eu, TypeMirror startType, String[] pathElements) {
        ArrayList<PropertyPathElement> result = new ArrayList<PropertyPathElement>(pathElements.length);
        int currPos = 0;
        TypeMirror type = startType;
        for (int i = 0; i < pathElements.length; ++i) {
            if (type == null) {
                return new PropertyPathElement[0];
            }
            Property[] property = new PropertyFinder(type, pathElements[i], eu, MatchType.EXACT).findProperties();
            if (property != null && property.length > 0) {
                result.add(new PropertyPathElement(property[0], currPos, currPos + pathElements[i].length()));
                type = property[0].getImplementationType();
                currPos += pathElements[i].length() + 1;
                continue;
            }
            return new PropertyPathElement[0];
        }
        return result.toArray(new PropertyPathElement[0]);
    }

    private static final class PropertyPathElement {
        private final Property property;
        private final int startOffset;
        private final int endOffset;

        public PropertyPathElement(Property property, int startOffset, int endOffset) {
            this.property = property;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public Property getProperty() {
            return this.property;
        }

        public int getStartIndex() {
            return this.startOffset;
        }

        public int getEndIndex() {
            return this.endOffset;
        }
    }

    private static final class PropertyRefOccurrence
    extends Occurrences.Occurrence {
        private final String displayText;

        PropertyRefOccurrence(String displayText, FileObject fo, PositionBounds bounds) {
            super(fo, bounds);
            this.displayText = displayText;
        }

        @Override
        public String getDisplayText() {
            return this.displayText;
        }
    }
}

