/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.problems;

import java.awt.Dialog;
import java.awt.GraphicsEnvironment;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.problems.BrokenReferencesAlertPanel;
import org.netbeans.modules.project.ui.problems.BrokenReferencesCustomizer;
import org.netbeans.modules.project.ui.problems.BrokenReferencesModel;
import org.netbeans.modules.project.ui.problems.BrokenReferencesSettings;
import org.netbeans.modules.project.ui.problems.Bundle;
import org.netbeans.spi.project.ui.ProjectProblemsImplementation;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class BrokenReferencesImpl
implements ProjectProblemsImplementation {
    private static final boolean suppressBrokenRefAlert = Boolean.getBoolean("BrokenReferencesSupport.suppressBrokenRefAlert");
    private static final RequestProcessor RP = new RequestProcessor(BrokenReferencesImpl.class);
    private static int BROKEN_ALERT_TIMEOUT = 1000;
    private BrokenReferencesModel.Context context;
    private RequestProcessor.Task rpTask;
    private CompletableFuture<Void> runningFuture;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> showAlert(Project project) {
        RequestProcessor.Task t;
        CompletableFuture<Void> result;
        BrokenReferencesModel.Context ctx;
        Parameters.notNull((CharSequence)"project", (Object)project);
        if (!BrokenReferencesSettings.isShowAgainBrokenRefAlert() || suppressBrokenRefAlert) {
            return CompletableFuture.completedFuture(null);
        }
        BrokenReferencesImpl brokenReferencesImpl = this;
        synchronized (brokenReferencesImpl) {
            if (this.context == null) {
                assert (this.rpTask == null);
                final Runnable task = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        BrokenReferencesModel.Context ctx;
                        CompletableFuture<Void> res = null;
                        BrokenReferencesImpl brokenReferencesImpl = BrokenReferencesImpl.this;
                        synchronized (brokenReferencesImpl) {
                            BrokenReferencesImpl.this.rpTask = null;
                            ctx = BrokenReferencesImpl.this.context;
                            if (ctx == null) {
                                res = BrokenReferencesImpl.this.runningFuture;
                                BrokenReferencesImpl.this.runningFuture = null;
                            }
                        }
                        if (res != null) {
                            res.complete(null);
                            return;
                        }
                        try {
                            final JButton resolveOption = new JButton(Bundle.CTL_Broken_References_Resolve());
                            resolveOption.getAccessibleContext().setAccessibleDescription(Bundle.AD_Broken_References_Resolve());
                            JButton closeOption = new JButton(Bundle.CTL_Broken_References_Close());
                            closeOption.getAccessibleContext().setAccessibleDescription(Bundle.AD_Broken_References_Close());
                            DialogDescriptor dd = new DialogDescriptor((Object)new BrokenReferencesAlertPanel(), Bundle.MSG_Broken_References_Title(), true, new Object[]{resolveOption, closeOption}, (Object)closeOption, 0, null, null);
                            dd.setMessageType(2);
                            ctx.addChangeListener(new ChangeListener(){

                                @Override
                                public void stateChanged(ChangeEvent e) {
                                    resolveOption.setVisible(!ctx.isEmpty());
                                }
                            });
                            resolveOption.setVisible(!ctx.isEmpty());
                            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == resolveOption) {
                                BrokenReferencesModel model = new BrokenReferencesModel(ctx, true);
                                if (GraphicsEnvironment.isHeadless()) {
                                    BrokenReferencesImpl.this.fixAllProblems(model, new HashSet<BrokenReferencesModel.ProblemReference>());
                                    return;
                                }
                                BrokenReferencesCustomizer customizer = new BrokenReferencesCustomizer(model);
                                JButton close = new JButton(Bundle.LBL_Broken_References_Resolve_Panel_Close());
                                close.getAccessibleContext().setAccessibleDescription(Bundle.AD_Broken_References_Resolve_Panel_Close());
                                dd = new DialogDescriptor((Object)customizer, Bundle.LBL_Broken_References_Resolve_Panel_Title(), true, new Object[]{closeOption}, (Object)closeOption, 0, null, null);
                                customizer.setNotificationLineSupport(dd.createNotificationLineSupport());
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                            }
                        }
                        finally {
                            BrokenReferencesImpl brokenReferencesImpl2 = BrokenReferencesImpl.this;
                            synchronized (brokenReferencesImpl2) {
                                BrokenReferencesImpl.this.context = null;
                                res = BrokenReferencesImpl.this.runningFuture;
                                BrokenReferencesImpl.this.runningFuture = null;
                            }
                            res.complete(null);
                        }
                    }
                };
                this.context = new BrokenReferencesModel.Context();
                this.rpTask = RP.create(new Runnable(){

                    @Override
                    public void run() {
                        if (GraphicsEnvironment.isHeadless()) {
                            task.run();
                        } else {
                            WindowManager.getDefault().invokeWhenUIReady(task);
                        }
                    }
                });
                this.runningFuture = new CompletableFuture();
                return this.runningFuture;
            }
            ctx = this.context;
            result = this.runningFuture;
            t = this.rpTask;
        }
        assert (ctx != null);
        assert (result != null);
        if (project != null) {
            ctx.offer(project);
        }
        if (t != null) {
            t.schedule(BROKEN_ALERT_TIMEOUT);
        }
        return result;
    }

    private void fixAllProblems(BrokenReferencesModel model, Collection<BrokenReferencesModel.ProblemReference> seen) {
        model.refresh();
        for (int i = 0; i < model.getSize(); ++i) {
            Object value = model.getElementAt(i);
            if (!(value instanceof BrokenReferencesModel.ProblemReference)) {
                return;
            }
            BrokenReferencesModel.ProblemReference or = (BrokenReferencesModel.ProblemReference)value;
            if (or.resolved || seen.contains(or)) continue;
            BrokenReferencesCustomizer.performProblemFix(or, result -> {
                seen.add(or);
                String msg = result.getMessage();
                if (msg != null) {
                    int importance = result.isResolved() ? 0 : 700;
                    StatusDisplayer.getDefault().setStatusText(msg, importance);
                } else if (!result.isResolved()) {
                    StatusDisplayer.getDefault().setStatusText(Bundle.ERROR_ProblemResolutionFailed(or.getDisplayName()), 700);
                }
                this.fixAllProblems(model, seen);
            });
            break;
        }
    }

    public CompletableFuture<Void> showCustomizer(@NonNull Project project) {
        final CompletableFuture<Void> result = new CompletableFuture<Void>();
        Parameters.notNull((CharSequence)"project", (Object)project);
        BrokenReferencesModel model = new BrokenReferencesModel(project);
        BrokenReferencesCustomizer customizer = new BrokenReferencesCustomizer(model);
        JButton close = new JButton(Bundle.LBL_BrokenLinksCustomizer_Close());
        close.getAccessibleContext().setAccessibleDescription(Bundle.ACSD_BrokenLinksCustomizer_Close());
        String projectDisplayName = ProjectUtils.getInformation((Project)project).getDisplayName();
        final DialogDescriptor dd = new DialogDescriptor((Object)customizer, Bundle.LBL_BrokenLinksCustomizer_Title(projectDisplayName), true, new Object[]{close}, (Object)close, 0, null, null);
        customizer.setNotificationLineSupport(dd.createNotificationLineSupport());
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Dialog dlg = null;
                try {
                    dlg = DialogDisplayer.getDefault().createDialog(dd);
                    if (SwingUtilities.isEventDispatchThread()) {
                        dlg.setVisible(true);
                    }
                }
                catch (RuntimeException ex) {
                    result.completeExceptionally(ex);
                }
                finally {
                    if (dlg != null) {
                        dlg.dispose();
                    }
                    result.complete(null);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
        return result;
    }
}

