/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.project.ui.Bundle;
import org.netbeans.modules.project.ui.ProjectUtilities;
import org.netbeans.modules.project.ui.SimpleTargetChooserPanelGUI;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;

final class SimpleTargetChooserPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
ChangeListener {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private SimpleTargetChooserPanelGUI gui;
    private boolean includesTemplatesWithProject = true;
    @NullAllowed
    private Project project;
    @NonNull
    private SourceGroup[] folders;
    private WizardDescriptor.Panel<WizardDescriptor> bottomPanel;
    private WizardDescriptor wizard;
    private boolean isFolder;
    private boolean freeFileExtension;
    private FileSystem fs;

    SimpleTargetChooserPanel(@NullAllowed Project project, @NonNull SourceGroup[] folders, WizardDescriptor.Panel<WizardDescriptor> bottomPanel, boolean isFolder, boolean freeFileExtension) {
        this.folders = folders;
        this.project = project;
        this.bottomPanel = bottomPanel;
        if (bottomPanel != null) {
            bottomPanel.addChangeListener((ChangeListener)this);
        }
        this.isFolder = isFolder;
        this.freeFileExtension = freeFileExtension;
        this.gui = null;
    }

    public Component getComponent() {
        if (this.noProjectFolders()) {
            return new JPanel();
        }
        if (this.gui == null) {
            this.gui = new SimpleTargetChooserPanelGUI(this.project, this.folders, this.bottomPanel == null ? null : this.bottomPanel.getComponent(), this.isFolder, this.freeFileExtension);
            this.gui.addChangeListener(this);
        }
        return this.gui;
    }

    private boolean noProjectFolders() {
        return this.project != null && this.folders != null && this.folders.length == 0;
    }

    public HelpCtx getHelp() {
        HelpCtx bottomHelp;
        if (this.bottomPanel != null && (bottomHelp = this.bottomPanel.getHelp()) != null) {
            return bottomHelp;
        }
        return null;
    }

    public boolean isValid() {
        String targetFolder;
        FileObject rootFolder;
        boolean ok;
        if (this.noProjectFolders()) {
            return false;
        }
        boolean bl = ok = this.gui != null && this.gui.getTargetName() != null && (this.bottomPanel == null || this.bottomPanel.isValid());
        if (!ok) {
            return false;
        }
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wizard);
        assert (template != null) : "Null template in wizard:" + this.wizard.getClass().getName() + ", prop WIZARD_KEY_TEMPLATE:" + this.wizard.getProperty("targetTemplate") + ", thread:" + Thread.currentThread().getName();
        if (this.gui.getTargetGroup() != null) {
            rootFolder = this.gui.getTargetGroup().getRootFolder();
            targetFolder = this.gui.getTargetFolder();
        } else if (this.gui.getTargetFolder() != null) {
            rootFolder = this.fs == null ? FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(this.gui.getTargetFolder()))) : this.fs.getRoot();
            targetFolder = this.fs == null ? "" : this.gui.getTargetFolder();
        } else {
            rootFolder = null;
            targetFolder = null;
        }
        String errorMessage = ProjectUtilities.canUseFileName(rootFolder, targetFolder, this.gui.getTargetName(), template.getExt(), this.isFolder, this.freeFileExtension);
        this.wizard.putProperty("WizardPanel_errorMessage", (Object)errorMessage);
        return errorMessage == null;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public void readSettings(WizardDescriptor settings) {
        Object substitute;
        FileObject preselectedTarget;
        Boolean b = (Boolean)settings.getProperty("INCLUDES_TEMPLATES_WITH_PROJECTS");
        if (b != null && b.equals(Boolean.FALSE)) {
            this.includesTemplatesWithProject = false;
        }
        this.wizard = settings;
        if (this.noProjectFolders()) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)Bundle.SimpleTargetChooserPanelGUI_no_source_folders());
            return;
        }
        if (this.gui == null) {
            this.getComponent();
        }
        if ((preselectedTarget = Templates.getTargetFolder((WizardDescriptor)this.wizard)) == null) {
            if (this.project != null) {
                preselectedTarget = this.project.getProjectDirectory();
            } else {
                String home = System.getProperty("user.home");
                if (home != null && new File(home).isDirectory()) {
                    preselectedTarget = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(home)));
                }
            }
        }
        String targetName = this.isFolder ? null : Templates.getTargetName((WizardDescriptor)this.wizard);
        this.gui.initValues(Templates.getTemplate((WizardDescriptor)this.wizard), preselectedTarget, targetName, this.includesTemplatesWithProject);
        if (preselectedTarget != null && FileUtil.toFile((FileObject)preselectedTarget) == null) {
            try {
                this.fs = preselectedTarget.getFileSystem();
            }
            catch (FileStateInvalidException ex) {
                this.fs = null;
            }
        }
        if ((substitute = this.gui.getClientProperty("NewFileWizard_Title")) != null) {
            this.wizard.putProperty("NewFileWizard_Title", substitute);
        }
        this.wizard.putProperty("WizardPanel_contentData", (Object)new String[]{Bundle.LBL_TemplatesPanel_Name(), Bundle.LBL_SimpleTargetChooserPanel_Name()});
        if (this.bottomPanel != null) {
            this.bottomPanel.readSettings((Object)settings);
        }
    }

    public void storeSettings(WizardDescriptor settings) {
        if (this.noProjectFolders()) {
            return;
        }
        if (WizardDescriptor.PREVIOUS_OPTION.equals(settings.getValue())) {
            return;
        }
        if (!WizardDescriptor.CANCEL_OPTION.equals(settings.getValue()) && !WizardDescriptor.CLOSED_OPTION.equals(settings.getValue()) && this.isValid()) {
            String name;
            if (this.bottomPanel != null) {
                this.bottomPanel.storeSettings((Object)settings);
            }
            if (this.gui == null) {
                this.getComponent();
            }
            if ((name = this.gui.getTargetName()) != null && name.indexOf(47) > 0) {
                name = name.substring(name.lastIndexOf(47) + 1);
            }
            Templates.setTargetFolder((WizardDescriptor)settings, (FileObject)this.getTargetFolderFromGUI());
            Templates.setTargetName((WizardDescriptor)settings, (String)name);
        }
        settings.putProperty("NewFileWizard_Title", null);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.changeSupport.fireChange();
    }

    private FileObject getTargetFolderFromGUI() {
        FileObject targetFolder;
        String folderName;
        FileObject rootFolder;
        if (this.gui.getTargetGroup() != null) {
            rootFolder = this.gui.getTargetGroup().getRootFolder();
            folderName = this.gui.getTargetFolder();
        } else if (this.gui.getTargetFolder() != null) {
            rootFolder = this.fs == null ? FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(this.gui.getTargetFolder()))) : this.fs.getRoot();
            folderName = this.fs == null ? "" : this.gui.getTargetFolder();
        } else {
            rootFolder = null;
            folderName = null;
        }
        String newObject = this.gui.getTargetName();
        if (newObject.indexOf(47) > 0) {
            String path = newObject.substring(0, newObject.lastIndexOf(47));
            folderName = folderName == null || "".equals(folderName) ? path : folderName + "/" + path;
        }
        if ((targetFolder = folderName == null ? rootFolder : rootFolder.getFileObject(folderName)) == null) {
            try {
                targetFolder = FileUtil.createFolder((FileObject)rootFolder, (String)folderName);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException(ioe);
            }
        }
        return targetFolder;
    }
}

