/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.dependency.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.actions.Savable;
import org.netbeans.api.editor.document.AtomicLockDocument;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lsp.TextDocumentEdit;
import org.netbeans.api.lsp.TextEdit;
import org.netbeans.modules.project.dependency.impl.Bundle;
import org.netbeans.modules.project.dependency.impl.ProjectModificationResultImpl;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;

public class TextDocumentEditProcessor {
    private final TextDocumentEdit edits;
    private boolean saveAfterEdit;
    private boolean forkDocument;
    private FileObject targetFile;
    private EditorCookie editor;
    private LineDocument document;

    public TextDocumentEditProcessor(TextDocumentEdit edits) {
        this.edits = edits;
    }

    public boolean isForkDocument() {
        return this.forkDocument;
    }

    TextDocumentEditProcessor setForkDocument(boolean forkDocument) {
        this.forkDocument = forkDocument;
        return this;
    }

    public boolean isSaveAfterEdit() {
        return this.saveAfterEdit;
    }

    public TextDocumentEditProcessor setSaveAfterEdit(boolean saveAfterEdit) {
        this.saveAfterEdit = saveAfterEdit;
        return this;
    }

    public FileObject getTargetFile() {
        return this.targetFile;
    }

    private void open() throws IOException {
        FileObject fo = ProjectModificationResultImpl.fromString(this.edits.getDocument());
        if (fo == null || !fo.isValid()) {
            throw new FileNotFoundException(this.edits.getDocument());
        }
        this.editor = (EditorCookie)fo.getLookup().lookup(EditorCookie.class);
        if (this.editor == null || !fo.canWrite()) {
            throw new IOException(Bundle.ERR_FileNotEditable(this.edits.getDocument()));
        }
        this.targetFile = fo;
        StyledDocument doc = this.editor.openDocument();
        if (this.isForkDocument()) {
            String mime = (String)doc.getProperty("mimeType");
            LineDocument forked = LineDocumentUtils.createDocument((String)(mime != null ? mime : "text/plain"));
            BadLocationException[] err = new BadLocationException[1];
            StyledDocument fDoc = doc;
            fDoc.render(() -> TextDocumentEditProcessor.lambda$open$0((Document)forked, fDoc, err));
            if (err[0] != null) {
                throw new IOException(Bundle.ERR_FailedToEditDocument(this.edits.getDocument()), err[0]);
            }
            doc = forked;
        }
        this.document = (LineDocument)LineDocumentUtils.asRequired((Document)doc, LineDocument.class);
    }

    public String getText() throws IOException {
        String[] text = new String[1];
        BadLocationException[] err = new BadLocationException[1];
        this.document.render(() -> {
            try {
                text[0] = this.document.getText(0, this.document.getLength());
            }
            catch (BadLocationException ex) {
                err[0] = ex;
            }
        });
        if (err[0] != null) {
            throw new IOException(err[0]);
        }
        return text[0];
    }

    public TextDocumentEditProcessor execute() throws IOException {
        this.open();
        BadLocationException[] err = new BadLocationException[1];
        ((AtomicLockDocument)LineDocumentUtils.asRequired((Document)this.document, AtomicLockDocument.class)).runAtomicAsUser(() -> {
            try {
                this.performEdits();
            }
            catch (BadLocationException ex) {
                err[0] = ex;
            }
        });
        if (err[0] != null) {
            throw new IOException(Bundle.ERR_FailedToEditDocument(this.edits.getDocument()));
        }
        if (this.isSaveAfterEdit() && !this.isForkDocument()) {
            Savable ss = (Savable)this.targetFile.getLookup().lookup(Savable.class);
            ss.save();
        }
        return this;
    }

    public Document getDocument() {
        return this.document;
    }

    public void performEdits() throws BadLocationException {
        ArrayList newEdits = new ArrayList(this.edits.getEdits());
        Collections.sort(newEdits, ProjectModificationResultImpl.textEditComparator(this.edits.getEdits()).reversed());
        for (TextEdit te : this.edits.getEdits()) {
            int s = te.getStartOffset();
            int e = te.getEndOffset();
            if (te.getNewText() != null && !te.getNewText().isEmpty()) {
                this.document.insertString(e, te.getNewText(), null);
            }
            if (e <= s) continue;
            this.document.remove(s, e - s);
        }
    }

    private static /* synthetic */ void lambda$open$0(Document forked, Document fDoc, BadLocationException[] err) {
        try {
            forked.insertString(0, fDoc.getText(0, fDoc.getLength()), null);
        }
        catch (BadLocationException ex) {
            err[0] = ex;
        }
    }
}

