/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.dependency.impl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.lsp.ResourceOperation;
import org.netbeans.api.lsp.TextDocumentEdit;
import org.netbeans.api.lsp.TextEdit;
import org.netbeans.api.lsp.WorkspaceEdit;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.dependency.ProjectOperationException;
import org.netbeans.modules.project.dependency.impl.Bundle;
import org.netbeans.modules.project.dependency.impl.CompoundModificationResult;
import org.netbeans.modules.project.dependency.spi.ProjectDependencyModifier;
import org.netbeans.modules.refactoring.spi.ModificationResult;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Union2;

public class ProjectModificationResultImpl {
    private final Project project;
    private Set<FileObject> toSave = new LinkedHashSet<FileObject>();
    private List<ModificationResult> customModifications = new ArrayList<ModificationResult>();
    private List<Union2<TextDocumentEdit, ResourceOperation>> edits;
    private ModificationResult combinedResult;
    Map<FileObject, ResourceOperation.CreateFile> createFiles = new HashMap<FileObject, ResourceOperation.CreateFile>();
    Map<FileObject, TextDocumentEdit> fileModifications = new LinkedHashMap<FileObject, TextDocumentEdit>();

    public ProjectModificationResultImpl(Project project) {
        this.project = project;
    }

    public TextDocumentEdit getFileEdit(FileObject file) {
        return this.fileModifications.get(file);
    }

    List<Union2<TextDocumentEdit, ResourceOperation>> edits() {
        if (this.edits != null) {
            return this.edits;
        }
        ArrayList<Union2<TextDocumentEdit, ResourceOperation>> r = new ArrayList<Union2<TextDocumentEdit, ResourceOperation>>();
        for (FileObject f : this.fileModifications.keySet()) {
            if (f.isVirtual()) {
                r.add((Union2<TextDocumentEdit, ResourceOperation>)Union2.createSecond((Object)((ResourceOperation)this.createFiles.get(f))));
                continue;
            }
            TextDocumentEdit te = this.fileModifications.get(f);
            r.add((Union2<TextDocumentEdit, ResourceOperation>)Union2.createFirst((Object)te));
        }
        this.edits = r;
        return r;
    }

    public WorkspaceEdit getWorkspaceEdit() {
        return new WorkspaceEdit(this.edits());
    }

    public void add(ProjectDependencyModifier.Result r) {
        boolean saveAll;
        if (r.getWorkspaceEdit() == null) {
            return;
        }
        Collection<FileObject> save = r.requiresSave();
        boolean bl = saveAll = save == ProjectDependencyModifier.Result.SAVE_ALL;
        if (save != null && !saveAll) {
            this.toSave.addAll(save);
        }
        for (Union2 op : r.getWorkspaceEdit().getDocumentChanges()) {
            if (op.hasSecond()) {
                this.addResourceOperation((ResourceOperation)op.second());
                continue;
            }
            if (!op.hasFirst()) continue;
            this.addTextOperation((TextDocumentEdit)op.first(), saveAll);
        }
    }

    static FileObject fromString(String s) {
        URL asURL;
        try {
            asURL = new URL(s);
            asURL = new URL(asURL, ".");
        }
        catch (MalformedURLException ex) {
            asURL = null;
        }
        int i = s.lastIndexOf("/");
        while (i >= 0) {
            block10: {
                if (asURL != null) {
                    FileObject fo = URLMapper.findFileObject((URL)asURL);
                    if (fo != null) {
                        return fo.getFileObject(s.substring(i + 1), false);
                    }
                    try {
                        URL n;
                        asURL = n = new URL(asURL, "..");
                        break block10;
                    }
                    catch (MalformedURLException ex) {
                        break;
                    }
                }
                try {
                    Path p = Paths.get(s.substring(0, i), new String[0]);
                    FileObject fo = FileUtil.toFileObject((File)p.toFile());
                    if (fo != null) {
                        return fo.getFileObject(s.substring(i + 1), false);
                    }
                }
                catch (IllegalArgumentException ex) {
                    return null;
                }
            }
            i = s.lastIndexOf("/", i - 1);
        }
        return null;
    }

    private void addResourceOperation(ResourceOperation op) {
        if (op instanceof ResourceOperation.CreateFile) {
            ResourceOperation.CreateFile cf = (ResourceOperation.CreateFile)op;
            FileObject fo = ProjectModificationResultImpl.fromString(cf.getNewFile());
            if (fo == null) {
                throw new ProjectOperationException(this.project, ProjectOperationException.State.ERROR, Bundle.ERR_UnsupportedFileSpec(cf.getNewFile()), Collections.emptySet());
            }
            if (this.createFiles.containsKey(fo)) {
                this.fileModifications.remove(fo);
            } else {
                this.createFiles.put(fo, cf);
            }
            return;
        }
        throw new IllegalStateException("Unknown resource operation");
    }

    static Comparator<TextEdit> textEditComparator(final List<TextEdit> edits) {
        return new Comparator<TextEdit>(){

            @Override
            public int compare(TextEdit o1, TextEdit o2) {
                int p2;
                int p1 = o1.getStartOffset();
                int diff = p1 - (p2 = o1.getStartOffset());
                if (diff != 0) {
                    return diff;
                }
                return edits.indexOf(o1) - edits.indexOf(o2);
            }
        };
    }

    public Collection<FileObject> getFilesToSave() {
        return this.toSave;
    }

    private void addTextOperation(TextDocumentEdit edit, boolean saveAll) {
        FileObject fo = ProjectModificationResultImpl.fromString(edit.getDocument());
        if (fo == null) {
            throw new ProjectOperationException(this.project, ProjectOperationException.State.ERROR, Bundle.ERR_UnsupportedFileSpec(edit.getDocument()), Collections.emptySet());
        }
        if (!fo.isValid() && !this.createFiles.containsKey(fo)) {
            throw new ProjectOperationException(this.project, ProjectOperationException.State.ERROR, Bundle.ERR_WritingToMissingFile(edit.getDocument()), Collections.emptySet());
        }
        if (saveAll) {
            this.toSave.add(fo);
        }
        TextDocumentEdit tde = this.fileModifications.get(fo);
        ArrayList newEdits = new ArrayList(edit.getEdits());
        Collections.sort(newEdits, ProjectModificationResultImpl.textEditComparator(edit.getEdits()));
        if (tde != null) {
            List existing = tde.getEdits();
            int pos = 0;
            for (TextEdit e : newEdits) {
                TextEdit c;
                if (pos >= existing.size()) {
                    existing.add(e);
                    ++pos;
                    continue;
                }
                while (pos < existing.size() && (c = (TextEdit)existing.get(pos)).getStartOffset() <= e.getStartOffset()) {
                    if (c.getEndOffset() > e.getStartOffset()) {
                        throw new ProjectOperationException(this.project, ProjectOperationException.State.ERROR, Bundle.ERR_EditsOverlap(edit.getDocument()), Collections.emptySet());
                    }
                    ++pos;
                }
                existing.add(pos, e);
                if (pos != existing.size() - 1) continue;
                ++pos;
            }
        } else {
            this.fileModifications.put(fo, new TextDocumentEdit(URLMapper.findURL((FileObject)fo, (int)1).toString(), newEdits));
        }
    }

    public boolean hasCustomEdits() {
        return !this.customModifications.isEmpty();
    }

    public List<Union2<TextDocumentEdit, ResourceOperation>> getEdits() {
        return this.edits();
    }

    public List<ModificationResult> getCustomModifications() {
        return this.customModifications;
    }

    public ModificationResult getCustomEdit() {
        if (this.customModifications.isEmpty()) {
            return null;
        }
        if (this.combinedResult != null) {
            return this.combinedResult;
        }
        this.combinedResult = new CompoundModificationResult(this.customModifications);
        return this.combinedResult;
    }
}

