/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.features;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.swing.ActionPopupButton;
import org.netbeans.lib.profiler.ui.swing.GrayLabel;
import org.netbeans.lib.profiler.ui.threads.ThreadsPanel;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.v2.features.Bundle;
import org.netbeans.modules.profiler.v2.features.FeatureUI;

abstract class ThreadsFeatureUI
extends FeatureUI {
    private ProfilerToolbar toolbar;
    private ThreadsPanel threadsView;
    private JLabel shLabel;
    private ActionPopupButton shFilter;
    private JLabel tlLabel;
    private JComponent tlZoomInButton;
    private JComponent tlZoomOutButton;
    private JComponent tlFitWidthButton;

    ThreadsFeatureUI() {
    }

    abstract Profiler getProfiler();

    @Override
    ProfilerToolbar getToolbar() {
        if (this.toolbar == null) {
            this.initUI();
        }
        return this.toolbar;
    }

    @Override
    JPanel getResultsUI() {
        if (this.threadsView == null) {
            this.initUI();
        }
        return this.threadsView;
    }

    void cleanup() {
        if (this.threadsView != null) {
            this.threadsView.cleanup();
        }
    }

    @Override
    void sessionStateChanged(int sessionState) {
        this.refreshToolbar(sessionState);
        if (sessionState == 1 || sessionState == 128) {
            if (this.threadsView != null) {
                this.threadsView.profilingSessionFinished();
            }
        } else if (sessionState == 4 && this.threadsView != null) {
            this.threadsView.profilingSessionStarted();
        }
    }

    private void initUI() {
        assert (SwingUtilities.isEventDispatchThread());
        this.threadsView = new ThreadsPanel(this.getProfiler().getThreadsManager(), null){

            protected void filterSelected(ThreadsPanel.Filter filter) {
                super.filterSelected(filter);
                ThreadsFeatureUI.this.shFilter.selectAction(filter.ordinal());
            }
        };
        this.threadsView.threadsMonitoringEnabled();
        this.threadsView.putClientProperty((Object)"HelpCtx.Key", (Object)"ProfileThreads.HelpCtx");
        this.shLabel = new GrayLabel(Bundle.ThreadsFeatureUI_show());
        AbstractAction aAll = new AbstractAction(){
            {
                this.putValue("Name", Bundle.ThreadsFeatureUI_filterAll());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadsFeatureUI.this.setFilter(ThreadsPanel.Filter.ALL);
            }
        };
        AbstractAction aLive = new AbstractAction(){
            {
                this.putValue("Name", Bundle.ThreadsFeatureUI_filterLive());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadsFeatureUI.this.setFilter(ThreadsPanel.Filter.LIVE);
            }
        };
        AbstractAction aFinished = new AbstractAction(){
            {
                this.putValue("Name", Bundle.ThreadsFeatureUI_filterFinished());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadsFeatureUI.this.setFilter(ThreadsPanel.Filter.FINISHED);
            }
        };
        AbstractAction aSelected = new AbstractAction(){
            {
                this.putValue("Name", Bundle.ThreadsFeatureUI_filterSelected());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadsFeatureUI.this.setSelectedFilter();
            }
        };
        this.shFilter = new ActionPopupButton(new Action[]{aAll, aLive, aFinished, aSelected});
        this.shFilter.setToolTipText(Bundle.ThreadsFeatureUI_threadsFilter());
        this.tlLabel = new GrayLabel(Bundle.ThreadsFeatureUI_timeline());
        this.tlZoomInButton = (JComponent)this.threadsView.getZoomIn();
        this.tlZoomInButton.putClientProperty("JButton.buttonType", "segmented");
        this.tlZoomInButton.putClientProperty("JButton.segmentPosition", "first");
        this.tlZoomOutButton = (JComponent)this.threadsView.getZoomOut();
        this.tlZoomOutButton.putClientProperty("JButton.buttonType", "segmented");
        this.tlZoomOutButton.putClientProperty("JButton.segmentPosition", "middle");
        this.tlFitWidthButton = (JComponent)this.threadsView.getFitWidth();
        this.tlFitWidthButton.putClientProperty("JButton.buttonType", "segmented");
        this.tlFitWidthButton.putClientProperty("JButton.segmentPosition", "last");
        this.toolbar = ProfilerToolbar.create((boolean)true);
        this.toolbar.addSpace(2);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.shLabel);
        this.toolbar.addSpace(2);
        this.toolbar.add((Component)this.shFilter);
        this.toolbar.addSpace(2);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.tlLabel);
        this.toolbar.addSpace(2);
        this.toolbar.add((Component)this.tlZoomInButton);
        this.toolbar.add((Component)this.tlZoomOutButton);
        this.toolbar.add((Component)this.tlFitWidthButton);
        this.setFilter(ThreadsPanel.Filter.LIVE);
        this.sessionStateChanged(this.getSessionState());
    }

    private void refreshToolbar(int state) {
    }

    private void setSelectedFilter() {
        if (this.threadsView.hasSelectedThreads()) {
            this.setFilter(ThreadsPanel.Filter.SELECTED);
        } else {
            this.threadsView.showSelectedColumn();
            this.shFilter.selectAction(this.threadsView.getFilter().ordinal());
            ProfilerDialogs.displayWarning((String)Bundle.ThreadsFeatureUI_noThreadsMsg());
        }
    }

    private void setFilter(ThreadsPanel.Filter filter) {
        this.threadsView.setFilter(filter);
    }
}

