/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.project;

import java.awt.Dialog;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.api.project.ProjectProfilingSupport;
import org.netbeans.modules.profiler.nbimpl.project.AntProjectSupport;
import org.netbeans.modules.profiler.nbimpl.project.Bundle;
import org.netbeans.modules.profiler.projectsupport.utilities.AppletSupport;
import org.netbeans.modules.profiler.utils.MainClassWarning;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.w3c.dom.Element;

@Deprecated
public final class ProjectUtilities {
    private static final Logger LOGGER = Logger.getLogger(ProjectUtilities.class.getName());
    public static final String PROFILER_NAME_SPACE = "http://www.netbeans.org/ns/profiler/1";
    private static final Pattern PROFILER_INIT = Pattern.compile("<\\s*target\\s+.*?name\\s*=\\s*\"profile-init\"", 40);

    public static String getDefaultPackageClassNames(Project project) {
        return org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.getDefaultPackageClassNames((Project)project);
    }

    public static boolean isJavaProject(Project project) {
        if (project == null) {
            return false;
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        return sourceGroups.length > 0;
    }

    public static Project getMainProject() {
        return OpenProjects.getDefault().getMainProject();
    }

    public static Project[] getOpenedProjects() {
        return OpenProjects.getDefault().getOpenProjects();
    }

    public static Project[] getOpenedProjectsForAttach() {
        Project[] projects = ProjectUtilities.getOpenedProjects();
        ArrayList<Project> projectsArray = new ArrayList<Project>(projects.length);
        for (int i = 0; i < projects.length; ++i) {
            if (!ProjectUtilities.isProjectTypeSupportedForAttach(projects[i])) continue;
            projectsArray.add(projects[i]);
        }
        return projectsArray.toArray(new Project[0]);
    }

    public static FileObject getOrCreateBuildFolder(Project project, String buildDirProp) {
        FileObject buildDir = FileUtil.toFileObject((File)PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)buildDirProp));
        if (buildDir == null) {
            try {
                buildDir = FileUtil.createFolder((FileObject)project.getProjectDirectory(), (String)buildDirProp);
            }
            catch (IOException e) {
                ErrorManager.getDefault().annotate((Throwable)e, Bundle.ProjectUtilities_FailedCreateOutputFolderMsg(e.getMessage()));
                ErrorManager.getDefault().notify(65536, (Throwable)e);
                return null;
            }
        }
        return buildDir;
    }

    public static boolean isProfilerIntegrated(Project project) {
        String buildXml = ProjectUtilities.getProjectBuildScript(project, "nbproject/build-impl.xml");
        Matcher m = PROFILER_INIT.matcher(buildXml);
        return m.find();
    }

    public static String getProjectBuildScript(Project project) {
        return ProjectUtilities.getProjectBuildScript(project, "build.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProjectBuildScript(Project project, String buildXml) {
        FileObject buildFile = AntProjectSupport.get((Lookup.Provider)project).getProjectBuildScript(buildXml);
        if (buildFile == null) {
            return null;
        }
        RandomAccessFile file = null;
        byte[] data = null;
        try {
            file = new RandomAccessFile(FileUtil.toFile((FileObject)buildFile), "r");
            data = new byte[(int)buildFile.getSize()];
            file.readFully(data);
        }
        catch (FileNotFoundException e2) {
            ProfilerLogger.log((Exception)e2);
            String string = null;
            return string;
        }
        catch (IOException e2) {
            ProfilerLogger.log((Exception)e2);
            String string = null;
            return string;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException e2) {
                    ProfilerLogger.log((Exception)e2);
                }
            }
        }
        return new String(data, StandardCharsets.UTF_8);
    }

    public static ClientUtils.SourceCodeSelection[] getProjectDefaultRoots(Project project, String[][] projectPackagesDescr) {
        ProjectUtilities.computeProjectPackages(project, true, projectPackagesDescr);
        ClientUtils.SourceCodeSelection[] ret = new ClientUtils.SourceCodeSelection[projectPackagesDescr[1].length];
        for (int i = 0; i < projectPackagesDescr[1].length; ++i) {
            ret[i] = "".equals(projectPackagesDescr[1][i]) ? new ClientUtils.SourceCodeSelection("", "", "") : new ClientUtils.SourceCodeSelection(projectPackagesDescr[1][i] + ".", "", "");
        }
        return ret;
    }

    public static Project getProjectForBuildScript(String fileName) {
        FileObject projectFO = FileUtil.toFileObject((File)new File(fileName));
        while (projectFO != null) {
            try {
                if (projectFO.isFolder()) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Trying: {0}", projectFO);
                    }
                    Project p = ProjectManager.getDefault().findProject(projectFO);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Got: {0}", p != null ? ProjectUtilities.getProjectName(p) : null);
                    }
                    if (p != null) {
                        return p;
                    }
                }
                projectFO = projectFO.getParent();
            }
            catch (IOException e) {
                ProfilerLogger.severe((String)("Got: IOException : " + e.getMessage()));
            }
        }
        return null;
    }

    public static Icon getProjectIcon(Project project) {
        ProjectInformation info = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
        if (info == null) {
            return new ImageIcon();
        }
        return info.getIcon();
    }

    public static String getProjectName(Project project) {
        ProjectInformation info = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
        if (info == null) {
            return Bundle.ProjectUtilities_UnknownProjectString();
        }
        return info.getDisplayName();
    }

    public static String[] getProjectPackages(Project project) {
        ArrayList<String> packages = new ArrayList<String>();
        for (FileObject root : ProjectUtilities.getSourceRoots(project, true)) {
            ProjectUtilities.addSubpackages(packages, "", root);
        }
        return packages.toArray(new String[0]);
    }

    public static boolean isProjectTypeSupported(Project project) {
        return ProjectProfilingSupport.get((Lookup.Provider)project).isProfilingSupported() || ProjectUtilities.hasAction(project, "profile");
    }

    public static boolean isProjectTypeSupportedForAttach(Project project) {
        return ProjectProfilingSupport.get((Lookup.Provider)project).isAttachSupported();
    }

    public static FileObject getRootOf(FileObject[] roots, FileObject file) {
        FileObject srcDir = null;
        for (int i = 0; i < roots.length; ++i) {
            if (!FileUtil.isParentOf((FileObject)roots[i], (FileObject)file)) continue;
            srcDir = roots[i];
            break;
        }
        return srcDir;
    }

    public static Project[] getSortedProjects(Project[] projects) {
        Project[] sorted = new Project[projects.length];
        System.arraycopy(projects, 0, sorted, 0, projects.length);
        Arrays.sort(sorted, new Comparator<Project>(){

            @Override
            public int compare(Project p1, Project p2) {
                return ProjectUtils.getInformation((Project)p1).getDisplayName().toLowerCase().compareTo(ProjectUtils.getInformation((Project)p2).getDisplayName().toLowerCase());
            }
        });
        return sorted;
    }

    public static FileObject[] getSourceRoots(Project project) {
        return ProjectUtilities.getSourceRoots(project, true);
    }

    public static FileObject[] getSourceRoots(Project project, boolean traverse) {
        HashSet<FileObject> set = new HashSet<FileObject>();
        HashSet<Project> projects = new HashSet<Project>();
        projects.add(project);
        ProjectUtilities.getSourceRoots(project, traverse, projects, set);
        return set.toArray(new FileObject[0]);
    }

    public static void computeProjectPackages(Project project, boolean subprojects, String[][] storage) {
        if (storage == null || storage.length != 2) {
            throw new IllegalArgumentException("Storage must be a non-null String[2][] array");
        }
        if (storage[0] == null) {
            ArrayList<String> packages1 = new ArrayList<String>();
            for (FileObject root : ProjectUtilities.getSourceRoots(project, false)) {
                ProjectUtilities.addSubpackages(packages1, "", root);
            }
            storage[0] = packages1.toArray(new String[0]);
        }
        if (subprojects && storage[1] == null) {
            FileObject[] srcRoots2 = ProjectUtilities.getSourceRoots(project, true);
            ArrayList<String> packages2 = new ArrayList<String>();
            for (FileObject root : srcRoots2) {
                ProjectUtilities.addSubpackages(packages2, "", root);
            }
            storage[1] = packages2.toArray(new String[0]);
        }
    }

    public static URL copyAppletHTML(Project project, PropertyEvaluator props, FileObject profiledClassFile, String value) {
        try {
            String buildDirProp = props.getProperty("build.dir");
            FileObject buildFolder = ProjectUtilities.getOrCreateBuildFolder(project, buildDirProp);
            FileObject htmlFile = profiledClassFile.getParent().getFileObject(profiledClassFile.getName(), "html");
            if (htmlFile == null) {
                htmlFile = profiledClassFile.getParent().getFileObject(profiledClassFile.getName(), "HTML");
            }
            if (htmlFile == null) {
                return null;
            }
            FileObject existingFile = buildFolder.getFileObject(htmlFile.getName(), htmlFile.getExt());
            if (existingFile != null) {
                existingFile.delete();
            }
            htmlFile.copy(buildFolder, profiledClassFile.getName(), value).getURL();
            return htmlFile.getURL();
        }
        catch (IOException e) {
            ErrorManager.getDefault().annotate((Throwable)e, Bundle.ProjectUtilities_FailedCopyAppletFileMsg(e.getMessage()));
            ErrorManager.getDefault().notify(65536, (Throwable)e);
            return null;
        }
    }

    public static void fetchSubprojects(Project project, Set<Project> projects) {
        SubprojectProvider spp = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
        if (spp != null) {
            for (Project p : spp.getSubprojects()) {
                if (p == null || !projects.add(p)) continue;
                ProjectUtilities.fetchSubprojects(p, projects);
            }
        }
    }

    public static URL generateAppletHTML(Project project, PropertyEvaluator props, FileObject profiledClassFile) {
        String buildDirProp = props.getProperty("build.dir");
        String classesDirProp = props.getProperty("build.classes.dir");
        String activePlatformName = props.getProperty("platform.active");
        FileObject buildFolder = ProjectUtilities.getOrCreateBuildFolder(project, buildDirProp);
        FileObject classesDir = FileUtil.toFileObject((File)PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)classesDirProp));
        if (classesDir == null) {
            try {
                classesDir = FileUtil.createFolder((FileObject)project.getProjectDirectory(), (String)classesDirProp);
            }
            catch (IOException e) {
                ErrorManager.getDefault().annotate((Throwable)e, Bundle.ProjectUtilities_FailedCreateClassesDirMsg(e.getMessage()));
                ErrorManager.getDefault().notify(65536, (Throwable)e);
                return null;
            }
        }
        try {
            return AppletSupport.generateHtmlFileURL((FileObject)profiledClassFile, (FileObject)buildFolder, (FileObject)classesDir, (String)activePlatformName);
        }
        catch (FileStateInvalidException e) {
            ErrorManager.getDefault().annotate((Throwable)e, Bundle.ProjectUtilities_FailedGenerateAppletFileMsg(e.getMessage()));
            ErrorManager.getDefault().notify(65536, (Throwable)e);
            return null;
        }
    }

    public static boolean hasAction(Project project, String actionName) {
        ActionProvider ap = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        if (ap == null) {
            return false;
        }
        String[] actions = ap.getSupportedActions();
        for (int i = 0; i < actions.length; ++i) {
            if (actions[i] == null || !actionName.equals(actions[i])) continue;
            return true;
        }
        return false;
    }

    public static void invokeAction(Project project, String s) {
        Lookup lkp;
        ActionProvider ap = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        if (ap == null) {
            return;
        }
        if (NetBeansProfiler.getDefaultNB().getProfiledSingleFile() != null) {
            try {
                lkp = new ProxyLookup(new Lookup[]{Lookup.getDefault(), Lookups.fixed((Object[])new Object[]{DataObject.find((FileObject)NetBeansProfiler.getDefaultNB().getProfiledSingleFile())})});
            }
            catch (DataObjectNotFoundException ex) {
                LOGGER.log(Level.WARNING, null, ex);
                lkp = Lookup.getDefault();
            }
        } else {
            lkp = Lookup.getDefault();
        }
        ap.invokeAction(s, lkp);
    }

    public static String selectMainClass(Project project, String mainClass, String projectName, int messageType) {
        boolean canceled;
        String message;
        final JButton okButton = new JButton(Bundle.LBL_MainClassWarning_ChooseMainClass_OK());
        okButton.getAccessibleContext().setAccessibleDescription(Bundle.AD_MainClassWarning_ChooseMainClass_OK());
        switch (messageType) {
            case -1: {
                message = Bundle.LBL_MainClassNotFound(projectName);
                break;
            }
            case -2: {
                message = Bundle.LBL_MainClassWrong(projectName);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        final MainClassWarning panel = new MainClassWarning(message, (Lookup.Provider)project);
        Object[] options = new Object[]{okButton, DialogDescriptor.CANCEL_OPTION};
        panel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)e.getSource()))) {
                    okButton.doClick();
                } else {
                    okButton.setEnabled(panel.getSelectedMainClass() != null);
                }
            }
        });
        okButton.setEnabled(false);
        DialogDescriptor desc = new DialogDescriptor((Object)panel, Bundle.CTL_MainClassWarning_Title(), true, options, options[0], 0, null, null);
        desc.setMessageType(1);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
        dlg.setVisible(true);
        if (desc.getValue() != options[0]) {
            canceled = true;
        } else {
            mainClass = panel.getSelectedMainClass();
            canceled = false;
        }
        dlg.dispose();
        if (canceled) {
            return null;
        }
        return mainClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unintegrateProfiler(Project project) {
        String projectName = ProjectUtils.getInformation((Project)project).getDisplayName();
        FileObject buildBackupFile = project.getProjectDirectory().getFileObject("build-before-profiler.xml");
        if (!ProjectUtilities.isProfilerIntegrated(project)) {
            return;
        }
        boolean failed = false;
        StringBuilder exceptionsReport = new StringBuilder();
        FileObject buildFile = AntProjectSupport.get((Lookup.Provider)project).getProjectBuildScript();
        if (buildBackupFile != null) {
            FileLock buildBackupFileLock = null;
            try {
                if (buildFile != null && buildBackupFile.isValid()) {
                    try {
                        buildBackupFileLock = buildBackupFile.lock();
                        if (buildFile.isValid()) {
                            buildFile.delete();
                        }
                        buildBackupFile.rename(buildBackupFileLock, "build", "xml");
                    }
                    catch (IOException e) {
                        failed = true;
                        exceptionsReport.append(Bundle.ProjectUtilities_RenamingBuildFailedMsg(e.getMessage()));
                        ProfilerLogger.log((Exception)e);
                    }
                }
            }
            finally {
                if (buildBackupFileLock != null) {
                    buildBackupFileLock.releaseLock();
                }
            }
            FileObject buildImplFile = project.getProjectDirectory().getFileObject("nbproject").getFileObject("profiler-build-impl.xml");
            try {
                if (buildImplFile != null && buildImplFile.isValid()) {
                    buildImplFile.delete();
                }
            }
            catch (IOException e) {
                failed = true;
                exceptionsReport.append(Bundle.ProjectUtilities_RemovingBuildFailedMsg(e.getMessage()));
                ProfilerLogger.log((Exception)e);
            }
        }
        try {
            ProjectUtils.getAuxiliaryConfiguration((Project)project).removeConfigurationFragment("data", PROFILER_NAME_SPACE, false);
        }
        catch (IllegalArgumentException iae) {
            failed = true;
            exceptionsReport.append(iae.getMessage());
            ProfilerLogger.log((Exception)iae);
        }
        try {
            ProjectManager.getDefault().saveProject(project);
        }
        catch (Exception e) {
            failed = true;
            exceptionsReport.append(Bundle.ProjectUtilities_RemovingDataFailedMsg(e.getMessage()));
            ProfilerLogger.log((Exception)e);
        }
        if (failed) {
            ProfilerLogger.warning((String)Bundle.ProjectUtilities_UnintegrationErrorsOccuredMsg(projectName, exceptionsReport.toString()));
        }
    }

    private static void getSourceRoots(Project project, boolean traverse, Set<Project> projects, Set<FileObject> roots) {
        SubprojectProvider spp;
        Sources sources = ProjectUtils.getSources((Project)project);
        for (SourceGroup sg : sources.getSourceGroups("java")) {
            roots.add(sg.getRootFolder());
        }
        if (traverse && (spp = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class)) != null) {
            for (Project p : spp.getSubprojects()) {
                if (!projects.add(p)) continue;
                ProjectUtilities.getSourceRoots(p, traverse, projects, roots);
            }
        }
    }

    private static void addSubpackages(ArrayList<String> packages, String prefix, FileObject packageFO) {
        FileObject child;
        int i;
        if (!packageFO.isFolder()) {
            return;
        }
        FileObject[] children = packageFO.getChildren();
        if (!packages.contains(prefix)) {
            for (i = 0; i < children.length; ++i) {
                child = children[i];
                if (!child.getExt().equals("java")) continue;
                packages.add(prefix);
                break;
            }
        }
        for (i = 0; i < children.length; ++i) {
            child = children[i];
            if (!child.isFolder()) continue;
            if ("".equals(prefix)) {
                ProjectUtilities.addSubpackages(packages, child.getName(), child);
                continue;
            }
            ProjectUtilities.addSubpackages(packages, prefix + "." + child.getName(), child);
        }
    }

    public static final class IntegrationUpdater
    extends ProjectOpenedHook {
        private Project prj;

        public IntegrationUpdater(Project prj) {
            this.prj = prj;
        }

        protected void projectClosed() {
        }

        protected void projectOpened() {
            Element e = ProjectUtils.getAuxiliaryConfiguration((Project)this.prj).getConfigurationFragment("data", ProjectUtilities.PROFILER_NAME_SPACE, false);
            if (e != null) {
                ProjectUtilities.unintegrateProfiler(this.prj);
            }
        }
    }
}

