/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.javac;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.api.java.SourceMethodInfo;
import org.netbeans.modules.profiler.nbimpl.javac.ElementUtilitiesEx;
import org.netbeans.modules.profiler.nbimpl.javac.JavacMethodInfo;
import org.openide.filesystems.FileObject;

public class JavacClassInfo
extends SourceClassInfo {
    private static final Logger LOG = Logger.getLogger(JavacClassInfo.class.getName());
    private ElementHandle<TypeElement> handle;
    private FileObject src;
    private ClasspathInfo cpInfo;
    private Reference<JavaSource> sourceRef;

    private JavacClassInfo(ElementHandle<TypeElement> eh) {
        super(JavacClassInfo.getSimpleName(eh.getBinaryName()), eh.getBinaryName(), eh.getBinaryName().replace('.', '/'));
        this.handle = eh;
    }

    public JavacClassInfo(ElementHandle<TypeElement> eh, ClasspathInfo cpInfo) {
        this(eh);
        this.cpInfo = cpInfo;
    }

    public JavacClassInfo(ElementHandle<TypeElement> eh, CompilationController cc) {
        this(eh);
        this.cpInfo = cc.getClasspathInfo();
        this.sourceRef = new SoftReference<JavaSource>(cc.getJavaSource());
    }

    public Set<SourceMethodInfo> getMethods(final boolean all) {
        final Set[] rslt = new Set[1];
        if (this.handle != null) {
            try {
                this.getSource(false).runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController cc) throws Exception {
                        if (cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED) == JavaSource.Phase.ELEMENTS_RESOLVED) {
                            rslt[0] = JavacClassInfo.this.getMethods(cc, all);
                        }
                    }
                }, true);
            }
            catch (IllegalArgumentException e) {
                LOG.log(Level.WARNING, null, e);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, null, e);
            }
        }
        return rslt[0] != null ? rslt[0] : Collections.EMPTY_SET;
    }

    public Set<SourceClassInfo> getSubclasses() {
        HashSet<SourceClassInfo> rslt = new HashSet<SourceClassInfo>();
        if (this.handle != null) {
            try {
                JavaSource s = this.getSource(true);
                if (s != null) {
                    for (ElementHandle<TypeElement> eh : ElementUtilitiesEx.findImplementors(s.getClasspathInfo(), this.handle)) {
                        rslt.add(new JavacClassInfo(eh));
                    }
                }
            }
            catch (IllegalArgumentException e) {
                LOG.log(Level.WARNING, null, e);
            }
        }
        return rslt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject getFile() {
        ElementHandle<TypeElement> eh = this.handle;
        ClasspathInfo ci = this.cpInfo;
        JavacClassInfo javacClassInfo = this;
        synchronized (javacClassInfo) {
            if (this.src == null) {
                this.src = SourceUtils.getFile(eh, (ClasspathInfo)ci);
                if (this.src == null) {
                    String resName = eh.getBinaryName().replace('.', '/').concat(".class");
                    this.src = ci.getClassPath(ClasspathInfo.PathKind.BOOT).findResource(resName);
                    if (this.src == null) {
                        this.src = ci.getClassPath(ClasspathInfo.PathKind.COMPILE).findResource(resName);
                        if (this.src == null) {
                            this.src = ci.getClassPath(ClasspathInfo.PathKind.SOURCE).findResource(resName);
                        }
                    }
                }
            }
            return this.src;
        }
    }

    public Set<SourceMethodInfo> getConstructors() {
        final HashSet<SourceMethodInfo> infos = new HashSet<SourceMethodInfo>();
        if (this.handle != null) {
            try {
                JavaSource s = this.getSource(false);
                if (s != null) {
                    s.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController cc) throws Exception {
                            TypeElement type;
                            if (cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED) == JavaSource.Phase.ELEMENTS_RESOLVED && (type = (TypeElement)JavacClassInfo.this.handle.resolve((CompilationInfo)cc)) != null) {
                                for (ExecutableElement method : ElementFilter.constructorsIn(type.getEnclosedElements())) {
                                    infos.add(new JavacMethodInfo(method, cc));
                                }
                            }
                        }
                    }, true);
                }
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, null, e);
            }
        }
        return infos;
    }

    public Set<SourceClassInfo> getInnerClases() {
        final HashSet<SourceClassInfo> innerClasses = new HashSet<SourceClassInfo>();
        if (this.handle != null) {
            try {
                JavaSource s = this.getSource(false);
                if (s != null) {
                    s.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController cc) throws Exception {
                            if (cc.toPhase(JavaSource.Phase.RESOLVED) != JavaSource.Phase.RESOLVED) {
                                return;
                            }
                            TypeElement type = (TypeElement)JavacClassInfo.this.handle.resolve((CompilationInfo)cc);
                            if (type != null) {
                                List<TypeElement> elements = ElementFilter.typesIn(type.getEnclosedElements());
                                for (TypeElement element : elements) {
                                    innerClasses.add(new JavacClassInfo((ElementHandle<TypeElement>)ElementHandle.create((Element)element), cc));
                                }
                                JavacClassInfo.this.addAnonymousInnerClasses(cc, innerClasses);
                            }
                        }
                    }, true);
                }
            }
            catch (IllegalArgumentException ex) {
                LOG.log(Level.WARNING, null, ex);
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, null, ex);
            }
        }
        return innerClasses;
    }

    public Set<SourceClassInfo> getInterfaces() {
        final HashSet<SourceClassInfo> ifcs = new HashSet<SourceClassInfo>();
        if (this.handle != null) {
            try {
                JavaSource s = this.getSource(false);
                if (s != null) {
                    s.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController cc) throws Exception {
                            cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            TypeElement te = (TypeElement)JavacClassInfo.this.handle.resolve((CompilationInfo)cc);
                            Types t = cc.getTypes();
                            if (te != null) {
                                for (TypeMirror typeMirror : te.getInterfaces()) {
                                    TypeElement ife = (TypeElement)t.asElement(typeMirror);
                                    ifcs.add(new JavacClassInfo((ElementHandle<TypeElement>)ElementHandle.create((Element)ife), cc));
                                }
                            }
                        }
                    }, true);
                }
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, null, e);
            }
        }
        return ifcs;
    }

    public SourceClassInfo getSuperType() {
        final SourceClassInfo[] rslt = new SourceClassInfo[1];
        if (this.handle != null) {
            try {
                JavaSource s = this.getSource(false);
                if (s != null) {
                    s.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController cc) throws Exception {
                            TypeElement superType;
                            TypeMirror superTm;
                            TypeElement te;
                            if (cc.toPhase(JavaSource.Phase.RESOLVED) == JavaSource.Phase.RESOLVED && (te = (TypeElement)JavacClassInfo.this.handle.resolve((CompilationInfo)cc)) != null && (superTm = te.getSuperclass()) != null && (superType = (TypeElement)cc.getTypes().asElement(superTm)) != null) {
                                rslt[0] = new JavacClassInfo((ElementHandle<TypeElement>)ElementHandle.create((Element)superType), cc);
                            }
                        }
                    }, true);
                }
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, null, e);
            }
        }
        return rslt[0];
    }

    private Set<SourceMethodInfo> getMethods(CompilationController cc, boolean all) {
        HashSet<SourceMethodInfo> mis = new HashSet<SourceMethodInfo>();
        TypeElement te = (TypeElement)this.handle.resolve((CompilationInfo)cc);
        if (te != null) {
            HashSet<ExecutableElement> methods = new HashSet<ExecutableElement>(ElementFilter.methodsIn(te.getEnclosedElements()));
            for (ExecutableElement method : ElementFilter.methodsIn(cc.getElements().getAllMembers(te))) {
                String parent = ElementUtilities.getBinaryName((TypeElement)((TypeElement)method.getEnclosingElement()));
                if (!parent.equals(this.getQualifiedName()) && (!all || JavacClassInfo.containsAny(method.getModifiers(), EnumSet.of(Modifier.PRIVATE, Modifier.FINAL)) || parent.equals(Object.class.getName()))) continue;
                methods.add(method);
            }
            for (ExecutableElement method : methods) {
                mis.add(new JavacMethodInfo(method, cc));
            }
        }
        return mis;
    }

    private static String getSimpleName(String qualName) {
        String name = qualName;
        int lastDot = name.lastIndexOf(46);
        if (lastDot > -1) {
            name = name.substring(lastDot + 1);
        }
        return name;
    }

    public String toString() {
        return this.getQualifiedName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        JavacClassInfo other = (JavacClassInfo)((Object)obj);
        if (!(this.handle == other.handle || this.handle != null && this.handle.equals(other.handle))) {
            return false;
        }
        JavacClassInfo javacClassInfo = this;
        synchronized (javacClassInfo) {
            if (this.src != null && this.src != other.src && !this.src.equals(other.src)) {
                return false;
            }
        }
        return this.cpInfo == null || this.cpInfo == other.cpInfo || this.cpInfo.toString().equals(other.cpInfo.toString());
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.handle != null ? this.handle.hashCode() : 0);
        hash = 89 * hash + (this.src != null ? this.src.hashCode() : 0);
        hash = 89 * hash + (this.cpInfo != null ? this.cpInfo.hashCode() : 0);
        return hash;
    }

    private void addAnonymousInnerClasses(final CompilationController cc, final Set<SourceClassInfo> innerClasses) throws IOException {
        final int parentClassNameLength = this.getQualifiedName().length();
        cc.toPhase(JavaSource.Phase.RESOLVED);
        ErrorAwareTreePathScanner<Void, Void> scanner = new ErrorAwareTreePathScanner<Void, Void>(){

            public Void visitClass(ClassTree node, Void v) {
                TypeElement innerClassElement;
                String className;
                Element classElement = cc.getTrees().getElement(this.getCurrentPath());
                if (classElement != null && classElement.getKind() == ElementKind.CLASS && JavacClassInfo.this.isAnonymous(className = (className = ElementUtilities.getBinaryName((TypeElement)(innerClassElement = (TypeElement)classElement))).length() <= parentClassNameLength ? "" : className.substring(parentClassNameLength))) {
                    innerClasses.add(new JavacClassInfo((ElementHandle<TypeElement>)ElementHandle.create((Element)innerClassElement), cc));
                }
                super.visitClass(node, (Object)v);
                return null;
            }
        };
        scanner.scan((Tree)cc.getCompilationUnit(), null);
    }

    private static <T> boolean containsAny(Set<T> superSet, Set<T> subSet) {
        HashSet<T> set = new HashSet<T>(superSet);
        return set.removeAll(subSet);
    }

    private synchronized JavaSource getSource(boolean allowSourceLess) {
        JavaSource jSrc;
        JavaSource javaSource = jSrc = this.sourceRef != null ? this.sourceRef.get() : null;
        if (jSrc == null || !allowSourceLess && jSrc.getFileObjects().isEmpty()) {
            FileObject f = this.getFile();
            if (f.getExt().equalsIgnoreCase("java") || f.getExt().equalsIgnoreCase("class")) {
                jSrc = this.cpInfo != null ? JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[]{f}) : JavaSource.forFileObject((FileObject)f);
            } else if (this.cpInfo != null) {
                jSrc = JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[0]);
            }
            this.sourceRef = new SoftReference<JavaSource>(jSrc);
        }
        return jSrc;
    }
}

